/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;

public abstract class SymbolType {
    public static final SymbolType LABEL;
    @Deprecated(since="9.1", forRemoval=true)
    public static final SymbolType CODE;
    public static final SymbolType LIBRARY;
    public static final SymbolType NAMESPACE;
    public static final SymbolType CLASS;
    public static final SymbolType FUNCTION;
    public static final SymbolType PARAMETER;
    public static final SymbolType LOCAL_VAR;
    public static final SymbolType GLOBAL_VAR;
    public static final SymbolType GLOBAL;
    private static final SymbolType[] types;
    private final String name;
    private final byte value;
    private final boolean isNamespace;

    private SymbolType(String name, boolean isNamespace, int value) {
        this.name = name;
        this.isNamespace = isNamespace;
        this.value = (byte)value;
    }

    public abstract boolean isValidParent(Program var1, Namespace var2, Address var3, boolean var4);

    public abstract boolean isValidAddress(Program var1, Address var2);

    public abstract boolean isValidSourceType(SourceType var1, Address var2);

    public boolean allowsDuplicates() {
        return false;
    }

    public boolean isNamespace() {
        return this.isNamespace;
    }

    public String toString() {
        return this.name;
    }

    public byte getID() {
        return this.value;
    }

    public static SymbolType getSymbolType(int id) {
        if (id == -1) {
            return GLOBAL;
        }
        if (id < 0 || id >= types.length) {
            return null;
        }
        return types[id];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNamespace ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SymbolType)) {
            return false;
        }
        SymbolType other = (SymbolType)obj;
        if (this.isNamespace != other.isNamespace) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.value == other.value;
    }

    static {
        CODE = LABEL = new SymbolType("Label", false, 0){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                boolean externalParent = parent.isExternal();
                if (symbolAddr.isExternalAddress() != externalParent) {
                    return false;
                }
                if (parent.getID() != 0L && program != parent.getSymbol().getProgram()) {
                    return false;
                }
                return !(parent instanceof Function) || !externalParent;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress.isMemoryAddress() || symbolAddress.isExternalAddress();
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                if (sourceType != SourceType.DEFAULT) {
                    return true;
                }
                return symbolAddress.isExternalAddress();
            }

            @Override
            public boolean allowsDuplicates() {
                return true;
            }
        };
        LIBRARY = new SymbolType("Library", true, 1){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                return parent.getID() == 0L;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress == Address.NO_ADDRESS;
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return sourceType != SourceType.DEFAULT;
            }
        };
        NAMESPACE = new SymbolType("Namespace", true, 3){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                boolean isExternalParent = parent.isExternal();
                if (isExternalSymbol != isExternalParent) {
                    return false;
                }
                return parent.getID() == 0L || program == parent.getSymbol().getProgram();
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress == Address.NO_ADDRESS;
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return sourceType != SourceType.DEFAULT;
            }
        };
        CLASS = new SymbolType("Class", true, 4){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                if (isExternalSymbol != parent.isExternal()) {
                    return false;
                }
                if (parent.getID() != 0L && program != parent.getSymbol().getProgram()) {
                    return false;
                }
                while (parent.getID() != 0L) {
                    if (parent instanceof Function) {
                        return false;
                    }
                    parent = parent.getParentNamespace();
                }
                return true;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress == Address.NO_ADDRESS;
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return sourceType != SourceType.DEFAULT;
            }
        };
        FUNCTION = new SymbolType("Function", true, 5){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                if (symbolAddr.isExternalAddress() != parent.isExternal()) {
                    return false;
                }
                if (parent.getID() != 0L && program != parent.getSymbol().getProgram()) {
                    return false;
                }
                while (parent.getID() != 0L) {
                    if (parent instanceof Function) {
                        return false;
                    }
                    parent = parent.getParentNamespace();
                }
                return true;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress.isMemoryAddress() || symbolAddress.isExternalAddress();
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return true;
            }

            @Override
            public boolean allowsDuplicates() {
                return true;
            }
        };
        PARAMETER = new SymbolType("Parameter", false, 6){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                if (parent instanceof Function) {
                    return program == parent.getSymbol().getProgram();
                }
                return false;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress.isVariableAddress();
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return true;
            }
        };
        LOCAL_VAR = new SymbolType("Local Var", false, 7){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                if (parent instanceof Function) {
                    return program == parent.getSymbol().getProgram();
                }
                return false;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress.isVariableAddress();
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return true;
            }
        };
        GLOBAL_VAR = new SymbolType("Global Register Var", false, 8){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                return parent.getID() == 0L;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return symbolAddress.isVariableAddress();
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return sourceType != SourceType.DEFAULT;
            }
        };
        GLOBAL = new SymbolType("Global", true, -1){

            @Override
            public boolean isValidParent(Program program, Namespace parent, Address symbolAddr, boolean isExternalSymbol) {
                return false;
            }

            @Override
            public boolean isValidAddress(Program program, Address symbolAddress) {
                return false;
            }

            @Override
            public boolean isValidSourceType(SourceType sourceType, Address symbolAddress) {
                return sourceType != SourceType.DEFAULT;
            }
        };
        types = new SymbolType[]{LABEL, LIBRARY, null, NAMESPACE, CLASS, FUNCTION, PARAMETER, LOCAL_VAR, GLOBAL_VAR};
    }
}

