/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangOpToken;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintAbstractDecompilerAction;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class TaintSourceAction
extends TaintAbstractDecompilerAction {
    private TaintPlugin plugin;
    private TaintState.MarkType mtype;

    public TaintSourceAction(TaintPlugin plugin) {
        super("Mark Source");
        this.setHelpLocation(new HelpLocation("DecompilerTaint", "TaintSource"));
        this.setPopupMenuData(new MenuData(new String[]{"Taint", "Source"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(83, 0));
        this.plugin = plugin;
        this.mtype = TaintState.MarkType.SOURCE;
    }

    protected void mark(ClangToken token) {
        this.plugin.toggleIcon(this.mtype, token, false);
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (this.plugin.getTaintState() == null) {
            return false;
        }
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return true;
        }
        if (tokenAtCursor.Parent() instanceof ClangReturnType) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return true;
        }
        if (tokenAtCursor instanceof ClangOpToken) {
            return true;
        }
        return tokenAtCursor.isVariableRef();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangOpToken) {
            this.markOp(tokenAtCursor);
        } else {
            this.mark(tokenAtCursor);
        }
    }

    private void markOp(ClangToken tokenAtCursor) {
        ClangLine line = tokenAtCursor.getLineParent();
        for (ClangToken token : line.getAllTokens()) {
            Varnode varnode;
            ClangVariableToken varToken;
            if (!(token instanceof ClangVariableToken) || !(varToken = (ClangVariableToken)token).isVariableRef() || (varnode = varToken.getVarnode()).isConstant()) continue;
            this.mark((ClangToken)varToken);
        }
    }
}

