/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.progmgr.AbstractProgramNameSwitchingAction;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import javax.swing.Icon;
import resources.Icons;

public class SaveProgramAction
extends AbstractProgramNameSwitchingAction {
    public SaveProgramAction(ProgramManagerPlugin plugin, String group, int subGroup) {
        super(plugin, "Save File");
        MenuData menuData = new MenuData(new String[]{"&File", "Save File"});
        menuData.setMenuGroup(group);
        menuData.setMenuSubGroup(Integer.toString(subGroup));
        this.setMenuBarData(menuData);
        Icon icon = Icons.SAVE_ICON;
        this.setToolBarData(new ToolBarData(icon, "1_Toolbar_Navigation_Group"));
        this.setKeyBindingData(new KeyBindingData("ctrl S"));
    }

    @Override
    protected void programChanged(Program program) {
        if (program == null) {
            this.getMenuBarData().setMenuItemName("&Save");
            this.setDescription("Save Program");
        } else {
            String progName = program.getDomainFile().getName();
            this.getMenuBarData().setMenuItemNamePlain("Save '%s'".formatted(progName));
            this.getMenuBarData().setMnemonic(Character.valueOf('S'));
            this.setDescription("<html>Save '%s'".formatted(HTMLUtilities.escapeHTML((String)progName)));
        }
    }

    @Override
    public boolean isEnabledForContext(Program program) {
        return program != null && program.isChanged();
    }

    @Override
    public void actionPerformed(Program program) {
        this.plugin.saveProgram(program);
    }
}

