/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.search.SearchScopeOptions;
import org.openide.util.Parameters;

public final class RegexpUtil {
    private RegexpUtil() {
    }

    private static String makeMultiRegexp(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (Pattern.matches("[a-zA-Z0-9]*", string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (char c : string.toCharArray()) {
            if (bl2) {
                if (c == 'n' || RegexpUtil.isSpecialCharacter(c)) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
                bl2 = false;
                continue;
            }
            if (c == ',' || c == ' ') {
                if (bl3) {
                    stringBuilder.append('.').append('*');
                    bl3 = false;
                }
                bl = true;
                continue;
            }
            if (bl && stringBuilder.length() != 0) {
                stringBuilder.append('|');
            }
            if (c == '?') {
                stringBuilder.append('.');
            } else if (c == '*') {
                bl3 = true;
            } else {
                if (bl3) {
                    stringBuilder.append('.').append('*');
                    bl3 = false;
                }
                if (c == '\\') {
                    bl2 = true;
                } else {
                    if (RegexpUtil.isSpecialCharacter(c)) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                }
            }
            bl = false;
        }
        if (bl2) {
            stringBuilder.append('\\').append('\\');
        } else if (bl3) {
            stringBuilder.append('.').append('*');
        }
        return stringBuilder.toString();
    }

    private static Pattern compileSimpleFileNamePattern(String string) throws PatternSyntaxException {
        assert (string != null);
        return Pattern.compile(RegexpUtil.makeMultiRegexp(string), 2);
    }

    private static Pattern compileRegexpFileNamePattern(String string) throws PatternSyntaxException {
        assert (string != null);
        return Pattern.compile(string, 2);
    }

    private static boolean isSpecialCharacter(char c) {
        return c > ' ' && c < '\u0080' && !RegexpUtil.isAlnum(c);
    }

    private static boolean isAlnum(char c) {
        return RegexpUtil.isAlpha(c) || RegexpUtil.isDigit(c);
    }

    private static boolean isAlpha(char c) {
        return (c = (char)(c | 0x20)) >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static Pattern makeFileNamePattern(@NonNull SearchScopeOptions searchScopeOptions) throws PatternSyntaxException {
        Parameters.notNull((CharSequence)"searchScopeOptions", (Object)searchScopeOptions);
        if (searchScopeOptions.isRegexp()) {
            return RegexpUtil.compileRegexpFileNamePattern(searchScopeOptions.getPattern());
        }
        return RegexpUtil.compileSimpleFileNamePattern(searchScopeOptions.getPattern());
    }
}

