/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.kde;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;

public class KdeNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(KdeNetworkProxy.class.getName());
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String SQ_BRACKET_LEFT = "[";
    private static final String HOME = "HOME";
    private static final String KIOSLAVERC_PROXY_SETTINGS_GROUP = "[Proxy Settings]";
    private static final String KIOSLAVERC_PROXY_TYPE = "ProxyType";
    private static final String KIOSLAVERC_PROXY_CONFIG_SCRIPT = "Proxy Config Script";
    private static final String KIOSLAVERC_HTTP_PROXY = "httpProxy";
    private static final String KIOSLAVERC_HTTPS_PROXY = "httpsProxy";
    private static final String KIOSLAVERC_SOCKS_PROXY = "socksProxy";
    private static final String KIOSLAVERC_NO_PROXY_FOR = "NoProxyFor";
    private static final String KIOSLAVERC_PROXY_TYPE_NONE = "0";
    private static final String KIOSLAVERC_PROXY_TYPE_MANUAL = "1";
    private static final String KIOSLAVERC_PROXY_TYPE_PAC = "2";
    private static final String KIOSLAVERC_PROXY_TYPE_AUTO = "3";
    private static final String KIOSLAVERC_PROXY_TYPE_SYSTEM = "4";
    private static final String KIOSLAVERC_PATH_IN_HOME = ".config/kioslaverc";
    private static final String KIOSLAVERC_PATH_IN_HOME_KDE4 = ".kde/share/config/kioslaverc";
    private final List<Path> KIOSLAVERC_PATHS = this.getKioslavercPaths();

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "KDE system proxy resolver started.");
        Map<String, String> map = this.getKioslavercMap();
        String string = map.get(KIOSLAVERC_PROXY_TYPE);
        if (string == null) {
            LOGGER.log(Level.WARNING, "KDE system proxy resolver: The kioslaverc key not found ({0})", KIOSLAVERC_PROXY_TYPE);
            return new NetworkProxySettings(false);
        }
        if (string.equals(KIOSLAVERC_PROXY_TYPE_NONE)) {
            LOGGER.log(Level.INFO, "KDE system proxy resolver: direct (proxy type: {0})", string);
            return new NetworkProxySettings();
        }
        if (string.equals(KIOSLAVERC_PROXY_TYPE_PAC) || string.equals(KIOSLAVERC_PROXY_TYPE_AUTO)) {
            String string2;
            if (string.equals(KIOSLAVERC_PROXY_TYPE_AUTO)) {
                LOGGER.log(Level.INFO, "KDE system proxy resolver: auto");
                string2 = "http://wpad/wpad.dat";
            } else {
                LOGGER.log(Level.INFO, "KDE system proxy resolver: auto - PAC");
                string2 = map.get(KIOSLAVERC_PROXY_CONFIG_SCRIPT);
            }
            if (string2 != null) {
                LOGGER.log(Level.INFO, "KDE system proxy resolver: PAC URL ({0})", string2);
                return new NetworkProxySettings(string2);
            }
            LOGGER.log(Level.INFO, "KDE system proxy resolver: PAC URL null value");
            return new NetworkProxySettings(false);
        }
        if (string.equals(KIOSLAVERC_PROXY_TYPE_MANUAL) || string.equals(KIOSLAVERC_PROXY_TYPE_SYSTEM)) {
            LOGGER.log(Level.INFO, "KDE system proxy resolver: manual (proxy type: {0})", string);
            String string3 = map.get(KIOSLAVERC_HTTP_PROXY);
            String string4 = map.get(KIOSLAVERC_HTTPS_PROXY);
            String string5 = map.get(KIOSLAVERC_SOCKS_PROXY);
            String string6 = map.get(KIOSLAVERC_NO_PROXY_FOR);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: http proxy ({0})", string3);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: https proxy ({0})", string4);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: socks proxy ({0})", string5);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: no proxy ({0})", string6);
            if (string.equals(KIOSLAVERC_PROXY_TYPE_MANUAL)) {
                string3 = string3 == null ? EMPTY_STRING : string3.trim().replaceAll(SPACE, COLON);
                string4 = string4 == null ? EMPTY_STRING : string4.trim().replaceAll(SPACE, COLON);
                string5 = string5 == null ? EMPTY_STRING : string5.trim().replaceAll(SPACE, COLON);
            }
            String[] stringArray = KdeNetworkProxy.getNoProxyHosts(string6);
            return new NetworkProxySettings(string3, string4, string5, stringArray);
        }
        return new NetworkProxySettings(false);
    }

    private Map<String, String> getKioslavercMap() {
        boolean bl = false;
        for (Path path : this.KIOSLAVERC_PATHS) {
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            bl = true;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            boolean bl2 = false;
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                String string;
                boolean bl3 = false;
                while ((string = bufferedReader.readLine()) != null) {
                    if (bl3) {
                        if (string.contains(EQUALS)) {
                            int n = string.indexOf(EQUALS);
                            String string2 = string.substring(0, n);
                            String string3 = string.substring(n + 1);
                            hashMap.put(string2, string3);
                            continue;
                        }
                        if (!string.startsWith(SQ_BRACKET_LEFT)) continue;
                        break;
                    }
                    if (!string.startsWith(KIOSLAVERC_PROXY_SETTINGS_GROUP)) continue;
                    bl3 = true;
                    bl2 = true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.log(Level.SEVERE, "Cannot read file: ", fileNotFoundException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Cannot read file: ", iOException);
            }
            if (!bl2) continue;
            return hashMap;
        }
        if (bl) {
            LOGGER.log(Level.WARNING, "KDE system proxy resolver: The kioslaverc file does not contain proxy configuration ({0})", this.KIOSLAVERC_PATHS);
        } else {
            LOGGER.log(Level.WARNING, "KDE system proxy resolver: The kioslaverc file not found ({0})", this.KIOSLAVERC_PATHS);
        }
        return Collections.emptyMap();
    }

    private List<Path> getKioslavercPaths() {
        String string = System.getenv(HOME);
        if (string != null) {
            return Arrays.asList(Paths.get(string, KIOSLAVERC_PATH_IN_HOME), Paths.get(string, KIOSLAVERC_PATH_IN_HOME_KDE4));
        }
        return Collections.emptyList();
    }

    private static String[] getNoProxyHosts(String string) {
        if (string != null && !string.isEmpty()) {
            return string.split(COMMA);
        }
        return new String[0];
    }
}

