/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;

class ByteUtil {
    private ByteUtil() {
    }

    static boolean isBit7Set(byte by) {
        return (by & 0x80) != 0;
    }

    static int get31Bits(byte[] byArray, int n) {
        return ((byArray[n] & 0x7F) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    static int get31Bits(ByteBuffer byteBuffer, int n) {
        return ((byteBuffer.get(n) & 0x7F) << 24) + ((byteBuffer.get(n + 1) & 0xFF) << 16) + ((byteBuffer.get(n + 2) & 0xFF) << 8) + (byteBuffer.get(n + 3) & 0xFF);
    }

    static void set31Bits(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)((n2 & 0x7F000000) >> 24);
        byArray[n + 1] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n + 2] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    static int getOneByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    static int getOneByte(ByteBuffer byteBuffer, int n) {
        return byteBuffer.get(n) & 0xFF;
    }

    static int getTwoBytes(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    static int getThreeBytes(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
    }

    static int getThreeBytes(ByteBuffer byteBuffer, int n) {
        return ((byteBuffer.get(n) & 0xFF) << 16) + ((byteBuffer.get(n + 1) & 0xFF) << 8) + (byteBuffer.get(n + 2) & 0xFF);
    }

    static void setTwoBytes(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    static void setThreeBytes(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n + 1] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 2] = (byte)(n2 & 0xFF);
    }

    static long getFourBytes(byte[] byArray, int n) {
        return ((long)(byArray[n] & 0xFF) << 24) + (long)((byArray[n + 1] & 0xFF) << 16) + (long)((byArray[n + 2] & 0xFF) << 8) + (long)(byArray[n + 3] & 0xFF);
    }

    static void setFourBytes(byte[] byArray, int n, long l) {
        byArray[n] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
        byArray[n + 1] = (byte)((l & 0xFF0000L) >> 16);
        byArray[n + 2] = (byte)((l & 0xFF00L) >> 8);
        byArray[n + 3] = (byte)(l & 0xFFL);
    }
}

