/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;
import org.apache.solr.analytics.stream.reservation.read.ReductionDataReader;
import org.apache.solr.analytics.stream.reservation.write.ReductionDataWriter;

public class ReductionCollectionManager {
    protected final ReductionDataCollector<?>[] reductionDataCollectors;
    private final List<ReductionDataReservation<?, ?>> reservations;
    private final List<ReductionDataReader<?>> readers;
    private final List<ReductionDataWriter<?>> writers;
    private final Iterable<AnalyticsField> fields;

    public ReductionCollectionManager() {
        this(new ReductionDataCollector[0], new ArrayList<AnalyticsField>(0));
    }

    public ReductionCollectionManager(ReductionDataCollector<?>[] reductionDataCollectors, Iterable<AnalyticsField> fields) {
        this.reductionDataCollectors = reductionDataCollectors;
        Arrays.sort(reductionDataCollectors, (a, b) -> a.getExpressionStr().compareTo(b.getExpressionStr()));
        this.reservations = new ArrayList();
        for (int i = 0; i < reductionDataCollectors.length; ++i) {
            reductionDataCollectors[i].submitReservations(reservation -> this.reservations.add((ReductionDataReservation<?, ?>)reservation));
        }
        this.fields = fields;
        this.readers = new ArrayList();
        this.writers = new ArrayList();
    }

    public boolean needsCollection() {
        return this.reductionDataCollectors.length > 0;
    }

    public ReductionCollectionManager merge(Iterable<ReductionCollectionManager> reductionManagers) {
        HashMap mergedCollectors = new HashMap();
        HashMap mergedFields = new HashMap();
        for (ReductionDataCollector<?> collector : this.reductionDataCollectors) {
            mergedCollectors.put(collector.getExpressionStr(), collector);
        }
        this.fields.forEach(field -> mergedFields.put(field.getExpressionStr(), field));
        reductionManagers.forEach(manager -> {
            for (ReductionDataCollector<?> collector : manager.reductionDataCollectors) {
                mergedCollectors.put(collector.getExpressionStr(), collector);
            }
            manager.fields.forEach(field -> mergedFields.put(field.getExpressionStr(), field));
        });
        ReductionDataCollector[] collectors = new ReductionDataCollector[mergedCollectors.size()];
        mergedCollectors.values().toArray(collectors);
        return this.createNewManager(collectors, mergedFields.values());
    }

    protected ReductionCollectionManager createNewManager(ReductionDataCollector<?>[] reductionDataCollectors, Iterable<AnalyticsField> fields) {
        return new ReductionCollectionManager(reductionDataCollectors, fields);
    }

    public Iterable<AnalyticsField> getUsedFields() {
        return this.fields;
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        for (AnalyticsField field : this.fields) {
            field.doSetNextReader(context);
        }
    }

    public void collect(int doc) throws IOException {
        for (AnalyticsField field : this.fields) {
            field.collect(doc);
        }
    }

    public void addLastingCollectTarget(ReductionDataCollection target) {
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            this.reductionDataCollectors[i].addLastingCollectTarget(target.dataArr[i]);
        }
    }

    public void clearLastingCollectTargets() {
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            this.reductionDataCollectors[i].clearLastingCollectTargets();
        }
    }

    public ReductionDataCollection newDataCollectionTarget() {
        ReductionDataCollection newCol = new ReductionDataCollection();
        newCol.dataArr = new ReductionData[this.reductionDataCollectors.length];
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            newCol.dataArr[i] = this.reductionDataCollectors[i].newDataTarget();
        }
        return newCol;
    }

    public void addCollectTarget(ReductionDataCollection target) {
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            this.reductionDataCollectors[i].addCollectTarget(target.dataArr[i]);
        }
    }

    public void apply() {
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            this.reductionDataCollectors[i].collectAndApply();
        }
    }

    public void setData(ReductionDataCollection dataCollection) {
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            this.reductionDataCollectors[i].setData(dataCollection.dataArr[i]);
        }
    }

    public ReductionDataCollection newDataCollection() {
        ReductionDataCollection newCol = new ReductionDataCollection();
        newCol.dataArr = new ReductionData[this.reductionDataCollectors.length];
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            newCol.dataArr[i] = this.reductionDataCollectors[i].newData();
        }
        return newCol;
    }

    public void setShardInput(DataInput input) {
        this.readers.clear();
        this.reservations.forEach(resv -> this.readers.add(resv.createReadStream(input)));
    }

    public void mergeData() throws IOException {
        for (ReductionDataReader<?> reader : this.readers) {
            reader.read();
        }
    }

    public void setShardOutput(DataOutput output) {
        this.writers.clear();
        this.reservations.forEach(resv -> this.writers.add(resv.createWriteStream(output)));
    }

    public void exportData() throws IOException {
        for (ReductionDataWriter<?> writer : this.writers) {
            writer.write();
        }
    }

    public void prepareReductionDataIO(ReductionDataCollection col) {
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            this.reductionDataCollectors[i].dataIO(col.dataArr[i]);
        }
    }

    public ReductionDataCollection newDataCollectionIO() {
        ReductionDataCollection newCol = new ReductionDataCollection();
        newCol.dataArr = new ReductionData[this.reductionDataCollectors.length];
        for (int i = 0; i < this.reductionDataCollectors.length; ++i) {
            newCol.dataArr[i] = this.reductionDataCollectors[i].newDataIO();
        }
        return newCol;
    }

    public static class ReductionDataCollection {
        public ReductionData[] dataArr;
    }
}

