/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.node;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.node.SolrNodeMetric;

public class SolrNodeContainerMetric
extends SolrNodeMetric {
    public static final String NODE_CORES = "solr_metrics_node_cores";
    public static final String NODE_CORE_FS_BYTES = "solr_metrics_node_core_root_fs_bytes";

    public SolrNodeContainerMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        this.labels.put("category", parsedMetric[0]);
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        String[] parsedMetric = this.metricName.split("\\.");
        if (this.metricName.startsWith("CONTAINER.cores.")) {
            this.labels.put("item", parsedMetric[2]);
            formatter.exportGauge(NODE_CORES, (Gauge)this.dropwizardMetric, this.getLabels());
        } else if (this.metricName.startsWith("CONTAINER.fs.coreRoot.")) {
            this.labels.put("item", parsedMetric[3]);
            formatter.exportGauge(NODE_CORE_FS_BYTES, (Gauge)this.dropwizardMetric, this.getLabels());
        }
    }
}

