/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.jetty;

import com.codahale.metrics.Metric;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrNoOpMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.jetty.SolrJettyDispatchesMetric;
import org.apache.solr.metrics.prometheus.jetty.SolrJettyReqRespMetric;

public class SolrPrometheusJettyFormatter
extends SolrPrometheusFormatter {
    @Override
    public void exportDropwizardMetric(Metric dropwizardMetric, String metricName) {
        SolrMetric solrJettyMetric = this.categorizeMetric(dropwizardMetric, metricName);
        solrJettyMetric.parseLabels().toPrometheus(this);
    }

    @Override
    public SolrMetric categorizeMetric(Metric dropwizardMetric, String metricName) {
        if (metricName.endsWith("xx-responses") || metricName.endsWith("-requests")) {
            return new SolrJettyReqRespMetric(dropwizardMetric, metricName);
        }
        if (metricName.endsWith(".dispatches")) {
            return new SolrJettyDispatchesMetric(dropwizardMetric, metricName);
        }
        return new SolrNoOpMetric();
    }
}

