/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.CSVResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XMLResponseWriter;

public class MessageBodyWriters {

    public static abstract class BaseMessageBodyWriter
    implements MessageBodyWriter<Object> {
        @Context
        protected ResourceContext resourceContext;
        private final QueryResponseWriter responseWriter = this.createResponseWriter();

        public abstract QueryResponseWriter createResponseWriter();

        public abstract String getSupportedMediaType();

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return mediaType.equals((Object)MediaType.valueOf((String)this.getSupportedMediaType()));
        }

        public void writeTo(Object toWrite, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            ContainerRequestContext requestContext = (ContainerRequestContext)this.resourceContext.getResource(ContainerRequestContext.class);
            SolrQueryRequest solrQueryRequest = (SolrQueryRequest)requestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
            SolrQueryResponse solrQueryResponse = (SolrQueryResponse)requestContext.getProperty(RequestContextKeys.SOLR_QUERY_RESPONSE);
            V2ApiUtils.squashIntoSolrResponseWithHeader(solrQueryResponse, toWrite);
            QueryResponseWriterUtil.writeQueryResponse(entityStream, this.responseWriter, solrQueryRequest, solrQueryResponse, mediaType.toString());
        }
    }

    @Produces(value={"text/plain; charset=UTF-8"})
    public static class CsvMessageBodyWriter
    extends BaseMessageBodyWriter
    implements MessageBodyWriter<Object> {
        @Override
        public QueryResponseWriter createResponseWriter() {
            return new CSVResponseWriter();
        }

        @Override
        public String getSupportedMediaType() {
            return "text/plain; charset=UTF-8";
        }
    }

    @Produces(value={"application/vnd.apache.solr.raw"})
    public static class RawMessageBodyWriter
    extends BaseMessageBodyWriter
    implements MessageBodyWriter<Object> {
        @Override
        public QueryResponseWriter createResponseWriter() {
            return new RawResponseWriter();
        }

        @Override
        public String getSupportedMediaType() {
            return "application/vnd.apache.solr.raw";
        }
    }

    @Produces(value={"application/vnd.apache.solr.javabin"})
    public static class JavabinMessageBodyWriter
    extends BaseMessageBodyWriter
    implements MessageBodyWriter<Object> {
        @Override
        public QueryResponseWriter createResponseWriter() {
            return new BinaryResponseWriter();
        }

        @Override
        public String getSupportedMediaType() {
            return "application/vnd.apache.solr.javabin";
        }
    }

    @Produces(value={"application/xml"})
    public static class XmlMessageBodyWriter
    extends BaseMessageBodyWriter
    implements MessageBodyWriter<Object> {
        @Override
        public QueryResponseWriter createResponseWriter() {
            return new XMLResponseWriter();
        }

        @Override
        public String getSupportedMediaType() {
            return "application/xml";
        }
    }
}

