/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.metrics;

import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.commons.metrics.MetricDimension;
import org.opensearch.performanceanalyzer.commons.metrics.MetricValue;
import org.opensearch.performanceanalyzer.commons.stats.JooqFieldValue;

public class AllMetrics {

    public static enum MetricUnits {
        CORES("cores"),
        COUNT_PER_SEC("count/s"),
        COUNT("count"),
        PAGES("pages"),
        SEC_PER_CONTEXT_SWITCH("s/ctxswitch"),
        BYTE_PER_SEC("B/s"),
        SEC_PER_EVENT("s/event"),
        MILLISECOND("ms"),
        BYTE("B"),
        PERCENT("%"),
        MEGABYTE_PER_SEC("MB/s"),
        SEGMENT_PER_FLOW("segments/flow"),
        BYTE_PER_FLOW("B/flow"),
        PACKET_PER_SEC("packets/s");

        private final String value;

        private MetricUnits(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CORES_VALUE = "cores";
            public static final String COUNT_PER_SEC_VALUE = "count/s";
            public static final String COUNT_VALUE = "count";
            public static final String PAGES_VALUE = "pages";
            public static final String SEC_PER_CONTEXT_SWITCH_VALUE = "s/ctxswitch";
            public static final String BYTE_PER_SEC_VALUE = "B/s";
            public static final String SEC_PER_EVENT_VALUE = "s/event";
            public static final String MILLISECOND_VALUE = "ms";
            public static final String BYTE_VALUE = "B";
            public static final String PERCENT_VALUE = "%";
            public static final String MEGABYTE_PER_SEC_VALUE = "MB/s";
            public static final String SEGMENT_PER_FLOW_VALUE = "segments/flow";
            public static final String BYTE_PER_FLOW_VALUE = "B/flow";
            public static final String PACKET_PER_SEC_VALUE = "packets/s";
        }
    }

    public static enum AdmissionControlValue implements MetricValue
    {
        CURRENT_VALUE("AdmissionControl_CurrentValue"),
        THRESHOLD_VALUE("AdmissionControl_ThresholdValue"),
        REJECTION_COUNT("AdmissionControl_RejectionCount");

        private final String value;

        private AdmissionControlValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CURRENT_VALUE = "AdmissionControl_CurrentValue";
            public static final String THRESHOLD_VALUE = "AdmissionControl_ThresholdValue";
            public static final String REJECTION_COUNT = "AdmissionControl_RejectionCount";
        }
    }

    public static enum AdmissionControlDimension implements MetricDimension,
    JooqFieldValue
    {
        CONTROLLER_NAME("ControllerName");

        private final String value;

        private AdmissionControlDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        @Override
        public String getName() {
            return this.value;
        }

        public static class Constants {
            public static final String CONTROLLER_NAME = "ControllerName";
        }
    }

    public static enum ShardIndexingPressureValue implements MetricValue
    {
        REJECTION_COUNT("Indexing_Pressure_Rejection_Count"),
        CURRENT_BYTES("Indexing_Pressure_Current_Bytes"),
        CURRENT_LIMITS("Indexing_Pressure_Current_Limits"),
        AVERAGE_WINDOW_THROUGHPUT("Indexing_Pressure_Average_Window_Throughput"),
        LAST_SUCCESSFUL_TIMESTAMP("Indexing_Pressure_Last_Successful_Timestamp");

        private final String value;

        private ShardIndexingPressureValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String REJECTION_COUNT_VALUE = "Indexing_Pressure_Rejection_Count";
            public static final String CURRENT_BYTES = "Indexing_Pressure_Current_Bytes";
            public static final String CURRENT_LIMITS = "Indexing_Pressure_Current_Limits";
            public static final String AVERAGE_WINDOW_THROUGHPUT = "Indexing_Pressure_Average_Window_Throughput";
            public static final String LAST_SUCCESSFUL_TIMESTAMP = "Indexing_Pressure_Last_Successful_Timestamp";
        }
    }

    public static enum ShardIndexingPressureDimension implements MetricDimension
    {
        INDEXING_STAGE("IndexingStage"),
        INDEX_NAME("IndexName"),
        SHARD_ID("ShardID");

        private final String value;

        private ShardIndexingPressureDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEXING_STAGE = "IndexingStage";
            public static final String INDEX_NAME_VALUE = "IndexName";
            public static final String SHARD_ID_VALUE = "ShardID";
        }
    }

    public static enum IndexingStage {
        COORDINATING("Coordinating"),
        PRIMARY("Primary"),
        REPLICA("Replica");

        private final String value;

        private IndexingStage(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String COORDINATING_VALUE = "Coordinating";
            public static final String PRIMARY_VALUE = "Primary";
            public static final String REPLICA_VALUE = "Replica";
        }
    }

    public static enum ShardStateValue implements MetricValue
    {
        SHARD_STATE("Shard_State");

        private final String value;

        private ShardStateValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String SHARD_STATE = "Shard_State";
        }
    }

    public static enum ShardType {
        SHARD_PRIMARY("p"),
        SHARD_REPLICA("r");

        private final String value;

        private ShardType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String SHARD_PRIMARY = "p";
            public static final String SHARD_REPLICA = "r";
        }
    }

    public static enum ShardStateDimension implements MetricDimension
    {
        INDEX_NAME(CommonDimension.INDEX_NAME.toString()),
        SHARD_ID(CommonDimension.SHARD_ID.toString()),
        SHARD_TYPE("ShardType"),
        NODE_NAME("NodeName"),
        SHARD_STATE("Shard_State");

        private final String value;

        private ShardStateDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String NODE_NAME = "NodeName";
            public static final String SHARD_TYPE = "ShardType";
            public static final String SHARD_STATE = "Shard_State";
        }
    }

    public static enum HttpOnlyDimension implements MetricDimension
    {
        OPERATION(CommonDimension.OPERATION.toString()),
        EXCEPTION(CommonDimension.EXCEPTION.toString()),
        INDICES(HttpDimension.INDICES.toString()),
        HTTP_RESP_CODE(HttpDimension.HTTP_RESP_CODE.toString());

        private final String value;

        private HttpOnlyDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum LatencyDimension implements MetricDimension
    {
        OPERATION(CommonDimension.OPERATION.toString()),
        EXCEPTION(CommonDimension.EXCEPTION.toString()),
        INDICES(HttpDimension.INDICES.toString()),
        HTTP_RESP_CODE(HttpDimension.HTTP_RESP_CODE.toString()),
        SHARD_ID(CommonDimension.SHARD_ID.toString()),
        INDEX_NAME(CommonDimension.INDEX_NAME.toString()),
        SHARD_ROLE(CommonDimension.SHARD_ROLE.toString());

        private final String value;

        private LatencyDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AggregatedOSDimension implements MetricDimension
    {
        INDEX_NAME(CommonDimension.INDEX_NAME.toString()),
        OPERATION(CommonDimension.OPERATION.toString()),
        SHARD_ROLE(CommonDimension.SHARD_ROLE.toString()),
        SHARD_ID(CommonDimension.SHARD_ID.toString()),
        THREAD_NAME(CommonDimension.THREAD_NAME.toString());

        private final String value;

        private AggregatedOSDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EmptyDimension implements MetricDimension
    {
        EMPTY("");

        private final String value;

        private EmptyDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum CommonMetric {
        START_TIME("StartTime"),
        FINISH_TIME("FinishTime"),
        LATENCY("Latency");

        private final String value;

        private CommonMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String START_TIME_VALUE = "StartTime";
            public static final String FINISH_TIME_VALUE = "FinishTime";
            public static final String LATENCY_VALUE = "Latency";
        }
    }

    public static enum CommonDimension implements MetricDimension
    {
        INDEX_NAME("IndexName"),
        OPERATION("Operation"),
        SHARD_ROLE("ShardRole"),
        SHARD_ID("ShardID"),
        EXCEPTION("Exception"),
        THREAD_NAME("ThreadName"),
        FAILED("Failed");

        private final String value;

        private CommonDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEX_NAME_VALUE = "IndexName";
            public static final String SHARDID_VALUE = "ShardID";
            public static final String OPERATION_VALUE = "Operation";
            public static final String SHARD_ROLE_VALUE = "ShardRole";
            public static final String EXCEPTION_VALUE = "Exception";
            public static final String FAILED_VALUE = "Failed";
            public static final String THREAD_NAME = "ThreadName";
        }
    }

    public static enum FaultDetectionDimension implements MetricDimension
    {
        SOURCE_NODE_ID("SourceNodeID"),
        TARGET_NODE_ID("TargetNodeID");

        private final String value;

        private FaultDetectionDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String SOURCE_NODE_ID = "SourceNodeID";
            public static final String TARGET_NODE_ID = "TargetNodeID";
        }
    }

    public static enum FaultDetectionMetric implements MetricValue
    {
        FOLLOWER_CHECK_LATENCY("FollowerCheck_Latency"),
        LEADER_CHECK_LATENCY("LeaderCheck_Latency"),
        FOLLOWER_CHECK_FAILURE("FollowerCheck_Failure"),
        LEADER_CHECK_FAILURE("LeaderCheck_Failure");

        private final String value;

        private FaultDetectionMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String FOLLOWER_CHECK_LATENCY = "FollowerCheck_Latency";
            public static final String LEADER_CHECK_LATENCY = "LeaderCheck_Latency";
            public static final String FOLLOWER_CHECK_FAILURE = "FollowerCheck_Failure";
            public static final String LEADER_CHECK_FAILURE = "LeaderCheck_Failure";
        }
    }

    public static enum ShardOperationMetric implements MetricValue
    {
        SHARD_OP_COUNT("ShardEvents");

        private final String value;

        private ShardOperationMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String SHARD_OP_COUNT_VALUE = "ShardEvents";
        }
    }

    public static enum ShardBulkMetric implements MetricValue
    {
        START_TIME(Constants.START_TIME_VALUE),
        ITEM_COUNT("ItemCount"),
        FINISH_TIME(Constants.FINISH_TIME_VALUE),
        LATENCY(Constants.LATENCY_VALUE),
        DOC_COUNT("ShardBulkDocs");

        private final String value;

        private ShardBulkMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String START_TIME_VALUE = CommonMetric.START_TIME.toString();
            public static final String ITEM_COUNT_VALUE = "ItemCount";
            public static final String FINISH_TIME_VALUE = CommonMetric.FINISH_TIME.toString();
            public static final String LATENCY_VALUE = CommonMetric.LATENCY.toString();
            public static final String DOC_COUNT = "ShardBulkDocs";
        }
    }

    public static enum ShardBulkDimension implements MetricDimension
    {
        INDEX_NAME(Constants.INDEXNAME_VALUE),
        SHARD_ID(Constants.SHARDID_VALUE),
        PRIMARY("Primary"),
        EXCEPTION(Constants.EXCEPTION_VALUE),
        FAILED(Constants.FAILED_VALUE);

        private final String value;

        private ShardBulkDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEXNAME_VALUE = CommonDimension.INDEX_NAME.toString();
            public static final String SHARDID_VALUE = CommonDimension.SHARD_ID.toString();
            public static final String PRIMARY_VALUE = "Primary";
            public static final String EXCEPTION_VALUE = CommonDimension.EXCEPTION.toString();
            public static final String FAILED_VALUE = CommonDimension.FAILED.toString();
        }
    }

    public static enum HttpMetric implements MetricValue
    {
        START_TIME(Constants.START_TIME_VALUE),
        HTTP_REQUEST_DOCS("HTTP_RequestDocs"),
        FINISH_TIME(Constants.FINISH_TIME_VALUE),
        HTTP_TOTAL_REQUESTS("HTTP_TotalRequests");

        private final String value;

        private HttpMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String START_TIME_VALUE = CommonMetric.START_TIME.toString();
            public static final String FINISH_TIME_VALUE = CommonMetric.FINISH_TIME.toString();
            public static final String HTTP_REQUEST_DOCS_VALUE = "HTTP_RequestDocs";
            public static final String HTTP_TOTAL_REQUESTS_VALUE = "HTTP_TotalRequests";
        }
    }

    public static enum HttpDimension implements MetricDimension
    {
        EXCEPTION(Constants.EXCEPTION_VALUE),
        HTTP_RESP_CODE("HTTPRespCode"),
        INDICES("Indices");

        private final String value;

        private HttpDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDICES_VALUE = "Indices";
            public static final String EXCEPTION_VALUE = CommonDimension.EXCEPTION.toString();
            public static final String HTTP_RESP_CODE_VALUE = "HTTPRespCode";
        }
    }

    public static enum ClusterManagerMetricValues implements MetricValue
    {
        CLUSTER_MANAGER_TASK_QUEUE_TIME("ClusterManager_Task_Queue_Time"),
        CLUSTER_MANAGER_TASK_RUN_TIME("ClusterManager_Task_Run_Time"),
        START_TIME("StartTime"),
        FINISH_TIME("FinishTime");

        private final String value;

        private ClusterManagerMetricValues(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ClusterManagerMetricDimensions implements MetricDimension
    {
        CLUSTER_MANAGER_TASK_PRIORITY("ClusterManagerTaskPriority"),
        CLUSTER_MANAGER_TASK_TYPE("ClusterManagerTaskType"),
        CLUSTER_MANAGER_TASK_METADATA("ClusterManagerTaskMetadata"),
        CLUSTER_MANAGER_TASK_QUEUE_TIME("ClusterManagerTaskQueueTime"),
        CLUSTER_MANAGER_TASK_RUN_TIME("ClusterManagerTaskRunTime"),
        CLUSTER_MANAGER_TASK_INSERT_ORDER("ClusterManagerTaskInsertOrder");

        private final String value;

        private ClusterManagerMetricDimensions(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum OSMetrics {
        CPU_UTILIZATION("CPU_Utilization"),
        PAGING_MAJ_FLT_RATE("Paging_MajfltRate"),
        PAGING_MIN_FLT_RATE("Paging_MinfltRate"),
        PAGING_RSS("Paging_RSS"),
        SCHED_RUNTIME("Sched_Runtime"),
        SCHED_WAITTIME("Sched_Waittime"),
        SCHED_CTX_RATE("Sched_CtxRate"),
        HEAP_ALLOC_RATE("Heap_AllocRate"),
        IO_READ_THROUGHPUT("IO_ReadThroughput"),
        IO_WRITE_THROUGHPUT("IO_WriteThroughput"),
        IO_TOT_THROUGHPUT("IO_TotThroughput"),
        IO_READ_SYSCALL_RATE("IO_ReadSyscallRate"),
        IO_WRITE_SYSCALL_RATE("IO_WriteSyscallRate"),
        IO_TOTAL_SYSCALL_RATE("IO_TotalSyscallRate"),
        THREAD_BLOCKED_TIME("Thread_Blocked_Time"),
        THREAD_BLOCKED_EVENT("Thread_Blocked_Event"),
        THREAD_WAITED_TIME("Thread_Waited_Time"),
        THREAD_WAITED_EVENT("Thread_Waited_Event");

        private final String value;

        private OSMetrics(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CPU_VALUE = "CPU_Utilization";
            public static final String PAGING_MAJFLT_VALUE = "Paging_MajfltRate";
            public static final String PAGING_MINFLT_VALUE = "Paging_MinfltRate";
            public static final String RSS_VALUE = "Paging_RSS";
            public static final String RUNTIME_VALUE = "Sched_Runtime";
            public static final String WAITTIME_VALUE = "Sched_Waittime";
            public static final String CTXRATE_VALUE = "Sched_CtxRate";
            public static final String HEAP_ALLOC_VALUE = "Heap_AllocRate";
            public static final String READ_THROUGHPUT_VALUE = "IO_ReadThroughput";
            public static final String WRITE_THROUGHPUT_VALUE = "IO_WriteThroughput";
            public static final String TOTAL_THROUGHPUT_VALUE = "IO_TotThroughput";
            public static final String READ_SYSCALL_RATE_VALUE = "IO_ReadSyscallRate";
            public static final String WRITE_SYSCALL_RATE_VALUE = "IO_WriteSyscallRate";
            public static final String TOTAL_SYSCALL_RATE_VALUE = "IO_TotalSyscallRate";
            public static final String BLOCKED_TIME_VALUE = "Thread_Blocked_Time";
            public static final String BLOCKED_COUNT_VALUE = "Thread_Blocked_Event";
            public static final String WAITED_TIME_VALUE = "Thread_Waited_Time";
            public static final String WAITED_COUNT_VALUE = "Thread_Waited_Event";
        }
    }

    public static enum ClusterManagerThrottlingValue implements MetricValue
    {
        CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT("ClusterManager_ThrottledPendingTasksCount"),
        DATA_RETRYING_TASK_COUNT("Data_RetryingPendingTasksCount");

        private final String value;

        private ClusterManagerThrottlingValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String THROTTLED_PENDING_TASK_COUNT = "ClusterManager_ThrottledPendingTasksCount";
            public static final String RETRYING_TASK_COUNT = "Data_RetryingPendingTasksCount";
        }
    }

    public static enum ElectionTermValue implements MetricValue
    {
        ELECTION_TERM("Election_Term");

        private final String value;

        private ElectionTermValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String ELECTION_TERM_VALUE = "Election_Term";
        }
    }

    public static enum ClusterManagerClusterUpdateStatsValue implements MetricValue
    {
        PUBLISH_CLUSTER_STATE_LATENCY("PublishClusterState_Latency"),
        PUBLISH_CLUSTER_STATE_FAILURE("PublishClusterState_Failure");

        private final String value;

        private ClusterManagerClusterUpdateStatsValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String PUBLISH_CLUSTER_STATE_LATENCY = "PublishClusterState_Latency";
            public static final String PUBLISH_CLUSTER_STATE_FAILURE = "PublishClusterState_Failure";
        }
    }

    public static enum SearchBackPressureStatsValue implements MetricValue
    {
        SEARCHBP_MODE("searchbp_mode"),
        SEARCHBP_NODEID("searchbp_nodeid"),
        SEARCHBP_SHARD_TASK_STATS_CANCELLATION_COUNT("searchbp_shard_task_stats_cancellationCount"),
        SEARCHBP_SHARD_TASK_STATS_LIMIT_REACHED_COUNT("searchbp_shard_task_stats_limitReachedCount"),
        SEARCHBP_SHARD_TASK_STATS_COMPLETION_COUNT("searchbp_shard_task_stats_completionCount"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_HEAP_USAGE_CANCELLATION_COUNT("searchbp_shard_task_stats_resource_heap_usage_cancellationCount"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_HEAP_USAGE_CURRENT_MAX("searchbp_shard_task_stats_resource_heap_usage_currentMax"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_HEAP_USAGE_ROLLING_AVG("searchbp_shard_task_stats_resource_heap_usage_rollingAvg"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_CPU_USAGE_CANCELLATION_COUNT("searchbp_shard_task_stats_resource_cpu_usage_cancellationCount"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_MAX("searchbp_shard_task_stats_resource_cpu_usage_currentMax"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_AVG("searchbp_shard_task_stats_resource_cpu_usage_currentAvg"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CANCELLATION_COUNT("searchbp_shard_task_stats_resource_elaspedtime_usage_cancellationCount"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_MAX("searchbp_shard_task_stats_resource_elaspedtime_usage_currentMax"),
        SEARCHBP_SHARD_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_AVG("searchbp_shard_task_stats_resource_elaspedtime_usage_currentAvg"),
        SEARCHBP_SEARCH_TASK_STATS_CANCELLATION_COUNT("searchbp_search_task_stats_cancellationCount"),
        SEARCHBP_SEARCH_TASK_STATS_LIMIT_REACHED_COUNT("searchbp_search_task_stats_limitReachedCount"),
        SEARCHBP_SEARCH_TASK_STATS_COMPLETION_COUNT("searchbp_search_task_stats_completionCount"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_HEAP_USAGE_CANCELLATION_COUNT("searchbp_search_task_stats_resource_heap_usage_cancellationCount"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_HEAP_USAGE_CURRENT_MAX("searchbp_search_task_stats_resource_heap_usage_currentMax"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_HEAP_USAGE_ROLLING_AVG("searchbp_search_task_stats_resource_heap_usage_rollingAvg"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_CPU_USAGE_CANCELLATION_COUNT("searchbp_search_task_stats_resource_cpu_usage_cancellationCount"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_MAX("searchbp_search_task_stats_resource_cpu_usage_currentMax"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_AVG("searchbp_search_task_stats_resource_cpu_usage_currentAvg"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CANCELLATION_COUNT("searchbp_search_task_stats_resource_elaspedtime_usage_cancellationCount"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_MAX("searchbp_search_task_stats_resource_elaspedtime_usage_currentMax"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_AVG("searchbp_search_task_stats_resource_elaspedtime_usage_currentAvg"),
        SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_CANCELLATIONCOUNT("cancellationCount"),
        SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_CURRENTMAX("currentMax"),
        SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_CURRENTAVG("currentAvg"),
        SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_ROLLINGAVG("rollingAvg"),
        SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_FRAGMENT("fragment"),
        SEARCHBP_SEARCH_TASK_STATS_CANCELLATIONCOUNT("searchbp_search_task_stats_cancellationCount"),
        SEARCHBP_SEARCH_TASK_STATS_LIMITREACHEDCOUNT("limitReachedCount"),
        SEARCHBP_SEARCH_TASK_STATS_RESOURCE_USAGE_TRACKER_STATS("resourceUsageTrackerStats"),
        SEARCHBP_SEARCH_SHARD_TASK_STATS_CANCELLATIONCOUNT("cancellationCount"),
        SEARCHBP_SEARCH_SHARD_TASK_STATS_LIMITREACHEDCOUNT("limitReachedCount"),
        SEARCHBP_SEARCH_SHARD_TASK_STATS_RESOURCE_USAGE_TRACKER_STATS("resourceUsageTrackerStats"),
        SEARCHBP_SEARCH_BACK_PRESSURE_STATS_SEARCH_SHARD_TASK_STATS("searchShardTaskStats"),
        SEARCHBP_SEARCH_BACK_PRESSURE_STATS_MODE("mode"),
        SEARCHBP_SEARCH_BACK_PRESSURE_STATS_SEARCH_TASK_STATS("searchTaskStats"),
        SEARCHBP_TABLE_NAME("Searchbp_Stats"),
        SEARCHBP_TYPE_DIM("SearchBackPressureStats");

        private final String value;

        private SearchBackPressureStatsValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String SEARCHBP_MODE = "searchbp_mode";
            public static final String SEARCHBP_NODEID = "searchbp_nodeid";
            public static final String SEARCHBP_SHARD_TASK_STATS_CANCELLATION_COUNT = "searchbp_shard_task_stats_cancellationCount";
            public static final String SEARCHBP_SHARD_TASK_STATS_LIMIT_REACHED_COUNT = "searchbp_shard_task_stats_limitReachedCount";
            public static final String SEARCHBP_SHARD_TASK_STATS_COMPLETION_COUNT = "searchbp_shard_task_stats_completionCount";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_HEAP_USAGE_CANCELLATION_COUNT = "searchbp_shard_task_stats_resource_heap_usage_cancellationCount";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_HEAP_USAGE_CURRENT_MAX = "searchbp_shard_task_stats_resource_heap_usage_currentMax";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_HEAP_USAGE_ROLLING_AVG = "searchbp_shard_task_stats_resource_heap_usage_rollingAvg";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_CPU_USAGE_CANCELLATION_COUNT = "searchbp_shard_task_stats_resource_cpu_usage_cancellationCount";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_MAX = "searchbp_shard_task_stats_resource_cpu_usage_currentMax";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_AVG = "searchbp_shard_task_stats_resource_cpu_usage_currentAvg";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CANCELLATION_COUNT = "searchbp_shard_task_stats_resource_elaspedtime_usage_cancellationCount";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_MAX = "searchbp_shard_task_stats_resource_elaspedtime_usage_currentMax";
            public static final String SEARCHBP_SHARD_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_AVG = "searchbp_shard_task_stats_resource_elaspedtime_usage_currentAvg";
            public static final String SEARCHBP_SEARCH_TASK_STATS_CANCELLATION_COUNT = "searchbp_search_task_stats_cancellationCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_LIMIT_REACHED_COUNT = "searchbp_search_task_stats_limitReachedCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_COMPLETION_COUNT = "searchbp_search_task_stats_completionCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_HEAP_USAGE_CANCELLATION_COUNT = "searchbp_search_task_stats_resource_heap_usage_cancellationCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_HEAP_USAGE_CURRENT_MAX = "searchbp_search_task_stats_resource_heap_usage_currentMax";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_HEAP_USAGE_ROLLING_AVG = "searchbp_search_task_stats_resource_heap_usage_rollingAvg";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_CPU_USAGE_CANCELLATION_COUNT = "searchbp_search_task_stats_resource_cpu_usage_cancellationCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_MAX = "searchbp_search_task_stats_resource_cpu_usage_currentMax";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_CPU_USAGE_CURRENT_AVG = "searchbp_search_task_stats_resource_cpu_usage_currentAvg";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CANCELLATION_COUNT = "searchbp_search_task_stats_resource_elaspedtime_usage_cancellationCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_MAX = "searchbp_search_task_stats_resource_elaspedtime_usage_currentMax";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_ELASPEDTIME_USAGE_CURRENT_AVG = "searchbp_search_task_stats_resource_elaspedtime_usage_currentAvg";
            public static final String SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_CANCELLATIONCOUNT = "cancellationCount";
            public static final String SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_CURRENTMAX = "currentMax";
            public static final String SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_CURRENTAVG = "currentAvg";
            public static final String SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_ROLLINGAVG = "rollingAvg";
            public static final String SEARCHBP_RESOURCE_USAGE_TRACKER_STATS_FRAGMENT = "fragment";
            public static final String SEARCHBP_SEARCH_TASK_STATS_CANCELLATIONCOUNT = "cancellationCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_LIMITREACHEDCOUNT = "limitReachedCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_COMPLETIONCOUNT = "completionCount";
            public static final String SEARCHBP_SEARCH_TASK_STATS_RESOURCE_USAGE_TRACKER_STATS = "resourceUsageTrackerStats";
            public static final String SEARCHBP_SEARCH_SHARD_TASK_STATS_CANCELLATIONCOUNT = "cancellationCount";
            public static final String SEARCHBP_SEARCH_SHARD_TASK_STATS_LIMITREACHEDCOUNT = "limitReachedCount";
            public static final String SEARCHBP_SEARCH_SHARD_TASK_STATS_COMPLETIONCOUNT = "completionCount";
            public static final String SEARCHBP_SEARCH_SHARD_TASK_STATS_RESOURCE_USAGE_TRACKER_STATS = "resourceUsageTrackerStats";
            public static final String SEARCHBP_SEARCH_BACK_PRESSURE_STATS_SEARCH_SHARD_TASK_STATS = "searchShardTaskStats";
            public static final String SEARCHBP_SEARCH_BACK_PRESSURE_STATS_MODE = "mode";
            public static final String SEARCHBP_SEARCH_BACK_PRESSURE_STATS_SEARCH_TASK_STATS = "searchTaskStats";
            public static final String SEARCHBP_TABLE_NAME = "Searchbp_Stats";
            public static final String SEARCHBP_TYPE_DIM = "SearchBackPressureStats";
        }
    }

    public static enum ClusterApplierServiceStatsValue implements MetricValue
    {
        CLUSTER_APPLIER_SERVICE_LATENCY("ClusterApplierService_Latency"),
        CLUSTER_APPLIER_SERVICE_FAILURE("ClusterApplierService_Failure");

        private final String value;

        private ClusterApplierServiceStatsValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CLUSTER_APPLIER_SERVICE_LATENCY = "ClusterApplierService_Latency";
            public static final String CLUSTER_APPLIER_SERVICE_FAILURE = "ClusterApplierService_Failure";
        }
    }

    public static enum ClusterManagerPendingTaskDimension implements MetricDimension
    {
        CLUSTER_MANAGER_PENDING_TASK_TYPE("ClusterManager_PendingTaskType");

        private final String value;

        private ClusterManagerPendingTaskDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String PENDING_TASK_TYPE = "ClusterManager_PendingTaskType";
        }
    }

    public static enum ClusterManagerPendingValue implements MetricValue
    {
        CLUSTER_MANAGER_PENDING_QUEUE_SIZE("ClusterManager_PendingQueueSize");

        private final String value;

        private ClusterManagerPendingValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String PENDING_TASKS_COUNT_VALUE = "ClusterManager_PendingQueueSize";
        }
    }

    public static enum ShardStatsValue implements MetricValue
    {
        INDEXING_THROTTLE_TIME("Indexing_ThrottleTime"),
        CACHE_QUERY_HIT("Cache_Query_Hit"),
        CACHE_QUERY_MISS("Cache_Query_Miss"),
        CACHE_QUERY_SIZE("Cache_Query_Size"),
        CACHE_FIELDDATA_EVICTION("Cache_FieldData_Eviction"),
        CACHE_FIELDDATA_SIZE("Cache_FieldData_Size"),
        CACHE_REQUEST_HIT("Cache_Request_Hit"),
        CACHE_REQUEST_MISS("Cache_Request_Miss"),
        CACHE_REQUEST_EVICTION("Cache_Request_Eviction"),
        CACHE_REQUEST_SIZE("Cache_Request_Size"),
        REFRESH_EVENT("Refresh_Event"),
        REFRESH_TIME("Refresh_Time"),
        FLUSH_EVENT("Flush_Event"),
        FLUSH_TIME("Flush_Time"),
        MERGE_EVENT("Merge_Event"),
        MERGE_TIME("Merge_Time"),
        MERGE_CURRENT_EVENT("Merge_CurrentEvent"),
        INDEXING_BUFFER("Indexing_Buffer"),
        SEGMENTS_TOTAL("Segments_Total"),
        INDEX_WRITER_MEMORY("IndexWriter_Memory"),
        VERSION_MAP_MEMORY("VersionMap_Memory"),
        BITSET_MEMORY("Bitset_Memory"),
        SHARD_SIZE_IN_BYTES("Shard_Size_In_Bytes");

        private final String value;

        private ShardStatsValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEXING_THROTTLE_TIME_VALUE = "Indexing_ThrottleTime";
            public static final String QUEY_CACHE_HIT_COUNT_VALUE = "Cache_Query_Hit";
            public static final String QUERY_CACHE_MISS_COUNT_VALUE = "Cache_Query_Miss";
            public static final String QUERY_CACHE_IN_BYTES_VALUE = "Cache_Query_Size";
            public static final String FIELDDATA_EVICTION_VALUE = "Cache_FieldData_Eviction";
            public static final String FIELD_DATA_IN_BYTES_VALUE = "Cache_FieldData_Size";
            public static final String REQUEST_CACHE_HIT_COUNT_VALUE = "Cache_Request_Hit";
            public static final String REQUEST_CACHE_MISS_COUNT_VALUE = "Cache_Request_Miss";
            public static final String REQUEST_CACHE_EVICTION_VALUE = "Cache_Request_Eviction";
            public static final String REQUEST_CACHE_IN_BYTES_VALUE = "Cache_Request_Size";
            public static final String REFRESH_COUNT_VALUE = "Refresh_Event";
            public static final String REFRESH_TIME_VALUE = "Refresh_Time";
            public static final String FLUSH_COUNT_VALUE = "Flush_Event";
            public static final String FLUSH_TIME_VALUE = "Flush_Time";
            public static final String MERGE_COUNT_VALUE = "Merge_Event";
            public static final String MERGE_TIME_VALUE = "Merge_Time";
            public static final String MERGE_CURRENT_VALUE = "Merge_CurrentEvent";
            public static final String INDEX_BUFFER_BYTES_VALUE = "Indexing_Buffer";
            public static final String SEGMENTS_COUNT_VALUE = "Segments_Total";
            public static final String INDEX_WRITER_MEMORY_VALUE = "IndexWriter_Memory";
            public static final String VERSION_MAP_MEMORY_VALUE = "VersionMap_Memory";
            public static final String BITSET_MEMORY_VALUE = "Bitset_Memory";
            public static final String SHARD_SIZE_IN_BYTES_VALUE = "Shard_Size_In_Bytes";
        }
    }

    public static enum ShardStatsDerivedDimension implements MetricDimension
    {
        INDEX_NAME(Constants.INDEX_NAME_VALUE),
        SHARD_ID(Constants.SHARD_ID_VALUE);

        private final String value;

        private ShardStatsDerivedDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEX_NAME_VALUE = CommonDimension.INDEX_NAME.toString();
            public static final String SHARD_ID_VALUE = CommonDimension.SHARD_ID.toString();
        }
    }

    public static enum ThreadPoolType {
        ANALYZE("analyze"),
        FETCH_SHARD_STARTED("fetch_shard_started"),
        FETCH_SHARD_STORE("fetch_shard_store"),
        FLUSH("flush"),
        FORCE_MERGE("force_merge"),
        GENERIC("generic"),
        GET("get"),
        LISTENER("listener"),
        MANAGEMENT("management"),
        OPEN_DISTRO_JOB_SCHEDULER("open_distro_job_scheduler"),
        REFRESH("refresh"),
        SEARCH("search"),
        SEARCH_THROTTLED("search_throttled"),
        SNAPSHOT("snapshot"),
        SNAPSHOT_SEGMENTS("snapshot_segments"),
        SQL_WORKER("sql-worker"),
        WARMER("warmer"),
        WRITE("write");

        private final String value;

        private ThreadPoolType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String ANALYZE_NAME = "analyze";
            public static final String FETCH_SHARD_STARTED_NAME = "fetch_shard_started";
            public static final String FETCH_SHARD_STORE_NAME = "fetch_shard_store";
            public static final String FLUSH_NAME = "flush";
            public static final String FORCE_MERGE_NAME = "force_merge";
            public static final String GENERIC_NAME = "generic";
            public static final String GET_NAME = "get";
            public static final String LISTENER_NAME = "listener";
            public static final String MANAGEMENT_NAME = "management";
            public static final String OPEN_DISTRO_JOB_SCHEDULER_NAME = "open_distro_job_scheduler";
            public static final String REFRESH_NAME = "refresh";
            public static final String SEARCH_NAME = "search";
            public static final String SEARCH_THROTTLED_NAME = "search_throttled";
            public static final String SNAPSHOT_NAME = "snapshot";
            public static final String SNAPSHOT_SEGMENTS_NAME = "snapshot_segments";
            public static final String SQL_WORKER_NAME = "sql-worker";
            public static final String WARMER_NAME = "warmer";
            public static final String WRITE_NAME = "write";
        }
    }

    public static enum ThreadPoolValue implements MetricValue
    {
        THREADPOOL_QUEUE_SIZE("ThreadPool_QueueSize"),
        THREADPOOL_REJECTED_REQS("ThreadPool_RejectedReqs"),
        THREADPOOL_TOTAL_THREADS("ThreadPool_TotalThreads"),
        THREADPOOL_ACTIVE_THREADS("ThreadPool_ActiveThreads"),
        THREADPOOL_QUEUE_LATENCY("ThreadPool_QueueLatency"),
        THREADPOOL_QUEUE_CAPACITY("ThreadPool_QueueCapacity");

        private final String value;

        private ThreadPoolValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String QUEUE_SIZE_VALUE = "ThreadPool_QueueSize";
            public static final String REJECTED_VALUE = "ThreadPool_RejectedReqs";
            public static final String THREADS_COUNT_VALUE = "ThreadPool_TotalThreads";
            public static final String THREADS_ACTIVE_VALUE = "ThreadPool_ActiveThreads";
            public static final String QUEUE_LATENCY_VALUE = "ThreadPool_QueueLatency";
            public static final String QUEUE_CAPACITY_VALUE = "ThreadPool_QueueCapacity";
        }
    }

    public static enum ThreadPoolDimension implements MetricDimension,
    JooqFieldValue
    {
        THREAD_POOL_TYPE("ThreadPoolType");

        private final String value;

        private ThreadPoolDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        @Override
        public String getName() {
            return this.value;
        }

        public static class Constants {
            public static final String TYPE_VALUE = "ThreadPoolType";
        }
    }

    public static enum IPValue implements MetricValue
    {
        NET_PACKET_RATE4("Net_PacketRate4"),
        NET_PACKET_DROP_RATE4("Net_PacketDropRate4"),
        NET_PACKET_RATE6("Net_PacketRate6"),
        NET_PACKET_DROP_RATE6("Net_PacketDropRate6"),
        NET_THROUGHPUT("Net_Throughput");

        private final String value;

        private IPValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String PACKET_RATE4_VALUE = "Net_PacketRate4";
            public static final String DROP_RATE4_VALUE = "Net_PacketDropRate4";
            public static final String PACKET_RATE6_VALUE = "Net_PacketRate6";
            public static final String DROP_RATE6_VALUE = "Net_PacketDropRate6";
            public static final String THROUGHPUT_VALUE = "Net_Throughput";
        }
    }

    public static enum IPDimension implements MetricDimension
    {
        DIRECTION("Direction");

        private final String value;

        private IPDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String DIRECTION_VALUE = "Direction";
        }
    }

    public static enum TCPValue implements MetricValue
    {
        Net_TCP_NUM_FLOWS("Net_TCP_NumFlows"),
        Net_TCP_TXQ("Net_TCP_TxQ"),
        Net_TCP_RXQ("Net_TCP_RxQ"),
        Net_TCP_LOST("Net_TCP_Lost"),
        Net_TCP_SEND_CWND("Net_TCP_SendCWND"),
        Net_TCP_SSTHRESH("Net_TCP_SSThresh");

        private final String value;

        private TCPValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String NUM_FLOWS_VALUE = "Net_TCP_NumFlows";
            public static final String TXQ_VALUE = "Net_TCP_TxQ";
            public static final String RXQ_VALUE = "Net_TCP_RxQ";
            public static final String CUR_LOST_VALUE = "Net_TCP_Lost";
            public static final String SEND_CWND_VALUE = "Net_TCP_SendCWND";
            public static final String SSTHRESH_VALUE = "Net_TCP_SSThresh";
        }
    }

    public static enum TCPDimension implements MetricDimension
    {
        DEST_ADDR("DestAddr");

        private final String value;

        private TCPDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String DEST_VALUE = "DestAddr";
        }
    }

    public static enum DevicePartitionValue implements MetricValue
    {
        TOTAL_SPACE("Partition_TotalSpace"),
        FREE_SPACE("Partition_FreeSpace"),
        USABLE_FREE_SPACE("Partition_UsableFreeSpace");

        private final String value;

        private DevicePartitionValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String TOTAL_SPACE_VALUE = "Partition_TotalSpace";
            public static final String FREE_SPACE_VALUE = "Partition_FreeSpace";
            public static final String USABLE_FREE_SPACE_VALUE = "Partition_UsableFreeSpace";
        }
    }

    public static enum DevicePartitionDimension implements MetricDimension
    {
        MOUNT_POINT("MountPoint"),
        DEVICE_PARTITION("DevicePartition");

        private final String value;

        private DevicePartitionDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String MOUNT_POINT_VALUE = "MountPoint";
            public static final String DEVICE_PARTITION_VALUE = "DevicePartition";
        }
    }

    public static enum DiskValue implements MetricValue
    {
        DISK_UTILIZATION("Disk_Utilization"),
        DISK_WAITTIME("Disk_WaitTime"),
        DISK_SERVICE_RATE("Disk_ServiceRate");

        private final String value;

        private DiskValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String UTIL_VALUE = "Disk_Utilization";
            public static final String WAIT_VALUE = "Disk_WaitTime";
            public static final String SRATE_VALUE = "Disk_ServiceRate";
        }
    }

    public static enum DiskDimension implements MetricDimension
    {
        DISK_NAME("DiskName");

        private final String value;

        private DiskDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String NAME_VALUE = "DiskName";
        }
    }

    public static enum GCInfoValue implements MetricValue
    {
        GARBAGE_COLLECTOR_TYPE("GC_Type");

        private final String value;

        private GCInfoValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String GC_TYPE_VALUE = "GC_Type";
        }
    }

    public static enum GCInfoDimension implements MetricDimension,
    JooqFieldValue
    {
        MEMORY_POOL("MemoryPool"),
        COLLECTOR_NAME("CollectorName");

        private final String value;

        private GCInfoDimension(String value) {
            this.value = value;
        }

        @Override
        public String getName() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String MEMORY_POOL_VALUE = "MemoryPool";
            public static final String COLLECTOR_NAME_VALUE = "CollectorName";
        }
    }

    public static enum HeapValue implements MetricValue
    {
        GC_COLLECTION_EVENT("GC_Collection_Event"),
        GC_COLLECTION_TIME("GC_Collection_Time"),
        HEAP_COMMITTED("Heap_Committed"),
        HEAP_INIT("Heap_Init"),
        HEAP_MAX("Heap_Max"),
        HEAP_USED("Heap_Used");

        private final String value;

        private HeapValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String COLLECTION_COUNT_VALUE = "GC_Collection_Event";
            public static final String COLLECTION_TIME_VALUE = "GC_Collection_Time";
            public static final String COMMITTED_VALUE = "Heap_Committed";
            public static final String INIT_VALUE = "Heap_Init";
            public static final String MAX_VALUE = "Heap_Max";
            public static final String USED_VALUE = "Heap_Used";
        }
    }

    public static enum HeapDimension implements MetricDimension,
    JooqFieldValue
    {
        MEM_TYPE("MemType");

        private final String value;

        private HeapDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        @Override
        public String getName() {
            return this.value;
        }

        public static class Constants {
            public static final String TYPE_VALUE = "MemType";
        }
    }

    public static enum CircuitBreakerValue implements MetricValue
    {
        CB_ESTIMATED_SIZE("CB_EstimatedSize"),
        CB_TRIPPED_EVENTS("CB_TrippedEvents"),
        CB_CONFIGURED_SIZE("CB_ConfiguredSize");

        private final String value;

        private CircuitBreakerValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String ESTIMATED_VALUE = "CB_EstimatedSize";
            public static final String TRIPPED_VALUE = "CB_TrippedEvents";
            public static final String LIMIT_CONFIGURED_VALUE = "CB_ConfiguredSize";
        }
    }

    public static enum CircuitBreakerDimension implements MetricDimension
    {
        CB_TYPE("CBType");

        private final String value;

        private CircuitBreakerDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String TYPE_VALUE = "CBType";
        }
    }

    public static enum CacheType {
        FIELD_DATA_CACHE("field_data_cache"),
        SHARD_REQUEST_CACHE("shard_request_cache"),
        NODE_QUERY_CACHE("node_query_cache");

        private final String value;

        private CacheType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String FIELD_DATA_CACHE_NAME = "field_data_cache";
            public static final String SHARD_REQUEST_CACHE_NAME = "shard_request_cache";
            public static final String NODE_QUERY_CACHE_NAME = "node_query_cache";
        }
    }

    public static enum CacheConfigValue implements MetricValue
    {
        CACHE_MAX_SIZE("Cache_MaxSize");

        private final String value;

        private CacheConfigValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CACHE_MAX_SIZE_VALUE = "Cache_MaxSize";
        }
    }

    public static enum CacheConfigDimension implements MetricDimension,
    JooqFieldValue
    {
        CACHE_TYPE("CacheType");

        private final String value;

        private CacheConfigDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        @Override
        public String getName() {
            return this.value;
        }

        public static class Constants {
            public static final String TYPE_VALUE = "CacheType";
        }
    }

    public static enum GCType {
        TOT_YOUNG_GC("totYoungGC"),
        TOT_FULL_GC("totFullGC"),
        SURVIVOR("Survivor"),
        PERM_GEN("PermGen"),
        OLD_GEN("OldGen"),
        EDEN("Eden"),
        NON_HEAP("NonHeap"),
        HEAP("Heap");

        private final String value;

        private GCType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String TOT_YOUNG_GC_VALUE = "totYoungGC";
            public static final String TOT_FULL_GC_VALUE = "totFullGC";
            public static final String SURVIVOR_VALUE = "Survivor";
            public static final String PERM_GEN_VALUE = "PermGen";
            public static final String OLD_GEN_VALUE = "OldGen";
            public static final String EDEN_VALUE = "Eden";
            public static final String NON_HEAP_VALUE = "NonHeap";
            public static final String HEAP_VALUE = "Heap";
        }
    }

    public static enum NodeRole {
        CLUSTER_MANAGER("CLUSTER_MANAGER"),
        ELECTED_CLUSTER_MANAGER("ELECTED_CLUSTER_MANAGER"),
        DATA("DATA"),
        UNKNOWN("UNKNOWN");

        private final String value;

        private NodeRole(String value) {
            this.value = value;
        }

        public String role() {
            return this.value;
        }

        public static class RoleConstants {
            public static final String CLUSTER_MANAGER = "CLUSTER_MANAGER";
            public static final String ELECTED_CLUSTER_MANAGER = "ELECTED_CLUSTER_MANAGER";
            public static final String DATA = "DATA";
            public static final String UNKNOWN = "UNKNOWN";
        }
    }

    public static enum NodeDetailColumns {
        ID("ID"),
        HOST_ADDRESS("HOST_ADDRESS"),
        ROLE("ROLE"),
        IS_CLUSTER_MANAGER_NODE("IS_CLUSTER_MANAGER_NODE");

        private final String value;

        private NodeDetailColumns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String ID_VALUE = "ID";
            public static final String HOST_ADDRESS_VALUE = "HOST_ADDRESS";
            public static final String ROLE_VALUE = "ROLE";
            public static final String IS_CLUSTER_MANAGER_NODE = "IS_CLUSTER_MANAGER_NODE";
        }
    }

    public static enum MetricName {
        CACHE_CONFIG,
        CIRCUIT_BREAKER,
        HEAP_METRICS,
        DISK_METRICS,
        TCP_METRICS,
        IP_METRICS,
        THREAD_POOL,
        SHARD_STATS,
        CLUSTER_MANAGER_PENDING,
        MOUNTED_PARTITION_METRICS,
        CLUSTER_APPLIER_SERVICE,
        ELECTION_TERM,
        ADMISSION_CONTROL_METRICS,
        SHARD_INDEXING_PRESSURE,
        CLUSTER_MANAGER_CLUSTER_UPDATE_STATS;

    }
}

