/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class TextCopyPasteHandler<T extends JTextComponent> {
    private final T textComponent;
    private final Action cutAction;
    private final Action copyAction;
    private final Action pasteAction;
    private final Action undoAction;
    private final Action selectAllAction;
    private final JPopupMenu popup = new JPopupMenu();
    private String savedString = "";
    private Actions lastActionSelected;

    public TextCopyPasteHandler(T component) {
        this.textComponent = component;
        this.undoAction = new AbstractAction(this, "Widerrufen"){
            final /* synthetic */ TextCopyPasteHandler this$0;
            {
                TextCopyPasteHandler textCopyPasteHandler = this$0;
                Objects.requireNonNull(textCopyPasteHandler);
                this.this$0 = textCopyPasteHandler;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                ((JTextComponent)this.this$0.textComponent).setText("");
                ((JTextComponent)this.this$0.textComponent).replaceSelection(this.this$0.savedString);
                this.this$0.lastActionSelected = Actions.UNDO;
            }
        };
        this.popup.add(this.undoAction);
        this.popup.addSeparator();
        this.cutAction = new AbstractAction(this, "Ausschneiden"){
            final /* synthetic */ TextCopyPasteHandler this$0;
            {
                TextCopyPasteHandler textCopyPasteHandler = this$0;
                Objects.requireNonNull(textCopyPasteHandler);
                this.this$0 = textCopyPasteHandler;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.lastActionSelected = Actions.CUT;
                this.this$0.savedString = ((JTextComponent)this.this$0.textComponent).getText();
                ((JTextComponent)this.this$0.textComponent).cut();
            }
        };
        this.popup.add(this.cutAction);
        this.copyAction = new AbstractAction(this, "Kopieren"){
            final /* synthetic */ TextCopyPasteHandler this$0;
            {
                TextCopyPasteHandler textCopyPasteHandler = this$0;
                Objects.requireNonNull(textCopyPasteHandler);
                this.this$0 = textCopyPasteHandler;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.lastActionSelected = Actions.COPY;
                ((JTextComponent)this.this$0.textComponent).copy();
            }
        };
        this.popup.add(this.copyAction);
        this.pasteAction = new AbstractAction(this, "Einf\u00fcgen"){
            final /* synthetic */ TextCopyPasteHandler this$0;
            {
                TextCopyPasteHandler textCopyPasteHandler = this$0;
                Objects.requireNonNull(textCopyPasteHandler);
                this.this$0 = textCopyPasteHandler;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.lastActionSelected = Actions.PASTE;
                this.this$0.savedString = ((JTextComponent)this.this$0.textComponent).getText();
                ((JTextComponent)this.this$0.textComponent).paste();
            }
        };
        this.popup.add(this.pasteAction);
        this.popup.addSeparator();
        this.selectAllAction = new AbstractAction(this, "Alles markieren"){
            final /* synthetic */ TextCopyPasteHandler this$0;
            {
                TextCopyPasteHandler textCopyPasteHandler = this$0;
                Objects.requireNonNull(textCopyPasteHandler);
                this.this$0 = textCopyPasteHandler;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.lastActionSelected = Actions.SELECT_ALL;
                ((JTextComponent)this.this$0.textComponent).selectAll();
            }
        };
        this.popup.add(this.selectAllAction);
        this.popup.addPopupMenuListener(new PopupMenuListener(this){
            final /* synthetic */ TextCopyPasteHandler this$0;
            {
                TextCopyPasteHandler textCopyPasteHandler = this$0;
                Objects.requireNonNull(textCopyPasteHandler);
                this.this$0 = textCopyPasteHandler;
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean enabled = ((Component)this.this$0.textComponent).isEnabled();
                boolean editable = ((JTextComponent)this.this$0.textComponent).isEditable();
                boolean nonempty = ((JTextComponent)this.this$0.textComponent).getText() != null && !((JTextComponent)this.this$0.textComponent).getText().isEmpty();
                boolean marked = ((JTextComponent)this.this$0.textComponent).getSelectedText() != null;
                boolean pasteAvailable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
                ((JComponent)this.this$0.textComponent).requestFocus();
                this.this$0.undoAction.setEnabled(enabled && editable && (this.this$0.lastActionSelected == Actions.CUT || this.this$0.lastActionSelected == Actions.PASTE));
                this.this$0.cutAction.setEnabled(enabled && editable && marked);
                this.this$0.copyAction.setEnabled(enabled && marked);
                this.this$0.pasteAction.setEnabled(enabled && editable && pasteAvailable);
                this.this$0.selectAllAction.setEnabled(enabled && nonempty);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    private static enum Actions {
        UNDO,
        CUT,
        COPY,
        PASTE,
        SELECT_ALL;

    }
}

