/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class GeoJSONWriter {
    private final DataSet data;
    private static final Projection projection = Projections.getProjectionByCode("EPSG:4326");
    private static final BooleanProperty SKIP_EMPTY_NODES = new BooleanProperty("geojson.export.skip-empty-nodes", true);
    private static final BooleanProperty UNTAGGED_CLOSED_IS_POLYGON = new BooleanProperty("geojson.export.untagged-closed-is-polygon", false);
    protected static final JsonProvider JSON_PROVIDER = JsonProvider.provider();
    private static final Set<Way> processedMultipolygonWays = new HashSet<Way>();
    private final EnumSet<Options> options = EnumSet.noneOf(Options.class);
    static final String JSON_VALUE_START_MARKER = "{";
    static final String JSON_VALUE_END_MARKER = "}";

    public GeoJSONWriter(DataSet ds) {
        this.data = ds;
        if (Boolean.TRUE.equals(SKIP_EMPTY_NODES.get())) {
            this.options.add(Options.SKIP_EMPTY_NODES);
        }
    }

    void setOptions(Options ... options) {
        this.options.clear();
        this.options.addAll(Arrays.asList(options));
    }

    public String write() {
        return this.write(true);
    }

    public String write(boolean pretty) {
        StringWriter stringWriter = new StringWriter();
        this.write(pretty, stringWriter);
        return stringWriter.toString();
    }

    public void write(boolean pretty, Writer writer) {
        Map<String, Boolean> config = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", pretty);
        try (JsonWriter jsonWriter = JSON_PROVIDER.createWriterFactory(config).createWriter(writer);){
            JsonObjectBuilder object = JSON_PROVIDER.createObjectBuilder().add("type", "FeatureCollection").add("generator", "JOSM");
            this.appendLayerBounds(this.data, object);
            this.appendLayerFeatures(this.data, object);
            jsonWriter.writeObject(object.build());
        }
    }

    private JsonArrayBuilder getCoorArray(JsonArrayBuilder builder, ILatLon c) {
        return GeoJSONWriter.getCoorArray(builder, projection.latlon2eastNorth(c));
    }

    private static JsonArrayBuilder getCoorArray(JsonArrayBuilder builder, EastNorth c) {
        return (builder != null ? builder : JSON_PROVIDER.createArrayBuilder()).add(BigDecimal.valueOf(c.getX()).setScale(11, RoundingMode.HALF_UP)).add(BigDecimal.valueOf(c.getY()).setScale(11, RoundingMode.HALF_UP));
    }

    protected void appendPrimitive(OsmPrimitive p, JsonArrayBuilder array) {
        if (p.isIncomplete() || this.options.contains((Object)Options.SKIP_EMPTY_NODES) && p instanceof Node && p.getKeys().isEmpty()) {
            return;
        }
        JsonObjectBuilder propObj = JSON_PROVIDER.createObjectBuilder();
        for (Map.Entry<String, String> entry : p.getKeys().entrySet()) {
            String key = this.options.contains((Object)Options.WRITE_OSM_INFORMATION) && entry.getKey().startsWith("@") ? "@" + entry.getKey() : entry.getKey();
            propObj.add(key, GeoJSONWriter.convertValueToJson(entry.getValue()));
        }
        if (this.options.contains((Object)Options.WRITE_OSM_INFORMATION)) {
            propObj.add("@id", p.getPrimitiveId().getType().getAPIName() + "/" + p.getUniqueId());
            if (!p.isNew()) {
                propObj.add("@timestamp", Instant.ofEpochSecond(p.getRawTimestamp()).toString());
                propObj.add("@version", Integer.toString(p.getVersion()));
                propObj.add("@changeset", Long.toString(p.getChangesetId()));
            }
            if (p.getUser() != null) {
                propObj.add("@user", p.getUser().getName());
                propObj.add("@uid", p.getUser().getId());
            }
            if (this.options.contains((Object)Options.WRITE_OSM_INFORMATION)) {
                if (p.getReferrers(true).stream().anyMatch(Relation.class::isInstance)) {
                    JsonArrayBuilder jsonArrayBuilder = JSON_PROVIDER.createArrayBuilder();
                    for (Relation relation : Utils.filteredCollection(p.getReferrers(), Relation.class)) {
                        JsonObjectBuilder relationObject = JSON_PROVIDER.createObjectBuilder();
                        relationObject.add("rel", relation.getId());
                        Collection<RelationMember> members = relation.getMembersFor(Collections.singleton(p));
                        relationObject.add("role", members.stream().map(RelationMember::getRole).collect(Collectors.joining(";")));
                        JsonObjectBuilder relationKeys = JSON_PROVIDER.createObjectBuilder();
                        for (Map.Entry<String, String> tag : relation.getKeys().entrySet()) {
                            relationKeys.add(tag.getKey(), GeoJSONWriter.convertValueToJson(tag.getValue()));
                        }
                        relationObject.add("reltags", relationKeys);
                    }
                    propObj.add("@relations", jsonArrayBuilder);
                }
            }
        }
        JsonObject prop = propObj.build();
        JsonObjectBuilder jsonObjectBuilder = JSON_PROVIDER.createObjectBuilder();
        p.accept(new GeometryPrimitiveVisitor(jsonObjectBuilder));
        JsonObject geom = jsonObjectBuilder.build();
        if (!geom.isEmpty()) {
            array.add(JSON_PROVIDER.createObjectBuilder().add("type", "Feature").add("properties", prop.isEmpty() ? JsonValue.NULL : prop).add("geometry", geom.isEmpty() ? JsonValue.NULL : geom));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonValue convertValueToJson(String value) {
        if (!value.startsWith(JSON_VALUE_START_MARKER)) return JSON_PROVIDER.createValue(value);
        if (!value.endsWith(JSON_VALUE_END_MARKER)) return JSON_PROVIDER.createValue(value);
        try (JsonParser parser = JSON_PROVIDER.createParser(new StringReader(value));){
            if (!parser.hasNext()) return JSON_PROVIDER.createValue(value);
            if (parser.next() == null) return JSON_PROVIDER.createValue(value);
            JsonValue jsonValue = parser.getValue();
            return jsonValue;
        }
        catch (JsonParsingException e) {
            Logging.warn(e);
        }
        return JSON_PROVIDER.createValue(value);
    }

    protected void appendLayerBounds(DataSet ds, JsonObjectBuilder object) {
        Iterator<Bounds> it;
        if (ds != null && (it = ds.getDataSourceBounds().iterator()).hasNext()) {
            Bounds b = new Bounds(it.next());
            while (it.hasNext()) {
                b.extend(it.next());
            }
            this.appendBounds(b, object);
        }
    }

    protected void appendBounds(Bounds b, JsonObjectBuilder object) {
        if (b != null) {
            JsonArrayBuilder builder = JSON_PROVIDER.createArrayBuilder();
            this.getCoorArray(builder, b.getMin());
            this.getCoorArray(builder, b.getMax());
            object.add("bbox", builder);
        }
    }

    protected void appendLayerFeatures(DataSet ds, JsonObjectBuilder object) {
        JsonArrayBuilder array = JSON_PROVIDER.createArrayBuilder();
        if (ds != null) {
            processedMultipolygonWays.clear();
            Collection primitives = ds.allNonDeletedPrimitives();
            for (OsmPrimitive p : primitives) {
                if (!(p instanceof Relation)) continue;
                this.appendPrimitive(p, array);
            }
            for (OsmPrimitive p : primitives) {
                if (p instanceof Relation) continue;
                this.appendPrimitive(p, array);
            }
            processedMultipolygonWays.clear();
        }
        object.add("features", array);
    }

    private class GeometryPrimitiveVisitor
    implements OsmPrimitiveVisitor {
        private final JsonObjectBuilder geomObj;

        GeometryPrimitiveVisitor(JsonObjectBuilder geomObj) {
            this.geomObj = geomObj;
        }

        @Override
        public void visit(Node n) {
            this.geomObj.add("type", "Point");
            LatLon ll = n.getCoor();
            if (ll != null) {
                this.geomObj.add("coordinates", GeoJSONWriter.this.getCoorArray(null, ll));
            }
        }

        @Override
        public void visit(Way w) {
            if (w != null) {
                if (!w.isTagged() && processedMultipolygonWays.contains(w)) {
                    return;
                }
                boolean writeAsPolygon = w.isClosed() && (!w.isTagged() && UNTAGGED_CLOSED_IS_POLYGON.get() != false || ElemStyles.hasAreaElemStyle(w, false));
                List<Node> nodes = w.getNodes();
                if (writeAsPolygon && GeoJSONWriter.this.options.contains((Object)Options.RIGHT_HAND_RULE) && Geometry.isClockwise(nodes)) {
                    Collections.reverse(nodes);
                }
                JsonArrayBuilder array = this.getCoorsArray(nodes);
                if (writeAsPolygon) {
                    this.geomObj.add("type", "Polygon");
                    this.geomObj.add("coordinates", JSON_PROVIDER.createArrayBuilder().add(array));
                } else {
                    this.geomObj.add("type", "LineString");
                    this.geomObj.add("coordinates", array);
                }
            }
        }

        @Override
        public void visit(Relation r) {
            if (r == null || !r.isMultipolygon() || r.hasIncompleteMembers()) {
                return;
            }
            if (r.isMultipolygon()) {
                try {
                    this.visitMultipolygon(r);
                    return;
                }
                catch (MultipolygonBuilder.JoinedPolygonCreationException ex) {
                    Logging.warn("GeoJSON: Failed to export multipolygon {0}, falling back to other multi geometry types", r.getUniqueId());
                    Logging.warn(ex);
                }
            }
            if (r.getMemberPrimitives().stream().allMatch(IWay.class::isInstance)) {
                this.visitMultiLineString(r);
            } else if (r.getMemberPrimitives().stream().allMatch(INode.class::isInstance)) {
                this.visitMultiPoints(r);
            } else {
                this.visitMultiGeometry(r);
            }
        }

        private void visitMultiGeometry(Relation r) {
            JsonArrayBuilder jsonArrayBuilder = JSON_PROVIDER.createArrayBuilder();
            r.getMemberPrimitives().stream().filter(p -> !(p instanceof Relation)).map(p -> {
                JsonObjectBuilder tempGeomObj = JSON_PROVIDER.createObjectBuilder();
                p.accept(new GeometryPrimitiveVisitor(tempGeomObj));
                return tempGeomObj.build();
            }).forEach(jsonArrayBuilder::add);
            this.geomObj.add("type", "GeometryCollection");
            this.geomObj.add("geometries", jsonArrayBuilder);
        }

        private void visitMultiPoints(Relation r) {
            JsonArrayBuilder multiPoint = JSON_PROVIDER.createArrayBuilder();
            r.getMembers().stream().map(RelationMember::getMember).filter(Node.class::isInstance).map(Node.class::cast).map(latLon -> GeoJSONWriter.this.getCoorArray(null, (ILatLon)latLon)).forEach(multiPoint::add);
            this.geomObj.add("type", "MultiPoint");
            this.geomObj.add("coordinates", multiPoint);
        }

        private void visitMultiLineString(Relation r) {
            JsonArrayBuilder multiLine = JSON_PROVIDER.createArrayBuilder();
            r.getMembers().stream().map(RelationMember::getMember).filter(Way.class::isInstance).map(Way.class::cast).map(Way::getNodes).map(p -> {
                JsonArrayBuilder array = this.getCoorsArray((Iterable<Node>)p);
                ILatLon ll = (ILatLon)p.get(0);
                return ll.isLatLonKnown() ? array.add(GeoJSONWriter.this.getCoorArray(null, ll)) : array;
            }).forEach(multiLine::add);
            this.geomObj.add("type", "MultiLineString");
            this.geomObj.add("coordinates", multiLine);
            processedMultipolygonWays.addAll(r.getMemberPrimitives(Way.class));
        }

        private void visitMultipolygon(Relation r) throws MultipolygonBuilder.JoinedPolygonCreationException {
            Pair<List<MultipolygonBuilder.JoinedPolygon>, List<MultipolygonBuilder.JoinedPolygon>> mp = MultipolygonBuilder.joinWays(r);
            JsonArrayBuilder polygon = JSON_PROVIDER.createArrayBuilder();
            Stream<List> outer = ((List)mp.a).stream().map(MultipolygonBuilder.JoinedPolygon::getNodes).map(nodes -> {
                ArrayList<Node> tempNodes = new ArrayList<Node>((Collection<Node>)nodes);
                tempNodes.add((Node)tempNodes.get(0));
                if (GeoJSONWriter.this.options.contains((Object)Options.RIGHT_HAND_RULE) && Geometry.isClockwise(tempNodes)) {
                    Collections.reverse(nodes);
                }
                return nodes;
            });
            Stream<List> inner = ((List)mp.b).stream().map(MultipolygonBuilder.JoinedPolygon::getNodes).map(nodes -> {
                ArrayList<Node> tempNodes = new ArrayList<Node>((Collection<Node>)nodes);
                tempNodes.add((Node)tempNodes.get(0));
                if (GeoJSONWriter.this.options.contains((Object)Options.RIGHT_HAND_RULE) && !Geometry.isClockwise(tempNodes)) {
                    Collections.reverse(nodes);
                }
                return nodes;
            });
            Stream.concat(outer, inner).map(p -> {
                JsonArrayBuilder array = this.getCoorsArray((Iterable<Node>)p);
                ILatLon ll = (ILatLon)p.get(0);
                return ll.isLatLonKnown() ? array.add(GeoJSONWriter.this.getCoorArray(null, ll)) : array;
            }).forEach(polygon::add);
            JsonArrayBuilder multiPolygon = JSON_PROVIDER.createArrayBuilder().add(polygon);
            this.geomObj.add("type", "MultiPolygon");
            this.geomObj.add("coordinates", multiPolygon);
            processedMultipolygonWays.addAll(r.getMemberPrimitives(Way.class));
        }

        private JsonArrayBuilder getCoorsArray(Iterable<Node> nodes) {
            JsonArrayBuilder builder = JSON_PROVIDER.createArrayBuilder();
            for (Node n : nodes) {
                if (!n.isLatLonKnown()) continue;
                builder.add(GeoJSONWriter.this.getCoorArray(null, n));
            }
            return builder;
        }
    }

    static enum Options {
        RIGHT_HAND_RULE,
        WRITE_OSM_INFORMATION,
        SKIP_EMPTY_NODES;

    }
}

