/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.Queries;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutionInterceptor;
import com.intellij.util.QueryWrapper;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u0013\u0010\u0003\u001a\r\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\b\u0005H&J\u000f\u0010\u0006\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000bH&J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000bH\u0017J!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\t2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\t2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0014H\u0017J2\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0000\"\u0004\b\u0001\u0010\u00172\u001c\u0010\u0018\u001a\u0018\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00040\u0019H\u0017J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0000\"\u0004\b\u0001\u0010\u00172\u0016\u0010\u001b\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H\u00170\u0019H\u0017J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0014H\u0017J4\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0000\"\u0004\b\u0001\u0010\u00172\u001e\u0010\u001b\u001a\u001a\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00170\u00000\u0019H\u0017J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0017J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0017J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0097\u0002J\u0018\u0010\b\u001a\u00020\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000$H\u0017J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0017J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010(\u001a\u00020)H\u0017J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006-\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/Query;", "Result", "", "findAll", "", "Lorg/jetbrains/annotations/Unmodifiable;", "findFirst", "()Ljava/lang/Object;", "forEach", "", "consumer", "Lcom/intellij/util/Processor;", "forEachAsync", "Lcom/intellij/concurrency/AsyncFuture;", "toArray", "", "a", "([Ljava/lang/Object;)[Ljava/lang/Object;", "allMatch", "predicate", "Ljava/util/function/Predicate;", "anyMatch", "transforming", "R", "transformation", "Ljava/util/function/Function;", "mapping", "mapper", "filtering", "flatMapping", "allowParallelProcessing", "asIterable", "iterator", "", "", "action", "Ljava/util/function/Consumer;", "spliterator", "Ljava/util/Spliterator;", "interceptWith", "interceptor", "Lcom/intellij/util/QueryExecutionInterceptor;", "wrap", "wrapper", "Lcom/intellij/util/QueryWrapper;", "intellij.platform.core"})
public interface Query<Result>
extends Iterable<Result>,
KMappedMarker {
    @NotNull
    public Collection<Result> findAll();

    @Nullable
    public Result findFirst();

    public boolean forEach(@NotNull Processor<? super Result> var1);

    @Deprecated(message="use {@link #forEach(Processor)} instead")
    @NotNull
    default public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super Result> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.forEach(consumer));
        Intrinsics.checkNotNullExpressionValue(asyncFuture, "wrapBoolean(...)");
        return asyncFuture;
    }

    @NotNull
    default public Result[] toArray(@NotNull Result[] a) {
        Intrinsics.checkNotNullParameter(a, "a");
        return UtilKt.toArray(this.findAll(), a);
    }

    @Contract(pure=true)
    default public boolean allMatch(@NotNull Predicate<? super Result> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return this.forEach(arg_0 -> Query.allMatch$lambda$0(predicate, arg_0));
    }

    @Contract(pure=true)
    default public boolean anyMatch(@NotNull Predicate<? super Result> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return !this.forEach(arg_0 -> Query.anyMatch$lambda$1(predicate, arg_0));
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> transforming(@NotNull Function<? super Result, ? extends Collection<? extends R>> transformation) {
        Intrinsics.checkNotNullParameter(transformation, "transformation");
        Query query = Queries.getInstance().transforming(this, transformation);
        Intrinsics.checkNotNullExpressionValue(query, "transforming(...)");
        return query;
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> mapping(@NotNull Function<? super Result, ? extends R> mapper) {
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        return this.transforming(arg_0 -> Query.mapping$lambda$3(arg_0 -> Query.mapping$lambda$2(mapper, arg_0), arg_0));
    }

    @ApiStatus.Experimental
    @NotNull
    default public Query<Result> filtering(@NotNull Predicate<? super Result> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return this.transforming(arg_0 -> Query.filtering$lambda$5(arg_0 -> Query.filtering$lambda$4(predicate, arg_0), arg_0));
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> flatMapping(@NotNull Function<? super Result, ? extends Query<? extends R>> mapper) {
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        Query query = Queries.getInstance().flatMapping(this, mapper);
        Intrinsics.checkNotNullExpressionValue(query, "flatMapping(...)");
        return query;
    }

    @Contract(pure=true)
    @NotNull
    default public Query<Result> allowParallelProcessing() {
        return this;
    }

    @Deprecated(message="Don't use Query as Iterable. Call {@link #findAll} explicitly, but first,\nconsider whether it's necessary to find all results at once, e.g., use {@link #anyMatch} or {@link #allMatch}", replaceWith=@ReplaceWith(expression="findAll()", imports={}))
    @NotNull
    default public Iterable<Result> asIterable() {
        return this.findAll();
    }

    @Override
    @Deprecated(message="Don't use Query as Iterable, the results are computed eagerly, which defeats the purpose", replaceWith=@ReplaceWith(expression="asIterable().iterator()", imports={}))
    @ApiStatus.ScheduledForRemoval
    @NotNull
    default public Iterator<Result> iterator() {
        return this.asIterable().iterator();
    }

    @Override
    @Deprecated(message="Don't use Query as Iterable, the results are computed eagerly, which defeats the purpose", replaceWith=@ReplaceWith(expression="asIterable().forEach(action)", imports={}))
    @ApiStatus.ScheduledForRemoval
    default public void forEach(@NotNull Consumer<? super Result> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        this.asIterable().forEach(action);
    }

    @Override
    @Deprecated(message="Don't use Query as Iterable, the results are computed eagerly, which defeats the purpose", replaceWith=@ReplaceWith(expression="asIterable().spliterator()", imports={}))
    @ApiStatus.ScheduledForRemoval
    @NotNull
    default public Spliterator<Result> spliterator() {
        Spliterator<Result> spliterator = this.asIterable().spliterator();
        Intrinsics.checkNotNullExpressionValue(spliterator, "spliterator(...)");
        return spliterator;
    }

    @ApiStatus.Experimental
    @NotNull
    default public Query<Result> interceptWith(@NotNull QueryExecutionInterceptor interceptor) {
        Intrinsics.checkNotNullParameter(interceptor, "interceptor");
        Query query = this;
        return new AbstractQuery<Result>(interceptor, query){
            final /* synthetic */ QueryExecutionInterceptor $interceptor;
            final /* synthetic */ Query<Result> $query;
            {
                this.$interceptor = $interceptor;
                this.$query = $query;
            }

            protected boolean processResults(Processor<? super Result> consumer) {
                Intrinsics.checkNotNullParameter(consumer, "consumer");
                return this.$interceptor.intercept(() -> interceptWith.1.processResults$lambda$0(this.$query, consumer));
            }

            private static final boolean processResults$lambda$0(Query $query, Processor $consumer) {
                return AbstractQuery.delegateProcessResults($query, $consumer);
            }
        };
    }

    @Deprecated(message="use {@link #interceptWith}")
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Experimental
    @NotNull
    default public Query<Result> wrap(@NotNull QueryWrapper<Result> wrapper) {
        Intrinsics.checkNotNullParameter(wrapper, "wrapper");
        Query query = this;
        return new AbstractQuery<Result>(wrapper, query){
            final /* synthetic */ QueryWrapper<Result> $wrapper;
            final /* synthetic */ Query<Result> $query;
            {
                this.$wrapper = $wrapper;
                this.$query = $query;
            }

            protected boolean processResults(Processor<? super Result> consumer) {
                Intrinsics.checkNotNullParameter(consumer, "consumer");
                return this.$wrapper.wrapExecution(arg_0 -> wrap.1.processResults$lambda$0(this.$query, arg_0), consumer);
            }

            private static final boolean processResults$lambda$0(Query $query, Processor c) {
                return AbstractQuery.delegateProcessResults($query, c);
            }
        };
    }

    private static boolean allMatch$lambda$0(Predicate $predicate, Object t) {
        return $predicate.test(t);
    }

    private static boolean anyMatch$lambda$1(Predicate $predicate, Object t) {
        return !$predicate.test(t);
    }

    private static Collection mapping$lambda$2(Function $mapper, Object value) {
        return CollectionsKt.listOf($mapper.apply(value));
    }

    private static Collection mapping$lambda$3(Function1 $tmp0, Object p0) {
        return (Collection)$tmp0.invoke(p0);
    }

    private static Collection filtering$lambda$4(Predicate $predicate, Object value) {
        return $predicate.test(value) ? CollectionsKt.listOf(value) : CollectionsKt.emptyList();
    }

    private static Collection filtering$lambda$5(Function1 $tmp0, Object p0) {
        return (Collection)$tmp0.invoke(p0);
    }
}

