/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaPackageAccessibilityStatementElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiPackageAccessibilityStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public class PsiPackageAccessibilityStatementStubImpl
extends StubBase<PsiPackageAccessibilityStatement>
implements PsiPackageAccessibilityStatementStub {
    private final String myPackageName;
    private final List<String> myTargets;

    public PsiPackageAccessibilityStatementStubImpl(StubElement parent2, IStubElementType type, String packageName2, List<String> targets) {
        super(parent2, type);
        this.myPackageName = ObjectUtils.notNull(packageName2, "");
        this.myTargets = targets == null || targets.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(targets);
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public List<String> getTargets() {
        return this.myTargets;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PsiPackageAccessibilityStatementStub[").append((Object)JavaPackageAccessibilityStatementElementType.typeToRole(this.getStubType())).append("]:").append(this.myPackageName);
        for (String target : this.myTargets) {
            sb.append(':').append(target);
        }
        return sb.toString();
    }
}

