/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import com.thebuzzmedia.imgscalr.AsyncScalr;
import com.thebuzzmedia.imgscalr.Scalr;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.map.MapView;

public class BitmapViewerComponent
extends JComponent
implements ScalableComponent {
    private static final long serialVersionUID = 1L;
    private File cacheFile;
    private int hint;
    private AtomicReference<BufferedImage> cachedImage;
    private AtomicInteger targetWidth = new AtomicInteger();
    private WeakReference<BufferedImage> cachedImageWeakRef;
    private final URL url;
    private final Dimension originalSize;
    private boolean scaleEnabled;
    private Dimension maximumSize = null;
    private Runnable rendererListener = null;
    private static boolean disabledDueToJavaBug = false;

    public BitmapViewerComponent(URI uri) throws MalformedURLException, IOException {
        this.url = uri.toURL();
        this.originalSize = BitmapViewerComponent.readImageSize(this.url);
        this.hint = 4;
        this.scaleEnabled = true;
        this.cachedImage = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dimension readImageSize(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();
             ImageInputStream in = ImageIO.createImageInputStream(inputStream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    return dimension;
                }
                finally {
                    reader.dispose();
                }
            }
            throw new IOException("can not create image");
        }
    }

    public boolean isScaleEnabled() {
        return this.scaleEnabled;
    }

    public void setScaleEnabled(boolean scaleEnabled) {
        this.scaleEnabled = scaleEnabled;
    }

    protected int getHint() {
        return this.hint;
    }

    public void setHint(int hint) {
        this.hint = hint;
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this.originalSize);
    }

    @Override
    public void paintComponent(Graphics g) {
        AccessController.doPrivileged(() -> this.paintComponentPrivileged(g));
    }

    private Void paintComponentPrivileged(Graphics g) {
        if (this.componentHasNoArea() || disabledDueToJavaBug) {
            return null;
        }
        if (this.isPrinting()) {
            this.paintOriginalImage(g);
            return null;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        int targetWidth = this.getWidth();
        int requiredImageWidth = (int)((double)targetWidth * scaleX);
        int requiredImageHeight = (int)((double)this.getHeight() * scaleY);
        BufferedImage cachedImage = this.loadImageFromCacheFile();
        if (!this.isCachedImageValid(requiredImageWidth, requiredImageHeight) && this.targetWidth.getAndSet(targetWidth) != targetWidth) {
            AsyncScalrService.getService().submit(() -> {
                if (targetWidth != this.getWidth()) {
                    return;
                }
                BufferedImage image = this.loadImageFromURL();
                if (image == null || this.hasNoArea(image)) {
                    return;
                }
                BufferedImage scaledImage = null;
                try {
                    scaledImage = Scalr.resize(image, Scalr.Mode.BEST_FIT_BOTH, requiredImageWidth, requiredImageHeight, new BufferedImageOp[0]);
                }
                finally {
                    image.flush();
                }
                this.setCachedImage(scaledImage);
                if (this.getCacheType().equals((Object)CacheType.IC_FILE)) {
                    this.writeCacheFile();
                }
                SwingUtilities.invokeLater(() -> {
                    this.targetWidth.set(0);
                    if (this.rendererListener != null) {
                        this.rendererListener.run();
                    }
                    if (this.isVisible()) {
                        this.repaint();
                    }
                });
            });
        }
        try {
            if (cachedImage == null || this.hasNoArea(cachedImage)) {
                return null;
            }
            int cachedImageWidth = cachedImage.getWidth();
            int cachedImageHeight = cachedImage.getHeight();
            Rectangle imageCoordinates = this.calculateImageCoordinates(requiredImageWidth, requiredImageHeight, cachedImageWidth, cachedImageHeight);
            if (scaleX != 1.0 || scaleY != 1.0) {
                Graphics2D gg = (Graphics2D)g.create();
                gg.setTransform(AffineTransform.getTranslateInstance((double)imageCoordinates.x + transform.getTranslateX(), (double)imageCoordinates.y + transform.getTranslateY()));
                gg.drawImage(cachedImage, 0, 0, imageCoordinates.width, imageCoordinates.height, null);
                gg.dispose();
            } else {
                g.drawImage(cachedImage, imageCoordinates.x, imageCoordinates.y, imageCoordinates.width, imageCoordinates.height, null);
            }
        }
        catch (ClassCastException e) {
            LogUtils.severe("Disabled bitmap image painting due to java bug https://bugs.openjdk.java.net/browse/JDK-8160328. Modify freeplane.sh to run java with option '-Dsun.java2d.xrender=false'");
            disabledDueToJavaBug = true;
        }
        this.flushImage();
        return null;
    }

    private Rectangle calculateImageCoordinates(int requiredImageWidth, int requiredImageHeight, int imageWidth, int imageHeight) {
        Rectangle imageCoordinates = new Rectangle(0, 0, requiredImageWidth, requiredImageHeight);
        long k = (long)requiredImageWidth * (long)imageHeight - (long)imageWidth * (long)requiredImageHeight;
        if (k > 0L) {
            int scaledImageWidth;
            imageCoordinates.width = scaledImageWidth = requiredImageHeight * imageWidth / imageHeight;
            imageCoordinates.x = (requiredImageWidth - scaledImageWidth) / 2;
        } else if (k < 0L) {
            int scaledImageHeight;
            imageCoordinates.height = scaledImageHeight = requiredImageWidth * imageHeight / imageWidth;
            imageCoordinates.y = (requiredImageHeight - scaledImageHeight) / 2;
        }
        return imageCoordinates;
    }

    private void paintOriginalImage(Graphics g) {
        BufferedImage image = this.loadImageFromURL();
        if (image != null && !this.hasNoArea(image)) {
            try {
                Rectangle imageCoordinates = this.calculateImageCoordinates(this.getWidth(), this.getHeight(), image.getWidth(), image.getHeight());
                g.drawImage(image, imageCoordinates.x, imageCoordinates.y, imageCoordinates.width, imageCoordinates.height, null);
            }
            catch (ClassCastException e) {
                LogUtils.severe("Disabled bitmap image painting due to java bug https://bugs.openjdk.java.net/browse/JDK-8160328. Modify freeplane.sh to run java with option '-Dsun.java2d.xrender=false'");
                disabledDueToJavaBug = true;
            }
        }
    }

    private boolean isPrinting() {
        MapView map = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        return map != null && map.isPrinting();
    }

    private boolean componentHasNoArea() {
        return this.getWidth() == 0 || this.getHeight() == 0;
    }

    private boolean hasNoArea(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        return imageWidth == 0 || imageHeight == 0;
    }

    private BufferedImage loadImageFromCacheFile() {
        BufferedImage cachedImage = this.getCachedImage();
        try {
            if (cachedImage == null && this.cacheFile != null) {
                BufferedImage image = ImageIO.read(this.cacheFile);
                this.setCachedImage(image);
                return image;
            }
        }
        catch (IOException e) {
            this.logImageReadingException(e);
        }
        return cachedImage;
    }

    private boolean isCachedImageValid(int width, int height) {
        return this.getCachedImage() != null && (!this.scaleEnabled || this.componentHasSameWidthAsCachedImage(width) && this.cachedImageHeightFitsComponentHeight(height) || this.cachedImageWidthFitsComponentWidth(width) && this.componentHasSameHeightAsCachedImage(height));
    }

    private boolean componentHasSameHeightAsCachedImage(int height) {
        return 1 >= Math.abs(height - this.getCachedImage().getHeight());
    }

    private boolean cachedImageWidthFitsComponentWidth(int width) {
        return width >= this.getCachedImage().getWidth();
    }

    private boolean cachedImageHeightFitsComponentHeight(int height) {
        return height >= this.getCachedImage().getHeight();
    }

    private boolean componentHasSameWidthAsCachedImage(int width) {
        return 1 >= Math.abs(width - this.getCachedImage().getWidth());
    }

    private BufferedImage loadImageFromURL() {
        BufferedImage tempImage = null;
        try {
            tempImage = ImageIO.read(this.url);
        }
        catch (IOException e) {
            this.logImageReadingException(e);
        }
        return tempImage;
    }

    private void logImageReadingException(IOException e) {
        if (e instanceof FileNotFoundException || e instanceof IIOException) {
            LogUtils.warn(e.getMessage());
            return;
        }
        Throwable cause = e.getCause();
        if (cause instanceof FileNotFoundException || cause instanceof IIOException) {
            LogUtils.warn(cause.getMessage());
            return;
        }
        LogUtils.severe(e);
    }

    private void flushImage() {
        CacheType cacheType = this.getCacheType();
        if (CacheType.IC_RAM.equals((Object)cacheType)) {
            this.getCachedImage().flush();
        } else {
            this.cachedImageWeakRef = new WeakReference<BufferedImage>(this.getCachedImage());
            this.setCachedImage(null);
        }
    }

    private CacheType getCacheType() {
        return ResourceController.getResourceController().getEnumProperty("image_cache", CacheType.IC_DISABLE);
    }

    private void writeCacheFile() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block4: {
                    File tempDir = new File(System.getProperty("java.io.tmpdir"), "freeplane");
                    tempDir.mkdirs();
                    try {
                        BufferedImage cachedImage;
                        if (BitmapViewerComponent.this.cacheFile == null) {
                            BitmapViewerComponent.this.cacheFile = File.createTempFile("cachedImage", ".image", tempDir);
                        }
                        if (!ImageIO.write((RenderedImage)(cachedImage = BitmapViewerComponent.this.getCachedImage()), "jpg", BitmapViewerComponent.this.cacheFile)) {
                            ImageIO.write((RenderedImage)cachedImage, "png", BitmapViewerComponent.this.cacheFile);
                        }
                    }
                    catch (IOException e) {
                        if (BitmapViewerComponent.this.cacheFile == null) break block4;
                        BitmapViewerComponent.this.cacheFile.delete();
                        BitmapViewerComponent.this.cacheFile = null;
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.cacheFile != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    BitmapViewerComponent.this.cacheFile.delete();
                    return null;
                }
            });
            this.cacheFile = null;
        }
    }

    @Override
    public void setFinalViewerSize(Dimension size) {
        Dimension sizeWithScaleCorrection = this.fitToMaximumSize(size);
        this.setPreferredSize(sizeWithScaleCorrection);
        this.setSize(sizeWithScaleCorrection);
        this.setScaleEnabled(true);
    }

    @Override
    public void setFinalViewerSize(float zoom) {
        int scaledWidth = (int)((float)this.originalSize.width * zoom);
        int scaledHeight = (int)((float)this.originalSize.height * zoom);
        this.setFinalViewerSize(new Dimension(scaledWidth, scaledHeight));
    }

    @Override
    public void setDraftViewerSize(Dimension size) {
        this.setPreferredSize(size);
        this.setSize(size);
        this.setScaleEnabled(false);
    }

    @Override
    public void setMaximumComponentSize(Dimension size) {
        this.maximumSize = size;
    }

    private Dimension fitToMaximumSize(Dimension size) {
        if (this.maximumSize == null || this.isUnderMaximumSize(size)) {
            return size;
        }
        return this.maximumSize;
    }

    private boolean isUnderMaximumSize(Dimension size) {
        return this.maximumSize.getWidth() >= (double)size.width || this.maximumSize.getHeight() >= (double)size.height;
    }

    private BufferedImage getCachedImage() {
        BufferedImage image = this.cachedImage.get();
        if (image == null && this.cachedImageWeakRef != null) {
            image = (BufferedImage)this.cachedImageWeakRef.get();
            this.setCachedImage(image);
            this.cachedImageWeakRef = null;
        }
        return image;
    }

    private void setCachedImage(BufferedImage cachedImage) {
        this.cachedImage.set(cachedImage);
    }

    public void setRendererListener(Runnable callback) {
        this.rendererListener = callback;
    }

    private static class AsyncScalrService
    extends AsyncScalr {
        private AsyncScalrService() {
        }

        public static ExecutorService getService() {
            if (service == null) {
                AsyncScalrService.checkService();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        service.shutdown();
                        try {
                            if (service.awaitTermination(5L, TimeUnit.SECONDS)) return;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return service;
        }
    }

    static enum CacheType {
        IC_DISABLE,
        IC_FILE,
        IC_RAM;

    }
}

