/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.DTOId;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

class Fragment
extends DTOId
implements BundleRequirement {
    final BundleGeneration gen;
    final String hostName;
    final String extension;
    final VersionRange versionRange;
    final Map<String, Object> attributes;
    final Map<String, String> directives;
    private final Vector<BundleGeneration> hosts = new Vector(2);

    Fragment(BundleGeneration gen, Util.HeaderEntry headerEntry) {
        this.gen = gen;
        this.hostName = headerEntry.getKey();
        if (gen.archive.getAttribute("Bundle-Activator") != null) {
            throw new IllegalArgumentException("A fragment bundle can not have a Bundle-Activator.");
        }
        Map<String, String> dirs = headerEntry.getDirectives();
        String extension = dirs.get("extension");
        if ("system.bundle".equals(this.hostName) || "org.knopflerfish.framework".equals(this.hostName)) {
            if (extension != null) {
                if (!"framework".equals(extension) && !"bootclasspath".equals(extension)) {
                    throw new IllegalArgumentException("An extension bundle must target the system bundle(system.bundle or org.knopflerfish.framework)");
                }
            } else {
                extension = "framework";
            }
            if (gen.archive.getAttribute("Import-Package") != null || gen.archive.getAttribute("Require-Bundle") != null || gen.archive.getAttribute("Bundle-NativeCode") != null || gen.archive.getAttribute("DynamicImport-Package") != null || gen.archive.getAttribute("Bundle-Activator") != null) {
                throw new IllegalArgumentException("An extension bundle cannot specify: Import-Package, Require-Bundle, Bundle-NativeCode, DynamicImport-Package or Bundle-Activator");
            }
            if (!gen.bundle.fwCtx.props.getBooleanProperty("org.osgi.supports.framework.extension") && "framework".equals(extension)) {
                throw new UnsupportedOperationException("Framework extension bundles are not supported by this framework. Consult the documentation");
            }
            if (!gen.bundle.fwCtx.props.getBooleanProperty("org.osgi.supports.bootclasspath.extension") && "bootclasspath".equals(extension)) {
                throw new UnsupportedOperationException("Bootclasspath extension bundles are not supported by this framework. Consult the documentation");
            }
        } else if (extension != null) {
            throw new IllegalArgumentException("Did not recognize directive extension:=" + extension + ".");
        }
        this.extension = extension;
        String range = (String)headerEntry.getAttributes().remove("bundle-version");
        this.versionRange = range == null ? null : new VersionRange(range);
        this.attributes = headerEntry.getAttributes();
        Filter filter = this.toFilter();
        if (null != filter) {
            dirs.put("filter", ((Object)filter).toString());
        }
        this.directives = Collections.unmodifiableMap(dirs);
    }

    void addHost(BundleGeneration host) {
        this.hosts.add(host);
    }

    void removeHost(BundleGeneration host) {
        if (host == null) {
            this.hosts.clear();
        } else {
            this.hosts.remove(host);
        }
    }

    boolean isHost(BundleGeneration host) {
        return this.hosts.contains(host);
    }

    Vector<BundleGeneration> getHosts() {
        return (Vector)this.hosts.clone();
    }

    boolean hasHosts() {
        return !this.hosts.isEmpty();
    }

    boolean isTarget(BundleGeneration bg) {
        return (this.hostName.equals(bg.symbolicName) || this.extension != null && "org.knopflerfish.framework" == bg.symbolicName) && (this.versionRange == null || this.versionRange.includes(bg.version)) && bg.bsnAttrMatch(this.attributes);
    }

    List<BundleGeneration> targets() {
        List<BundleGeneration> lbg = this.gen.bundle.fwCtx.bundles.getBundles(this.hostName, this.versionRange);
        Iterator<BundleGeneration> i = lbg.iterator();
        while (i.hasNext()) {
            BundleGeneration tbg = i.next();
            if (!tbg.attachPolicy.equals("never") && this.isTarget(tbg)) continue;
            i.remove();
        }
        return lbg;
    }

    @Override
    public String getNamespace() {
        return "osgi.wiring.host";
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    private Filter toFilter() {
        StringBuffer sb = new StringBuffer(80);
        boolean multipleConditions = false;
        sb.append('(');
        sb.append("osgi.wiring.host");
        sb.append('=');
        if ("system.bundle".equals(this.hostName)) {
            sb.append("org.knopflerfish.framework");
        } else {
            sb.append(this.hostName);
        }
        sb.append(')');
        if (this.versionRange != null) {
            sb.append(this.versionRange.toFilterString("bundle-version"));
            multipleConditions = true;
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            sb.append('(');
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().toString());
            sb.append(')');
            multipleConditions |= true;
        }
        if (multipleConditions) {
            sb.insert(0, "(&");
            sb.append(')');
        }
        try {
            return FrameworkUtil.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException _ise) {
            System.err.println("createFilter: '" + sb.toString() + "': " + _ise.getMessage());
            return null;
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public BundleRevision getRevision() {
        return this.gen.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.gen.bundleRevision;
    }

    @Override
    public boolean matches(BundleCapability capability) {
        if ("osgi.wiring.host".equals(capability.getNamespace())) {
            return this.toFilter().matches(capability.getAttributes());
        }
        return false;
    }
}

