/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.laf;

import java.awt.Component;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.infonode.gui.icon.button.TreeIcon;
import net.infonode.gui.laf.InfoNodeLookAndFeelTheme;
import net.infonode.gui.laf.ui.SlimComboBoxUI;
import net.infonode.gui.laf.ui.SlimInternalFrameUI;
import net.infonode.gui.laf.ui.SlimMenuItemUI;
import net.infonode.gui.laf.ui.SlimSplitPaneUI;
import net.infonode.util.ArrayUtil;
import net.infonode.util.ColorUtil;

public class InfoNodeLookAndFeel
extends MetalLookAndFeel {
    public static final UIManager.LookAndFeelInfo LOOK_AND_FEEL_INFO = new UIManager.LookAndFeelInfo("InfoNode", InfoNodeLookAndFeel.class.getName());
    private static MetalTheme oldMetalTheme;
    private transient InfoNodeLookAndFeelTheme theme;
    private transient DefaultMetalTheme defaultTheme = new DefaultMetalTheme(){

        @Override
        public ColorUIResource getPrimaryControlHighlight() {
            return InfoNodeLookAndFeel.this.theme.getPrimaryControlHighlightColor();
        }

        @Override
        public ColorUIResource getMenuBackground() {
            return InfoNodeLookAndFeel.this.theme.getControlColor();
        }

        @Override
        public ColorUIResource getControlHighlight() {
            return InfoNodeLookAndFeel.this.theme.getControlHighlightColor();
        }

        @Override
        public ColorUIResource getControl() {
            return InfoNodeLookAndFeel.this.theme.getControlColor();
        }

        @Override
        public ColorUIResource getControlShadow() {
            return InfoNodeLookAndFeel.this.theme.getControlShadowColor();
        }

        @Override
        public ColorUIResource getControlDarkShadow() {
            return InfoNodeLookAndFeel.this.theme.getControlDarkShadowColor();
        }

        @Override
        public ColorUIResource getPrimaryControl() {
            return InfoNodeLookAndFeel.this.theme.getPrimaryControlColor();
        }

        @Override
        public ColorUIResource getPrimaryControlShadow() {
            return InfoNodeLookAndFeel.this.theme.getPrimaryControlShadowColor();
        }

        @Override
        public ColorUIResource getPrimaryControlDarkShadow() {
            return InfoNodeLookAndFeel.this.theme.getPrimaryControlDarkShadowColor();
        }

        @Override
        public ColorUIResource getTextHighlightColor() {
            return InfoNodeLookAndFeel.this.theme.getSelectedTextBackgroundColor();
        }

        @Override
        public ColorUIResource getMenuSelectedBackground() {
            return InfoNodeLookAndFeel.this.theme.getSelectedMenuBackgroundColor();
        }

        @Override
        public ColorUIResource getWindowBackground() {
            return InfoNodeLookAndFeel.this.theme.getBackgroundColor();
        }

        @Override
        protected ColorUIResource getWhite() {
            return InfoNodeLookAndFeel.this.theme.getBackgroundColor();
        }

        @Override
        public ColorUIResource getDesktopColor() {
            return InfoNodeLookAndFeel.this.theme.getDesktopColor();
        }

        @Override
        public ColorUIResource getHighlightedTextColor() {
            return InfoNodeLookAndFeel.this.theme.getSelectedTextColor();
        }

        @Override
        protected ColorUIResource getBlack() {
            return InfoNodeLookAndFeel.this.theme.getTextColor();
        }

        @Override
        public ColorUIResource getMenuForeground() {
            return InfoNodeLookAndFeel.this.theme.getTextColor();
        }

        @Override
        public ColorUIResource getMenuSelectedForeground() {
            return InfoNodeLookAndFeel.this.theme.getSelectedMenuForegroundColor();
        }

        @Override
        public ColorUIResource getFocusColor() {
            return InfoNodeLookAndFeel.this.theme.getFocusColor();
        }

        @Override
        public ColorUIResource getControlDisabled() {
            return InfoNodeLookAndFeel.this.theme.getControlColor();
        }

        @Override
        public ColorUIResource getSystemTextColor() {
            return InfoNodeLookAndFeel.this.theme.getTextColor();
        }

        @Override
        public ColorUIResource getControlTextColor() {
            return InfoNodeLookAndFeel.this.theme.getTextColor();
        }

        @Override
        public ColorUIResource getInactiveControlTextColor() {
            return InfoNodeLookAndFeel.this.theme.getInactiveTextColor();
        }

        @Override
        public ColorUIResource getInactiveSystemTextColor() {
            return InfoNodeLookAndFeel.this.theme.getInactiveTextColor();
        }

        @Override
        public ColorUIResource getUserTextColor() {
            return InfoNodeLookAndFeel.this.theme.getTextColor();
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.getSystemTextFont();
        }

        @Override
        public FontUIResource getSystemTextFont() {
            return InfoNodeLookAndFeel.this.theme.getFont();
        }

        @Override
        public FontUIResource getUserTextFont() {
            return this.getSystemTextFont();
        }

        @Override
        public FontUIResource getMenuTextFont() {
            return this.getSystemTextFont();
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getSystemTextFont();
        }

        @Override
        public FontUIResource getSubTextFont() {
            return this.getSystemTextFont();
        }
    };

    public InfoNodeLookAndFeel() {
        this(new InfoNodeLookAndFeelTheme());
    }

    public InfoNodeLookAndFeel(InfoNodeLookAndFeelTheme theme) {
        this.theme = theme;
    }

    public InfoNodeLookAndFeelTheme getTheme() {
        return this.theme;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (oldMetalTheme == null) {
            try {
                oldMetalTheme = (MetalTheme)MetalLookAndFeel.class.getMethod("getCurrentTheme", null).invoke(null, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        InfoNodeLookAndFeel.setCurrentTheme(this.defaultTheme);
    }

    @Override
    public void uninitialize() {
        InfoNodeLookAndFeel.setCurrentTheme(oldMetalTheme == null ? new DefaultMetalTheme() : oldMetalTheme);
        oldMetalTheme = null;
    }

    @Override
    public String getName() {
        return LOOK_AND_FEEL_INFO.getName();
    }

    @Override
    public String getDescription() {
        return "A slim look and feel based on Metal.";
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        try {
            Class cl = SlimSplitPaneUI.class;
            table.put("SplitPaneUI", cl.getName());
            table.put(cl.getName(), cl);
            cl = SlimInternalFrameUI.class;
            table.put("InternalFrameUI", cl.getName());
            table.put(cl.getName(), cl);
            cl = SlimComboBoxUI.class;
            SlimComboBoxUI.NORMAL_BORDER = this.theme.getListItemBorder();
            SlimComboBoxUI.FOCUS_BORDER = this.theme.getListFocusedItemBorder();
            table.put("ComboBoxUI", cl.getName());
            table.put(cl.getName(), cl);
            cl = SlimMenuItemUI.class;
            table.put("MenuItemUI", cl.getName());
            table.put(cl.getName(), cl);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        Class<MetalLookAndFeel> iconClass = MetalLookAndFeel.class;
        MetalBorders.MenuItemBorder menuItemBorder = new MetalBorders.MenuItemBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(2, 0, 2, 0);
            }
        };
        Object[] defaults = new Object[]{"SplitPane.dividerSize", new Integer(this.theme.getSplitPaneDividerSize()), "TabbedPane.background", this.theme.getControlLightShadowColor(), "ComboBox.selectionBackground", this.theme.getSelectedMenuBackgroundColor(), "ComboBox.selectionForeground", this.theme.getSelectedMenuForegroundColor(), "List.cellRenderer", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new MyListCellRenderer.UIResource(InfoNodeLookAndFeel.this.theme.getListItemBorder(), InfoNodeLookAndFeel.this.theme.getListFocusedItemBorder());
            }
        }, "ToolTip.foreground", this.theme.getTooltipForegroundColor(), "ToolTip.background", this.theme.getTooltipBackgroundColor(), "Viewport.background", this.theme.getBackgroundColor(), "ScrollBar.background", this.theme.getScrollBarBackgroundColor(), "ScrollBar.shadow", this.theme.getScrollBarBackgroundShadowColor(), "ScrollBar.width", new Integer(this.theme.getScrollBarWidth()), "Table.focusCellBackground", new ColorUIResource(ColorUtil.mult(this.theme.getSelectedMenuBackgroundColor(), 1.4f)), "Table.focusCellForeground", this.theme.getSelectedMenuForegroundColor(), "TableHeader.cellBorder", this.theme.getTableHeaderCellBorder(), "InternalFrame.activeTitleBackground", this.theme.getActiveInternalFrameTitleBackgroundColor(), "InternalFrame.activeTitleForeground", this.theme.getActiveInternalFrameTitleForegroundColor(), "InternalFrame.activeTitleGradient", this.theme.getActiveInternalFrameTitleGradientColor(), "InternalFrame.inactiveTitleBackground", this.theme.getInactiveInternalFrameTitleBackgroundColor(), "InternalFrame.inactiveTitleForeground", this.theme.getInactiveInternalFrameTitleForegroundColor(), "InternalFrame.inactiveTitleGradient", this.theme.getInactiveInternalFrameTitleGradientColor(), "InternalFrame.icon", this.theme.getInternalFrameIcon(), "InternalFrame.iconifyIcon", this.theme.getInternalFrameIconifyIcon(), "InternalFrame.minimizeIcon", this.theme.getInternalFrameMinimizeIcon(), "InternalFrame.maximizeIcon", this.theme.getInternalFrameMaximizeIcon(), "InternalFrame.closeIcon", this.theme.getInternalFrameCloseIcon(), "InternalFrame.border", this.theme.getInternalFrameBorder(), "InternalFrame.titleFont", this.theme.getInternalFrameTitleFont(), "MenuBar.border", this.theme.getMenuBarBorder(), "MenuItem.border", menuItemBorder, "Menu.border", menuItemBorder, "Spinner.border", this.theme.getTextFieldBorder(), "Spinner.background", new ColorUIResource(this.theme.getBackgroundColor()), "PopupMenu.border", this.theme.getPopupMenuBorder(), "TextField.border", this.theme.getTextFieldBorder(), "FormattedTextField.border", this.theme.getTextFieldBorder(), "Button.textShiftOffset", new Integer(2), "Button.select", this.theme.getControlLightShadowColor(), "Button.margin", this.theme.getButtonMargin(), "Button.disabledText", this.theme.getInactiveTextColor(), "ToggleButton.margin", this.theme.getButtonMargin(), "ToggleButton.select", this.theme.getControlLightShadowColor(), "ToggleButton.textShiftOffset", new Integer(2), "Tree.openIcon", this.theme.getTreeOpenIcon(), "Tree.closedIcon", this.theme.getTreeClosedIcon(), "Tree.leafIcon", this.theme.getTreeLeafIcon(), "Tree.collapsedIcon", new IconUIResource(new TreeIcon(1, 10, 10, true, this.theme.getTextColor(), this.theme.getTreeIconBackgroundColor())), "Tree.expandedIcon", new IconUIResource(new TreeIcon(2, 10, 10, true, this.theme.getTextColor(), this.theme.getTreeIconBackgroundColor())), "Tree.leftChildIndent", new Integer(5), "Tree.rightChildIndent", new Integer(11), "OptionPane.errorIcon", LookAndFeel.makeIcon(iconClass, "icons/Error.gif"), "OptionPane.informationIcon", LookAndFeel.makeIcon(iconClass, "icons/Inform.gif"), "OptionPane.warningIcon", LookAndFeel.makeIcon(iconClass, "icons/Warn.gif"), "OptionPane.questionIcon", LookAndFeel.makeIcon(iconClass, "icons/Question.gif"), "OptionPane.buttonFont", this.theme.getOptionPaneButtonFont()};
        table.putDefaults(defaults);
    }

    public static void install() {
        if (!ArrayUtil.contains(UIManager.getInstalledLookAndFeels(), LOOK_AND_FEEL_INFO)) {
            UIManager.installLookAndFeel(LOOK_AND_FEEL_INFO);
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private Border normalBorder;
        private Border focusBorder;

        MyListCellRenderer(Border normalBorder, Border focusBorder) {
            this.normalBorder = normalBorder;
            this.focusBorder = focusBorder;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setBorder(cellHasFocus ? this.focusBorder : this.normalBorder);
            return label;
        }

        public static class UIResource
        extends MyListCellRenderer
        implements javax.swing.plaf.UIResource {
            public UIResource(Border normalBorder, Border focusBorder) {
                super(normalBorder, focusBorder);
            }
        }
    }
}

