/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core.matcher;

import java.awt.Frame;
import java.util.regex.Pattern;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.matcher.NamedComponentMatcherTemplate;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class FrameMatcher
extends NamedComponentMatcherTemplate<Frame> {
    private Object title;

    public static FrameMatcher withName(@Nullable String name) {
        return new FrameMatcher(name, FrameMatcher.anyValue());
    }

    public static FrameMatcher withTitle(@Nonnull String title) {
        return new FrameMatcher(FrameMatcher.anyValue(), (Object)title);
    }

    @Nonnull
    public static FrameMatcher withTitle(@Nonnull Pattern pattern) {
        return new FrameMatcher(FrameMatcher.anyValue(), (Object)pattern);
    }

    @Nonnull
    public static FrameMatcher any() {
        return new FrameMatcher(FrameMatcher.anyValue(), FrameMatcher.anyValue());
    }

    private FrameMatcher(@Nullable Object name, @Nullable Object title) {
        super(Frame.class, name);
        this.title = title;
    }

    @Nonnull
    public FrameMatcher andTitle(@Nonnull String newTitle) {
        this.title = newTitle;
        return this;
    }

    @Nonnull
    public FrameMatcher andTitle(@Nonnull Pattern titlePattern) {
        this.title = titlePattern;
        return this;
    }

    @Nonnull
    public FrameMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull Frame frame) {
        return this.isNameMatching(frame.getName()) && this.arePropertyValuesMatching(this.title, frame.getTitle());
    }

    public String toString() {
        String format = "%s[name=%s, title=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.title), this.requireShowing());
    }
}

