/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.Histogram;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LogHistogram
extends Histogram {
    private double logFactor;
    private double logOffset;

    public LogHistogram(double min, double max) {
        this(min, max, 0.1);
    }

    public LogHistogram(double min, double max, double epsilonFactor) {
        super(min, max);
        this.logFactor = Math.log(2.0) / Math.log(1.0 + epsilonFactor);
        this.logOffset = LogHistogram.approxLog2(min) * this.logFactor;
        if (max <= 2.0 * min) {
            throw new IllegalArgumentException(String.format("Illegal/nonsensical min, max (%.2f, %.2g)", min, max));
        }
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("Min and max must be positive");
        }
        if (epsilonFactor < 1.0E-6 || epsilonFactor > 0.5) {
            throw new IllegalArgumentException(String.format("Unreasonable number of bins per decade %.2g. Expected value in range [1e-6,0.5]", epsilonFactor));
        }
        this.setupBins(min, max);
    }

    public static double approxLog2(double value) {
        long valueBits = Double.doubleToRawLongBits(value);
        long exponent = ((valueBits & 0x7FF0000000000000L) >>> 52) - 1024L;
        double m = Double.longBitsToDouble(valueBits & 0x800FFFFFFFFFFFFFL | 0x3FF0000000000000L);
        return m * (2.0 - 0.3333333333333333 * m) + (double)exponent - 0.6666666666666666;
    }

    public static double pow2(double x) {
        double exponent = Math.floor(x) - 1.0;
        double m = 3.0 - Math.sqrt(7.0 - 3.0 * (x -= exponent));
        return Math.pow(2.0, exponent + 1.0) * m;
    }

    @Override
    protected int bucketIndex(double x) {
        return (int)(LogHistogram.approxLog2(x) * this.logFactor - this.logOffset);
    }

    @Override
    double lowerBound(int k) {
        return LogHistogram.pow2(((double)k + this.logOffset) / this.logFactor);
    }

    @Override
    long[] getCompressedCounts() {
        return new long[0];
    }

    @Override
    void writeObject(ObjectOutputStream out) throws IOException {
    }

    @Override
    void readObject(ObjectInputStream in) throws IOException {
    }

    @Override
    void add(Iterable<Histogram> others) {
        for (Histogram other : others) {
            if (!this.getClass().equals(other.getClass())) {
                throw new IllegalArgumentException(String.format("Cannot add %s to LogHistogram", others.getClass()));
            }
            LogHistogram actual = (LogHistogram)other;
            if (actual.min != this.min || actual.max != this.max || actual.counts.length != this.counts.length) {
                throw new IllegalArgumentException("Can only merge histograms with identical bounds and precision");
            }
            for (int i = 0; i < this.counts.length; ++i) {
                int n = i;
                this.counts[n] = this.counts[n] + other.counts[i];
            }
        }
    }
}

