/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.gradle.api.internal.initialization.transform.InstrumentationArtifactMetadata;
import org.gradle.api.internal.initialization.transform.InstrumentationDependencyAnalysis;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationAnalysisSerializer;

public class CachedInstrumentationAnalysisSerializer
implements InstrumentationAnalysisSerializer {
    private final Cache<File, InstrumentationDependencyAnalysis> dependencyAnalysisCache;
    private final Cache<File, Map<String, Set<String>>> typeHierarchyCache;
    private final InstrumentationAnalysisSerializer delegate;

    public CachedInstrumentationAnalysisSerializer(InstrumentationAnalysisSerializer delegate) {
        this.delegate = delegate;
        this.dependencyAnalysisCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(20000L).build();
        this.typeHierarchyCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(20000L).build();
    }

    @Override
    public void writeDependencyAnalysis(File output, InstrumentationDependencyAnalysis dependencyAnalysis) {
        this.delegate.writeDependencyAnalysis(output, dependencyAnalysis);
        this.dependencyAnalysisCache.put((Object)output, (Object)dependencyAnalysis);
    }

    @Override
    public void writeTypeHierarchyAnalysis(File output, Map<String, Set<String>> types) {
        this.delegate.writeTypeHierarchyAnalysis(output, types);
        this.typeHierarchyCache.put((Object)output, types);
    }

    @Override
    public InstrumentationDependencyAnalysis readDependencyAnalysis(File output) {
        try {
            return (InstrumentationDependencyAnalysis)this.dependencyAnalysisCache.get((Object)output, () -> this.delegate.readDependencyAnalysis(output));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InstrumentationArtifactMetadata readMetadataOnly(File input) {
        try {
            return ((InstrumentationDependencyAnalysis)this.dependencyAnalysisCache.get((Object)input, () -> this.delegate.readDependencyAnalysis(input))).getMetadata();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Set<String>> readTypeHierarchyAnalysis(File input) {
        try {
            return (Map)this.typeHierarchyCache.get((Object)input, () -> this.delegate.readTypeHierarchyAnalysis(input));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

