/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.util;

import jakarta.mail.internet.SharedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class SharedFileInputStream
extends BufferedInputStream
implements SharedInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private SharedFileSource source;
    protected long bufpos;
    protected int bufsize;
    protected long datalen;
    protected RandomAccessFile in;
    protected long start;

    public SharedFileInputStream(String file) throws IOException {
        this(file, 2048);
    }

    public SharedFileInputStream(File file) throws IOException {
        this(file, 2048);
    }

    public SharedFileInputStream(String file, int bufferSize) throws IOException {
        super(null);
        this.init(new File(file), bufferSize);
    }

    public SharedFileInputStream(File file, int bufferSize) throws IOException {
        super(null);
        this.init(file, bufferSize);
    }

    private SharedFileInputStream(SharedFileSource source, long start, long len, int bufsize) {
        super(null);
        this.source = source;
        this.in = source.open();
        this.start = start;
        this.bufpos = start;
        this.datalen = len;
        this.bufsize = bufsize;
        this.buf = new byte[bufsize];
    }

    private void init(File file, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        this.source = new SharedFileSource(file);
        this.in = this.source.open();
        this.start = 0L;
        this.datalen = this.in.length();
        this.bufsize = bufferSize;
        this.bufpos = 0L;
        this.buf = new byte[bufferSize];
    }

    private boolean checkFill() throws IOException {
        if (this.pos < this.count) {
            return true;
        }
        if (this.markpos < 0) {
            this.pos = 0;
            this.bufpos += (long)this.count;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int validSize = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, validSize);
                this.pos = validSize;
                this.bufpos += (long)this.markpos;
                this.markpos = 0;
            } else if (this.buf.length < this.marklimit) {
                int newSize = Math.min(this.buf.length * 2, this.marklimit);
                byte[] newBuffer = new byte[newSize];
                System.arraycopy(this.buf, 0, newBuffer, 0, this.buf.length);
                this.buf = newBuffer;
            } else {
                this.markpos = -1;
                this.pos = 0;
                this.bufpos += (long)this.count;
            }
        }
        if (this.bufpos + (long)this.pos >= this.start + this.datalen) {
            this.count = this.pos;
            return false;
        }
        int fillLength = this.buf.length - this.pos;
        if (this.bufpos - this.start + (long)this.pos + (long)fillLength > this.datalen) {
            fillLength = (int)(this.datalen - (this.bufpos - this.start + (long)this.pos));
        }
        if ((fillLength = this.source.read(this.bufpos + (long)this.pos, this.buf, this.pos, fillLength)) <= 0) {
            this.count = this.pos;
            return false;
        }
        this.count = fillLength + this.pos;
        return true;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkOpen();
        long endMarker = this.start + this.datalen;
        return (int)(endMarker - (this.bufpos + (long)this.pos));
    }

    @Override
    public long getPosition() {
        this.checkOpenRuntime();
        return this.bufpos + (long)this.pos - this.start;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.checkOpenRuntime();
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkOpen();
        if (!this.checkFill()) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        this.checkOpen();
        if (length == 0) {
            return 0;
        }
        int returnCount = 0;
        while (length > 0) {
            if (!this.checkFill()) {
                if (returnCount > 0) {
                    return returnCount;
                }
                return -1;
            }
            int available = this.count - this.pos;
            int given = Math.min(available, length);
            System.arraycopy(this.buf, this.pos, buffer, offset, given);
            this.pos += given;
            length -= given;
            returnCount += given;
            offset += given;
        }
        return returnCount;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        this.checkOpen();
        if (n <= 0L) {
            return 0L;
        }
        if (!this.checkFill()) {
            return 0L;
        }
        long available = this.count - this.pos;
        long skipped = available < n ? available : n;
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark position");
        }
        this.pos = this.markpos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            this.source.close();
        }
        finally {
            this.in = null;
        }
    }

    @Override
    public InputStream newStream(long offset, long end) {
        this.checkOpenRuntime();
        if (offset < 0L) {
            throw new IllegalArgumentException("Start position is less than 0");
        }
        if (end == -1L) {
            end = this.datalen;
        }
        return new SharedFileInputStream(this.source, this.start + (long)((int)offset), (int)(end - offset), this.bufsize);
    }

    private void checkOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream has been closed");
        }
    }

    private void checkOpenRuntime() {
        if (this.in == null) {
            throw new RuntimeException("Stream has been closed");
        }
    }

    class SharedFileSource {
        public RandomAccessFile source;
        public int instanceCount = 0;

        public SharedFileSource(File file) throws IOException {
            this.source = new RandomAccessFile(file, "r");
        }

        public synchronized RandomAccessFile open() {
            ++this.instanceCount;
            return this.source;
        }

        public synchronized void close() throws IOException {
            if (this.instanceCount > 0) {
                --this.instanceCount;
                if (this.instanceCount == 0) {
                    this.source.close();
                }
            }
        }

        public synchronized int read(long position, byte[] buf, int offset, int length) throws IOException {
            this.source.seek(position);
            return this.source.read(buf, offset, length);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.instanceCount > 0) {
                this.source.close();
            }
        }
    }
}

