/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationProcessingData;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.impl.DefaultAssertionValidationContextBuilder;
import org.slf4j.Logger;

public class ValidateAssertions
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateAssertions.class);
    private boolean invalidFatal;
    @Nonnull
    private Function<Pair<ProfileRequestContext, Assertion>, SAML20AssertionValidator> assertionValidatorLookup;
    @Nonnull
    private Function<AssertionValidationInput, ValidationContext> validationContextBuilder;
    @Nonnull
    private Function<ProfileRequestContext, List<Assertion>> assertionResolver;
    @NonnullBeforeExec
    private List<Assertion> assertions;

    public ValidateAssertions() {
        this.setInvalidFatal(true);
        this.assertionValidatorLookup = FunctionSupport.constant(null);
        this.validationContextBuilder = new DefaultAssertionValidationContextBuilder();
        this.assertionResolver = new DefaultAssertionResolver();
    }

    @Nonnull
    public Function<ProfileRequestContext, List<Assertion>> getAssertionResolver() {
        return this.assertionResolver;
    }

    public void setAssertionResolver(@Nonnull Function<ProfileRequestContext, List<Assertion>> function) {
        this.checkSetterPreconditions();
        this.assertionResolver = (Function)Constraint.isNotNull(function, (String)"Assertion resolver cannot be null");
    }

    @Nonnull
    public Function<AssertionValidationInput, ValidationContext> getValidationContextBuilder() {
        return this.validationContextBuilder;
    }

    public void setValidationContextBuilder(@Nonnull Function<AssertionValidationInput, ValidationContext> builder) {
        this.checkSetterPreconditions();
        this.validationContextBuilder = (Function)Constraint.isNotNull(builder, (String)"ValidationContext builder cannot be null");
    }

    public boolean isInvalidFatal() {
        return this.invalidFatal;
    }

    public void setInvalidFatal(boolean flag) {
        this.checkSetterPreconditions();
        this.invalidFatal = flag;
    }

    @Nullable
    public SAML20AssertionValidator getAssertionValidator(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Assertion assertion) {
        return this.assertionValidatorLookup.apply((Pair<ProfileRequestContext, Assertion>)new Pair((Object)profileRequestContext, (Object)assertion));
    }

    public void setAssertionValidator(@Nullable SAML20AssertionValidator validator) {
        this.checkSetterPreconditions();
        this.assertionValidatorLookup = FunctionSupport.constant((Object)validator);
    }

    public void setAssertionValidatorLookup(@Nonnull Function<Pair<ProfileRequestContext, Assertion>, SAML20AssertionValidator> function) {
        this.checkSetterPreconditions();
        this.assertionValidatorLookup = (Function)Constraint.isNotNull(function, (String)"AssertionValidator lookup function cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.assertions = this.getAssertionResolver().apply(profileRequestContext);
        if (this.assertions == null || this.assertions.isEmpty()) {
            this.log.info("{} Profile context contained no Assertions to validate. Skipping further processing", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileContext) {
        boolean sawNonValid = false;
        for (Assertion assertion : this.assertions) {
            assert (assertion != null);
            SAML20AssertionValidator validator = this.getAssertionValidator(profileContext, assertion);
            if (validator == null) {
                this.log.warn("{} No SAML20AssertionValidator was available, terminating", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)"UnableToValidateAssertion");
                return;
            }
            try {
                ValidationContext validationContext = this.buildValidationContext(profileContext, assertion);
                ValidationResult validationResult = validator.validate(assertion, validationContext);
                if (validationResult != ValidationResult.VALID) {
                    sawNonValid = true;
                }
                this.processResult(validationContext, validationResult, assertion, profileContext);
            }
            catch (Throwable t) {
                this.log.warn("{} There was a problem determining Assertion validity", (Object)this.getLogPrefix(), (Object)t);
                ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)"UnableToValidateAssertion");
                return;
            }
        }
        if (sawNonValid && this.isInvalidFatal()) {
            ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)"AssertionInvalid");
        } else {
            ActionSupport.buildProceedEvent((ProfileRequestContext)profileContext);
        }
    }

    protected void processResult(@Nonnull ValidationContext validationContext, @Nonnull ValidationResult validationResult, @Nonnull Assertion assertion, @Nonnull ProfileRequestContext profileContext) {
        this.log.debug("{} Assertion validation result was: {}", (Object)this.getLogPrefix(), (Object)validationResult);
        if (validationResult != ValidationResult.VALID) {
            this.log.info("{} Assertion validation failure(s): {}", (Object)this.getLogPrefix(), (Object)validationContext.getValidationFailureMessages());
        }
        assertion.getObjectMetadata().put((Object)new ValidationProcessingData(validationContext, validationResult));
    }

    @Nonnull
    protected ValidationContext buildValidationContext(@Nonnull ProfileRequestContext profileContext, @Nonnull Assertion assertion) throws AssertionValidationException {
        HttpServletRequest servletRequest = this.getHttpServletRequest();
        assert (servletRequest != null);
        ValidationContext validationContext = this.getValidationContextBuilder().apply(new AssertionValidationInput(profileContext, servletRequest, assertion));
        if (validationContext == null) {
            this.log.warn("{} ValidationContext produced was null", (Object)this.getLogPrefix());
            throw new AssertionValidationException("Assertion ValidationContext was null");
        }
        return validationContext;
    }

    public class DefaultAssertionResolver
    implements Function<ProfileRequestContext, List<Assertion>> {
        @Override
        @Nullable
        @Unmodifiable
        @NotLive
        public List<Assertion> apply(@Nullable ProfileRequestContext profileContext) {
            SAMLObject message;
            SAMLObject sAMLObject = message = profileContext != null ? (SAMLObject)profileContext.ensureInboundMessageContext().getMessage() : null;
            if (message instanceof Response) {
                Response r = (Response)message;
                return r.getAssertions();
            }
            return null;
        }
    }

    public static class AssertionValidationInput {
        @Nonnull
        private ProfileRequestContext profileContext;
        @Nonnull
        private HttpServletRequest httpServletRequest;
        @Nonnull
        private Assertion assertion;

        public AssertionValidationInput(@Nonnull ProfileRequestContext context, @Nonnull HttpServletRequest request, @Nonnull Assertion samlAssertion) {
            this.profileContext = (ProfileRequestContext)Constraint.isNotNull((Object)context, (String)"ProfileRequestContext may not be null");
            this.httpServletRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest may not be null");
            this.assertion = (Assertion)Constraint.isNotNull((Object)samlAssertion, (String)"Assertion may not be null");
        }

        @Nonnull
        public ProfileRequestContext getProfileRequestContext() {
            return this.profileContext;
        }

        @Nonnull
        public HttpServletRequest getHttpServletRequest() {
            return this.httpServletRequest;
        }

        @Nonnull
        public Assertion getAssertion() {
            return this.assertion;
        }
    }
}

