/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.asn1;

import io.churchkey.asn1.Asn1Class;
import io.churchkey.asn1.Asn1Object;
import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.Oid;
import io.churchkey.asn1.Utils;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Objects;

public class DerWriter
extends FilterOutputStream {
    private final byte[] lenBytes = new byte[4];

    public DerWriter() {
        this(256);
    }

    public DerWriter(int initialSize) {
        this(new ByteArrayOutputStream(initialSize));
    }

    public DerWriter(OutputStream stream) {
        super(Objects.requireNonNull(stream, "No output stream"));
    }

    public static DerWriter write() {
        return new DerWriter();
    }

    public DerWriter integer(BigInteger value) {
        this.integer(Objects.requireNonNull(value, "No value").toByteArray());
        return this;
    }

    public DerWriter integer(int value) {
        return this.integer(BigInteger.valueOf(value));
    }

    public DerWriter sequence(DerWriter derWriter) {
        return this.sequence(derWriter.bytes());
    }

    public DerWriter sequence(byte[] bytes) {
        this.writeObject(Asn1Object.sequence(bytes));
        return this;
    }

    public DerWriter any(DerWriter derWriter) {
        return this.any(derWriter.bytes());
    }

    public DerWriter any(byte[] bytes) {
        this.writeObject(new Asn1Object(Asn1Class.UNIVERSAL, Asn1Type.ANY, true, bytes.length, bytes));
        return this;
    }

    public DerWriter bolean(DerWriter derWriter) {
        return this.bolean(derWriter.bytes());
    }

    public DerWriter bolean(byte[] bytes) {
        this.writeObject(new Asn1Object(Asn1Class.UNIVERSAL, Asn1Type.BOOLEAN, true, bytes.length, bytes));
        return this;
    }

    public void integer(byte ... bytes) {
        this.integer(bytes, 0, Utils.length(bytes));
    }

    public void integer(byte[] bytes, int off, int len) {
        try {
            while (len > 1 && bytes[off] == 0 && this.isPositive(bytes[off + 1])) {
                ++off;
                --len;
            }
            this.write(2);
            if (this.isPositive(bytes[off])) {
                this.writeLength(len);
            } else {
                this.writeLength(len + 1);
                this.write(0);
            }
            this.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isPositive(byte b) {
        return (b & 0x80) == 0;
    }

    public DerWriter octetString(DerWriter derWriter) {
        return this.octetString(derWriter.bytes());
    }

    public DerWriter octetString(byte[] bytes) {
        return this.writeObject(Asn1Object.octetString(bytes));
    }

    public DerWriter octetString(BigInteger integer) {
        return this.octetString(integer.toByteArray());
    }

    public DerWriter bitString(byte[] bytes) {
        return this.writeObject(Asn1Object.bitString(bytes));
    }

    public DerWriter objectIdentifier(Oid oid) {
        return this.writeObject(Asn1Object.objectIdentifier(oid));
    }

    public DerWriter nill() {
        return this.writeObject(Asn1Object.nill());
    }

    public DerWriter writeObject(Asn1Object obj) {
        Objects.requireNonNull(obj, "No ASN.1 object");
        byte tagValue = obj.getTag().toDer();
        return this.writeObject(tagValue, obj.getLength(), obj.getValue());
    }

    public DerWriter writeObject(byte tag, int len, byte ... data) {
        try {
            this.write(tag & 0xFF);
            this.writeLength(len);
            this.write(data, 0, len);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeLength(int len) throws IOException {
        int nonZeroPos;
        Utils.checkTrue(len >= 0, "Invalid length: %d", len);
        if (len <= 127) {
            this.write(len);
            return;
        }
        Utils.putUInt(len, this.lenBytes);
        for (nonZeroPos = 0; nonZeroPos < this.lenBytes.length && this.lenBytes[nonZeroPos] == 0; ++nonZeroPos) {
        }
        if (nonZeroPos >= this.lenBytes.length) {
            throw new StreamCorruptedException("All zeroes length representation for len=" + len);
        }
        int bytesLen = this.lenBytes.length - nonZeroPos;
        this.write(0x80 | bytesLen);
        this.write(this.lenBytes, nonZeroPos, bytesLen);
    }

    public byte[] bytes() {
        if (this.out instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
        throw new UncheckedIOException(new IOException("The underlying stream is not a byte[] stream"));
    }
}

