/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.io.IOException;
import java.net.MulticastSocket;
import java.net.StandardSocketOptions;
import org.apache.catalina.tribes.util.JreCompat;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class Jre14Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre14Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre14Compat.class);
    private static final boolean supported;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public void setSocketoptionIpMulticastLoop(MulticastSocket socket, boolean enabled) throws IOException {
        socket.setOption(StandardSocketOptions.IP_MULTICAST_LOOP, enabled);
    }

    static {
        Class<?> c1 = null;
        try {
            c1 = Class.forName("java.io.Serial");
        }
        catch (ClassNotFoundException cnfe) {
            log.debug((Object)sm.getString("jre14Compat.javaPre14"), (Throwable)cnfe);
        }
        supported = c1 != null;
    }
}

