/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.services;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.service.Service;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.tinkergraph.services.TinkerServiceRegistry;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.util.CollectionUtil;

public class TinkerTextSearchFactory<I, R>
extends TinkerServiceRegistry.TinkerServiceFactory<I, R>
implements Service<I, R> {
    public static final String NAME = "tinker.search";

    public TinkerTextSearchFactory(AbstractTinkerGraph graph) {
        super(graph, NAME);
    }

    public Service.Type getType() {
        return Service.Type.Start;
    }

    @Override
    public Map describeParams() {
        return Params.DESCRIBE;
    }

    public Set<Service.Type> getSupportedTypes() {
        return Collections.singleton(Service.Type.Start);
    }

    public Service<I, R> createService(boolean isStart, Map params) {
        if (!isStart) {
            throw new UnsupportedOperationException("This service cannot be used mid-traversal.");
        }
        return this;
    }

    public CloseableIterator<R> execute(Service.ServiceCallContext ctx, Map params) {
        String regex;
        if (params.containsKey("regex")) {
            regex = (String)params.get("regex");
        } else if (params.containsKey("search")) {
            regex = ".*(" + params.get("search") + ").*";
        } else {
            throw new IllegalStateException("Missing search/regex parameter");
        }
        Class type = Params.type((String)params.get("type"));
        return CloseableIterator.of(TinkerHelper.search(this.graph, regex, Optional.ofNullable(type)));
    }

    public void close() {
    }

    public static interface Params {
        public static final String SEARCH = "search";
        public static final String REGEX = "regex";
        public static final String TYPE = "type";
        public static final Map DESCRIBE = CollectionUtil.asMap((Object[])new Object[]{"search", "Specify a search term - will be converted to regex via .*(search).*", "regex", "Directly specify the regex", "type", "Specify the type of Element to search for, one of Vertex/Edge/VertexProperty (optional)"});

        public static Class type(String type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case "Vertex": {
                    return Vertex.class;
                }
                case "Edge": {
                    return Edge.class;
                }
                case "VertexProperty": {
                    return VertexProperty.class;
                }
            }
            throw new IllegalArgumentException("Type must be one of Vertex/Edge/VertexProperty: " + type);
        }
    }
}

