/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.cache;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Collections;
import com.okta.sdk.cache.CacheConfigurationBuilder;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.cache.CacheManagerBuilder;
import com.okta.sdk.impl.cache.CacheConfiguration;
import com.okta.sdk.impl.cache.DefaultCacheConfiguration;
import com.okta.sdk.impl.cache.DefaultCacheConfigurationBuilder;
import com.okta.sdk.impl.cache.DefaultCacheManager;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DefaultCacheManagerBuilder
implements CacheManagerBuilder {
    private Duration defaultTimeToLive;
    private Duration defaultTimeToIdle;
    private final Set<CacheConfiguration> configs = new LinkedHashSet<CacheConfiguration>();

    public CacheManagerBuilder withDefaultTimeToLive(long ttl, TimeUnit timeUnit) {
        this.defaultTimeToLive = DefaultCacheConfiguration.toDuration(ttl, timeUnit);
        return this;
    }

    public CacheManagerBuilder withDefaultTimeToIdle(long tti, TimeUnit timeUnit) {
        this.defaultTimeToIdle = DefaultCacheConfiguration.toDuration(tti, timeUnit);
        return this;
    }

    public CacheManagerBuilder withCache(CacheConfigurationBuilder builder) {
        Assert.isInstanceOf(DefaultCacheConfigurationBuilder.class, (Object)builder, (String)("This implementation only accepts " + DefaultCacheConfigurationBuilder.class.getName() + " instances."));
        DefaultCacheConfigurationBuilder b = (DefaultCacheConfigurationBuilder)builder;
        this.configs.add(b.build());
        return this;
    }

    public CacheManager build() {
        DefaultCacheManager manager = new DefaultCacheManager();
        if (this.defaultTimeToLive != null) {
            manager.setDefaultTimeToLive(this.defaultTimeToLive);
        }
        if (this.defaultTimeToIdle != null) {
            manager.setDefaultTimeToIdle(this.defaultTimeToIdle);
        }
        if (!Collections.isEmpty(this.configs)) {
            manager.setCacheConfigurations(this.configs);
        }
        return manager;
    }
}

