/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import java.io.IOException;
import java.security.SecureRandom;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.RetryableException;

public final class GoogleApiExecutor {
    private static final Log LOG = Log.getLog(GoogleApiExecutor.class);
    private static final SecureRandom RANDOM = new SecureRandom();

    public static <G extends AbstractGoogleJsonClientRequest<T>, T, R> R execute(G request, RequestResultHandler<G, T, R> handler) {
        return GoogleApiExecutor.execute((AbstractGoogleJsonClientRequest)Assertions.nullChecked(request, (String)"Google Json ClientRequest"), (RequestResultHandler)Assertions.nullChecked(handler, (String)"handler"), -1);
    }

    public static <G extends AbstractGoogleJsonClientRequest<T>, T, R> R execute(G request, RequestResultHandler<G, T, R> handler, int retry) {
        try {
            if (retry >= 0) {
                long sleep = (long)(1000.0 * Math.pow(2.0, retry) + (double)GoogleApiExecutor.nextLong(1000L));
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
            return handler.handleResult(request, request.execute());
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError details = e.getDetails();
            if (null != details && null != details.getErrors()) {
                GoogleJsonError.ErrorInfo errorInfo = (GoogleJsonError.ErrorInfo)details.getErrors().get(0);
                LOG.error("Unable to execute request {0} - {1} - {2}", new Object[]{e.getStatusCode(), e.getStatusMessage(), errorInfo.getReason()});
                switch (e.getStatusCode()) {
                    case 403: {
                        if (!"userRateLimitExceeded".equalsIgnoreCase(errorInfo.getReason()) && !"rateLimitExceeded".equalsIgnoreCase(errorInfo.getReason())) break;
                        return handler.handleError(e);
                    }
                    case 404: {
                        if (!"notFound".equalsIgnoreCase(errorInfo.getReason())) break;
                        return handler.handleNotFound((IOException)((Object)e));
                    }
                    case 409: {
                        if (!"duplicate".equalsIgnoreCase(errorInfo.getReason())) break;
                        handler.handleDuplicate((IOException)((Object)e));
                        break;
                    }
                    case 400: {
                        if (!"invalid".equalsIgnoreCase(errorInfo.getReason())) break;
                        break;
                    }
                    case 503: {
                        if (!"backendError".equalsIgnoreCase(errorInfo.getReason())) break;
                        throw RetryableException.wrap((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (e.getStatusCode() == 403) {
                LOG.error("Forbidden request", new Object[0]);
                handler.handleError(e);
            } else if (e.getStatusCode() == 404) {
                LOG.error("Endpoint not found for request", new Object[0]);
                return handler.handleNotFound((IOException)((Object)e));
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (IOException e) {
            if (retry < 5) {
                return GoogleApiExecutor.execute(request, handler, retry + 1);
            }
            return handler.handleError(e);
        }
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = RANDOM.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    private GoogleApiExecutor() {
    }
}

