/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;

public class NameGenerator {
    private static final String[] dictionaryFiles = new String[]{"animals.txt", "space.txt", "countries.txt", "sports.txt"};
    private static final Map<String, Integer> category = new HashMap<String, Integer>();
    private static int stripeFallbackCount = 0;
    private static int nodeFallbackCount = 0;
    private static final TrieNode root = new TrieNode();

    public static void assignFriendlyNames(Cluster cluster) {
        cluster.getStripes().forEach(stripe -> NameGenerator.assignFriendlyNames(cluster, stripe));
    }

    public static void assignFriendlyNames(Cluster cluster, Stripe stripe) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        NameGenerator.assignFriendlyStripeName(cluster, stripe, random);
        stripe.getNodes().forEach(node -> NameGenerator.assignFriendlyNodeName(cluster, stripe, node, random));
    }

    public static void assignFriendlyNodeName(Cluster cluster, Stripe stripe, Node node) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        NameGenerator.assignFriendlyNodeName(cluster, stripe, node, random);
    }

    public static void assignFriendlyStripeNames(Cluster cluster, Random random) {
        cluster.getStripes().forEach(stripe -> NameGenerator.assignFriendlyStripeName(cluster, stripe, random));
    }

    private static void assignFriendlyNodeName(Cluster cluster, Stripe stripe, Node node, Random random) {
        if (NameGenerator.nameCanBeSet(node)) {
            List<String> used = cluster.getNodes().stream().map(Node::getName).collect(Collectors.toList());
            List<String> dict = NameGenerator.readLines("dict/greek.txt");
            node.setName(NameGenerator.pickRandomNodeName(dict, used, random, stripe.getName() + "-"));
        }
    }

    private static void assignFriendlyStripeName(Cluster cluster, Stripe stripe, Random random) {
        if (NameGenerator.nameCanBeSet(stripe)) {
            String fileName;
            List<String> used = cluster.getStripes().stream().map(Stripe::getName).collect(Collectors.toList());
            String allreadyGeneratedStripeName = null;
            for (String stripeName : used) {
                if (!NameGenerator.isPresentInDictionary(stripeName)) continue;
                allreadyGeneratedStripeName = stripeName;
                break;
            }
            if (allreadyGeneratedStripeName == null) {
                int ind = random.nextInt(dictionaryFiles.length);
                fileName = dictionaryFiles[ind];
            } else {
                fileName = dictionaryFiles[category.get(allreadyGeneratedStripeName)];
            }
            List<String> dict = NameGenerator.readLines("dict/" + fileName);
            stripe.setName(NameGenerator.pickRandomStripeName(dict, used, random));
        }
    }

    private static void createDictionary() {
        int i = 0;
        while (i < dictionaryFiles.length) {
            String fileName = dictionaryFiles[i];
            int ind = i++;
            List<String> allLines = NameGenerator.readLines("dict/" + fileName);
            allLines.forEach(line -> {
                NameGenerator.insertInDictionary(line);
                category.put((String)line, ind);
            });
        }
    }

    private static void insertInDictionary(String s) {
        TrieNode tmp = root;
        for (int i = 0; i < s.length(); ++i) {
            TrieNode next = (TrieNode)tmp.children.get(Character.valueOf(s.charAt(i)));
            if (next == null) {
                next = new TrieNode();
                tmp.children.put(Character.valueOf(s.charAt(i)), next);
            }
            tmp = next;
        }
        tmp.isLeaf = true;
    }

    private static boolean isPresentInDictionary(String s) {
        if (s == null) {
            return false;
        }
        TrieNode tmp = root;
        for (int i = 0; i < s.length(); ++i) {
            TrieNode next = (TrieNode)tmp.children.get(Character.valueOf(s.charAt(i)));
            if (next == null) {
                return false;
            }
            tmp = next;
        }
        return tmp.isLeaf;
    }

    private static List<String> readLines(String resource) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Objects.requireNonNull(Setting.class.getClassLoader().getResourceAsStream(resource)), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return list;
    }

    private static String pickRandomNodeName(List<String> dict, List<String> used, Random random, String prefix) {
        dict = new ArrayList<String>(dict);
        String name = null;
        while (!dict.isEmpty() && used.contains(name = prefix + dict.remove(random.nextInt(dict.size())))) {
        }
        if (dict.isEmpty()) {
            String incrName;
            while (used.contains(incrName = prefix + ++nodeFallbackCount)) {
            }
            return incrName;
        }
        return name;
    }

    private static String pickRandomStripeName(List<String> dict, List<String> used, Random random) {
        dict = new ArrayList<String>(dict);
        dict.removeAll(used);
        if (dict.isEmpty()) {
            String name;
            while (used.contains(name = "stripe-" + ++stripeFallbackCount)) {
            }
            return name;
        }
        return dict.get(random.nextInt(dict.size()));
    }

    private static boolean nameCanBeSet(Node node) {
        String name = node.getName();
        return name == null || name.startsWith("node-") && UID.isUID(name.substring(5));
    }

    private static boolean nameCanBeSet(Stripe stripe) {
        String name = stripe.getName();
        return name == null || name.startsWith("stripe-") && UID.isUID(name.substring(7));
    }

    static {
        NameGenerator.createDictionary();
    }

    private static class TrieNode {
        private final Map<Character, TrieNode> children = new HashMap<Character, TrieNode>();
        private boolean isLeaf;

        private TrieNode() {
        }
    }
}

