/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.wizards;

import java.io.Serializable;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.wizard.FinishButton;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.Wizard;
import org.apache.wicket.extensions.wizard.WizardButton;
import org.apache.wicket.extensions.wizard.WizardButtonBar;
import org.apache.wicket.markup.ComponentTag;

public class AjaxWizardMgtButtonBar<T extends Serializable>
extends WizardButtonBar {
    private static final long serialVersionUID = 7453943437344127136L;
    private final AjaxWizard.Mode mode;
    protected boolean completed = false;

    public AjaxWizardMgtButtonBar(String id, AjaxWizard<T> wizard, AjaxWizard.Mode mode) {
        super(id, wizard);
        this.mode = mode;
        wizard.setOutputMarkupId(true);
    }

    public MarkupContainer add(Component ... childs) {
        for (Component component : childs) {
            if (!(component instanceof WizardButton)) continue;
            this.ajaxify((WizardButton)component);
        }
        return super.add(childs);
    }

    private void ajaxify(final WizardButton button) {
        button.add(new Behavior[]{new AjaxFormSubmitBehavior("click"){
            private static final long serialVersionUID = 18163421824742L;

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxWizardMgtButtonBar.this.updateAjaxAttributes(attributes);
            }

            public boolean getDefaultProcessing() {
                return button.getDefaultFormProcessing();
            }

            protected void onSubmit(AjaxRequestTarget target) {
                target.add(new Component[]{(Component)AjaxWizardMgtButtonBar.this.findParent(Wizard.class)});
                button.onSubmit();
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                button.onAfterSubmit();
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{(Component)AjaxWizardMgtButtonBar.this.findParent(Wizard.class)});
                button.onError();
                ((BaseWebPage)AjaxWizardMgtButtonBar.this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.put("type", (CharSequence)"button");
            }
        }});
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected FinishButton newFinishButton(String id, IWizard wizard) {
        return new FinishButton(id, wizard){
            private static final long serialVersionUID = 864248301720764819L;

            public boolean isEnabled() {
                switch (AjaxWizardMgtButtonBar.this.mode) {
                    case EDIT: 
                    case TEMPLATE: {
                        return true;
                    }
                    case READONLY: {
                        return false;
                    }
                }
                if (!AjaxWizardMgtButtonBar.this.completed) {
                    IWizardStep activeStep = this.getWizardModel().getActiveStep();
                    AjaxWizardMgtButtonBar.this.completed = activeStep != null && this.getWizardModel().isLastStep(activeStep) && super.isEnabled();
                }
                return AjaxWizardMgtButtonBar.this.completed;
            }

            public boolean isVisible() {
                switch (AjaxWizardMgtButtonBar.this.mode) {
                    case READONLY: {
                        return false;
                    }
                }
                return true;
            }
        };
    }
}

