/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.search;

import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import net.tirasa.connid.bundles.ldap.search.DefaultSearchStrategy;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import org.identityconnectors.common.logging.Log;

public class ADDefaultSearchStrategy
extends DefaultSearchStrategy {
    private static final Log LOG = Log.getLog(ADDefaultSearchStrategy.class);

    public ADDefaultSearchStrategy(boolean ignoreNonExistingBaseDNs) {
        super(ignoreNonExistingBaseDNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSearch(LdapContext initCtx, List<String> baseDNs, String query, SearchControls searchControls, LdapSearchResultsHandler handler) throws NamingException {
        if (LOG.isOk()) {
            LOG.ok("Searching in {0} with filter {1} and {2}", new Object[]{baseDNs, query, ADDefaultSearchStrategy.searchControlsToString((SearchControls)searchControls)});
        }
        try (LdapContext ctx = initCtx.newInstance(null);){
            Iterator<String> baseDNIter = baseDNs.iterator();
            boolean proceed = true;
            while (baseDNIter.hasNext() && proceed) {
                try {
                    String baseDN = baseDNIter.next();
                    byte[] cookie = null;
                    do {
                        ctx.setRequestControls(new Control[]{new PagedResultsControl(1000, cookie, true)});
                        try (NamingEnumeration<SearchResult> results = ctx.search(baseDN, query, searchControls);){
                            while (proceed && results.hasMoreElements()) {
                                proceed = handler.handle(baseDN, results.next());
                            }
                        }
                    } while ((cookie = this.getResponseCookie(ctx.getResponseControls())) != null);
                }
                catch (NameNotFoundException e) {
                    if (!this.ignoreNonExistingBaseDNs) {
                        throw e;
                    }
                    LOG.warn((Throwable)e, null, new Object[0]);
                }
                catch (InvalidNameException e) {
                    if (!this.ignoreNonExistingBaseDNs) {
                        throw e;
                    }
                    LOG.warn((Throwable)e, null, new Object[0]);
                }
            }
        }
    }

    private byte[] getResponseCookie(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl pagedControl = (PagedResultsResponseControl)control;
                return pagedControl.getCookie();
            }
        }
        return null;
    }
}

