/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class Attestation
implements Serializable {
    private static final long serialVersionUID = -2324150228329213721L;
    private final String metadataIdentifier;
    private final Map<String, String> vendorProperties;
    private final Map<String, String> deviceProperties;

    @JsonCreator
    private Attestation(@JsonProperty(value="metadataIdentifier") String metadataIdentifier, @JsonProperty(value="vendorProperties") Map<String, String> vendorProperties, @JsonProperty(value="deviceProperties") Map<String, String> deviceProperties) {
        this.metadataIdentifier = metadataIdentifier;
        this.vendorProperties = vendorProperties;
        this.deviceProperties = deviceProperties;
    }

    public Optional<String> getMetadataIdentifier() {
        return Optional.ofNullable(this.metadataIdentifier);
    }

    public Optional<Map<String, String>> getVendorProperties() {
        return Optional.ofNullable(this.vendorProperties);
    }

    public Optional<Map<String, String>> getDeviceProperties() {
        return Optional.ofNullable(this.deviceProperties);
    }

    public static Attestation empty() {
        return Attestation.builder().build();
    }

    @Generated
    public static AttestationBuilder builder() {
        return new AttestationBuilder();
    }

    @Generated
    public AttestationBuilder toBuilder() {
        return new AttestationBuilder().metadataIdentifier(this.metadataIdentifier).vendorProperties(this.vendorProperties).deviceProperties(this.deviceProperties);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attestation)) {
            return false;
        }
        Attestation other = (Attestation)o;
        String this$metadataIdentifier = this.metadataIdentifier;
        String other$metadataIdentifier = other.metadataIdentifier;
        if (this$metadataIdentifier == null ? other$metadataIdentifier != null : !this$metadataIdentifier.equals(other$metadataIdentifier)) {
            return false;
        }
        Map<String, String> this$vendorProperties = this.vendorProperties;
        Map<String, String> other$vendorProperties = other.vendorProperties;
        if (this$vendorProperties == null ? other$vendorProperties != null : !((Object)this$vendorProperties).equals(other$vendorProperties)) {
            return false;
        }
        Map<String, String> this$deviceProperties = this.deviceProperties;
        Map<String, String> other$deviceProperties = other.deviceProperties;
        return !(this$deviceProperties == null ? other$deviceProperties != null : !((Object)this$deviceProperties).equals(other$deviceProperties));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $metadataIdentifier = this.metadataIdentifier;
        result = result * 59 + ($metadataIdentifier == null ? 43 : $metadataIdentifier.hashCode());
        Map<String, String> $vendorProperties = this.vendorProperties;
        result = result * 59 + ($vendorProperties == null ? 43 : ((Object)$vendorProperties).hashCode());
        Map<String, String> $deviceProperties = this.deviceProperties;
        result = result * 59 + ($deviceProperties == null ? 43 : ((Object)$deviceProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Attestation(metadataIdentifier=" + this.metadataIdentifier + ", vendorProperties=" + this.vendorProperties + ", deviceProperties=" + this.deviceProperties + ")";
    }

    public static class AttestationBuilder {
        private String metadataIdentifier;
        private Map<String, String> vendorProperties = new HashMap<String, String>();
        private Map<String, String> deviceProperties = new HashMap<String, String>();

        @CanIgnoreReturnValue
        public AttestationBuilder metadataIdentifier(@NonNull Optional<String> metadataIdentifier) {
            if (metadataIdentifier == null) {
                throw new NullPointerException("metadataIdentifier is marked non-null but is null");
            }
            return this.metadataIdentifier((String)metadataIdentifier.orElse(null));
        }

        @CanIgnoreReturnValue
        public AttestationBuilder metadataIdentifier(String metadataIdentifier) {
            this.metadataIdentifier = metadataIdentifier;
            return this;
        }

        @CanIgnoreReturnValue
        public AttestationBuilder vendorProperties(@NonNull Optional<Map<String, String>> vendorProperties) {
            if (vendorProperties == null) {
                throw new NullPointerException("vendorProperties is marked non-null but is null");
            }
            return this.vendorProperties((Map<String, String>)vendorProperties.orElse(null));
        }

        @CanIgnoreReturnValue
        public AttestationBuilder vendorProperties(Map<String, String> vendorProperties) {
            this.vendorProperties = vendorProperties;
            return this;
        }

        @CanIgnoreReturnValue
        public AttestationBuilder deviceProperties(@NonNull Optional<Map<String, String>> deviceProperties) {
            if (deviceProperties == null) {
                throw new NullPointerException("deviceProperties is marked non-null but is null");
            }
            return this.deviceProperties((Map<String, String>)deviceProperties.orElse(null));
        }

        @CanIgnoreReturnValue
        public AttestationBuilder deviceProperties(Map<String, String> deviceProperties) {
            this.deviceProperties = deviceProperties;
            return this;
        }

        @Generated
        AttestationBuilder() {
        }

        @Generated
        public Attestation build() {
            return new Attestation(this.metadataIdentifier, this.vendorProperties, this.deviceProperties);
        }

        @Generated
        public String toString() {
            return "Attestation.AttestationBuilder(metadataIdentifier=" + this.metadataIdentifier + ", vendorProperties=" + this.vendorProperties + ", deviceProperties=" + this.deviceProperties + ")";
        }
    }
}

