/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.principal.X509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractX509PrincipalResolver
extends PersonDirectoryPrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractX509PrincipalResolver.class);
    private String alternatePrincipalAttribute;
    private X509AttributeExtractor x509AttributeExtractor;

    protected AbstractX509PrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    public boolean supports(Credential credential) {
        return credential instanceof X509CertificateCredential;
    }

    protected Map<String, List<Object>> retrievePersonAttributes(String principalId, Credential credential, Optional<Principal> currentPrincipal, Map<String, List<Object>> queryAttributes) {
        X509Certificate certificate = ((X509CertificateCredential)credential).getCertificate();
        Map<String, List<Object>> certificateAttributes = this.extractPersonAttributes(certificate);
        queryAttributes.putAll(certificateAttributes);
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>(super.retrievePersonAttributes(principalId, credential, currentPrincipal, queryAttributes));
        attributes.putAll(certificateAttributes);
        return attributes;
    }

    protected String extractPrincipalId(Credential credential, Optional<Principal> currentPrincipal) {
        return this.resolvePrincipalInternal(((X509CertificateCredential)credential).getCertificate());
    }

    protected abstract String resolvePrincipalInternal(X509Certificate var1);

    protected String getAlternatePrincipal(X509Certificate certificate) {
        if (StringUtils.isBlank((CharSequence)this.alternatePrincipalAttribute)) {
            return null;
        }
        Map<String, List<Object>> attributes = this.extractPersonAttributes(certificate);
        List<Object> attribute = attributes.get(this.alternatePrincipalAttribute);
        if (attribute == null) {
            LOGGER.debug("Attempt to get alternate principal with attribute [{}] was unsuccessful.", (Object)this.alternatePrincipalAttribute);
            return null;
        }
        Optional optionalAttribute = CollectionUtils.firstElement(attribute);
        return optionalAttribute.map(Object::toString).filter(StringUtils::isNotEmpty).map(alternatePrincipal -> {
            LOGGER.debug("Using alternate principal attribute [{}]", alternatePrincipal);
            return alternatePrincipal;
        }).orElseGet(() -> {
            LOGGER.trace("Returning null principal id...");
            return null;
        });
    }

    protected Map<String, List<Object>> extractPersonAttributes(X509Certificate certificate) {
        return this.x509AttributeExtractor.extractPersonAttributes(certificate);
    }

    @Generated
    public String toString() {
        return "AbstractX509PrincipalResolver(super=" + super.toString() + ", alternatePrincipalAttribute=" + this.alternatePrincipalAttribute + ", x509AttributeExtractor=" + this.x509AttributeExtractor + ")";
    }

    @Generated
    public void setAlternatePrincipalAttribute(String alternatePrincipalAttribute) {
        this.alternatePrincipalAttribute = alternatePrincipalAttribute;
    }

    @Generated
    public void setX509AttributeExtractor(X509AttributeExtractor x509AttributeExtractor) {
        this.x509AttributeExtractor = x509AttributeExtractor;
    }
}

