/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.LocaleUtils;
import com.googlecode.wicket.kendo.ui.form.datetime.local.DatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.local.TimePicker;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;

public class DateTimePicker
extends FormComponentPanel<LocalDateTime>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    protected DatePicker datePicker;
    protected TimePicker timePicker;
    private final Locale locale;
    private final String datePattern;
    private final String timePattern;
    private boolean timePickerEnabled = true;

    public DateTimePicker(String id) {
        this(id, null, null, "MM/dd/yyyy", "h:mm a");
    }

    public DateTimePicker(String id, Locale locale) {
        this(id, null, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm a"));
    }

    public DateTimePicker(String id, String datePattern, String timePattern) {
        this(id, null, null, datePattern, timePattern);
    }

    public DateTimePicker(String id, Locale locale, String datePattern, String timePattern) {
        this(id, null, locale, datePattern, timePattern);
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model) {
        this(id, model, null, "MM/dd/yyyy", "h:mm a");
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model, Locale locale) {
        this(id, model, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm a"));
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model, String datePattern, String timePattern) {
        this(id, model, null, datePattern, timePattern);
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model, Locale locale, String datePattern, String timePattern) {
        super(id, model);
        this.locale = locale;
        this.datePattern = datePattern;
        this.timePattern = timePattern;
        this.setType(LocalDateTime.class);
    }

    public String getInput() {
        String dateInput = this.datePicker.getInput();
        String timeInput = this.timePicker.getInput();
        return this.formatInput(dateInput, timeInput);
    }

    protected String formatInput(String dateInput, String timeInput) {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", dateInput, timeInput);
        }
        return dateInput;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (LocalDateTime.class.isAssignableFrom(type)) {
            return DateTimePicker.newConverter(this.getTextFormat());
        }
        return super.getConverter(type);
    }

    public final String getTextFormat() {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", this.getDatePattern(), this.getTimePattern());
        }
        return this.getDatePattern();
    }

    public String getModelObjectAsString() {
        LocalDateTime date = (LocalDateTime)this.getModelObject();
        if (date != null) {
            return date.format(DateTimeFormatter.ofPattern(this.getTextFormat(), this.getLocale()));
        }
        return "";
    }

    public final String getDatePattern() {
        return this.datePattern;
    }

    public final String getTimePattern() {
        return this.timePattern;
    }

    public final boolean isTimePickerEnabled() {
        return this.timePickerEnabled;
    }

    public final DateTimePicker setTimePickerEnabled(boolean enabled) {
        this.timePickerEnabled = enabled;
        return this;
    }

    public final void setTimePickerEnabled(IPartialPageRequestHandler handler, boolean enabled) {
        this.timePickerEnabled = enabled;
        handler.add(new Component[]{this.timePicker});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.datePicker = this.newDatePicker("datepicker", this.newDatePickerModel(), this.getLocale(), this.getDatePattern(), new Options());
        this.timePicker = this.newTimePicker("timepicker", this.newTimePickerModel(), this.getLocale(), this.getTimePattern(), new Options());
        this.add(new Component[]{this.datePicker});
        this.add(new Component[]{this.timePicker});
    }

    private static IConverter<LocalDateTime> newConverter(String pattern) {
        final String corrected = DatePicker.correctPattern(pattern);
        return new IConverter<LocalDateTime>(){
            private static final long serialVersionUID = 1L;

            public LocalDateTime convertToObject(String value, Locale locale) {
                try {
                    return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(corrected, locale));
                }
                catch (DateTimeParseException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
            }

            public String convertToString(LocalDateTime datetime, Locale locale) {
                return datetime != null ? datetime.format(DateTimeFormatter.ofPattern(corrected, locale)) : null;
            }
        };
    }

    private IModel<LocalDate> newDatePickerModel() {
        return new Model<LocalDate>(){
            private static final long serialVersionUID = 1L;

            public LocalDate getObject() {
                LocalDateTime datetime = (LocalDateTime)DateTimePicker.this.getModelObject();
                if (datetime != null) {
                    return datetime.toLocalDate();
                }
                return null;
            }
        };
    }

    private IModel<LocalTime> newTimePickerModel() {
        return new Model<LocalTime>(){
            private static final long serialVersionUID = 1L;

            public LocalTime getObject() {
                LocalDateTime datetime = (LocalDateTime)DateTimePicker.this.getModelObject();
                if (datetime != null) {
                    return datetime.toLocalTime();
                }
                return null;
            }
        };
    }

    protected DatePicker newDatePicker(String id, IModel<LocalDate> model, Locale locale, String datePattern, Options options) {
        return new DatePicker(id, model, locale, datePattern, options){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(DateTimePicker.this.isEnabled());
            }

            public void convertInput() {
            }
        };
    }

    protected TimePicker newTimePicker(String id, IModel<LocalTime> model, Locale locale, String timePattern, Options options) {
        return new TimePicker(id, model, locale, timePattern, options){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(DateTimePicker.this.isEnabled() && DateTimePicker.this.isTimePickerEnabled());
            }

            public void convertInput() {
            }
        };
    }
}

