/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractChangedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class ChangedStoredProcedureChangeGenerator
extends AbstractChangedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (StoredProcedure.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    @Override
    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences object, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        if (((ObjectDifferences)object).isDifferent("body")) {
            object = new CreateProcedureChange();
            ((CreateProcedureChange)object).setProcedureText(this.convertToReplace(((StoredDatabaseLogic)databaseObject).getBody(), database2));
            ((CreateProcedureChange)object).setProcedureName(databaseObject.getName());
            if (diffOutputControl.getIncludeCatalog()) {
                ((CreateProcedureChange)object).setCatalogName(databaseObject.getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                ((CreateProcedureChange)object).setSchemaName(databaseObject.getSchema().getName());
            }
            if (database instanceof MSSQLDatabase) {
                ((CreateProcedureChange)object).setReplaceIfExists(Boolean.TRUE);
            }
            return AbstractMissingStoredLogicChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{object});
        }
        return null;
    }
}

