/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.discovery.DiscoveryPathConstructor;

public class DiscoveryPathConstructorImpl
implements DiscoveryPathConstructor {
    private final String basePath;

    public DiscoveryPathConstructorImpl(String basePath) {
        Preconditions.checkArgument((basePath != null ? 1 : 0) != 0, (Object)"basePath cannot be null");
        PathUtils.validatePath((String)basePath);
        this.basePath = basePath;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getPathForInstances(String serviceName) {
        return ZKPaths.makePath((String)this.basePath, (String)serviceName);
    }
}

