/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.management;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementCommand;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGroupManagementAgent
implements GroupManagementAgent {
    private static final Log log = LogFactory.getLog(DefaultGroupManagementAgent.class);
    private final List<Member> members = new ArrayList<Member>();
    private ChannelSender sender;
    private MembershipManager membershipManager;
    private RpcChannel rpcChannel;
    private String description;

    public void setSender(ChannelSender sender) {
        this.sender = sender;
    }

    public void setMembershipManager(MembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void applicationMemberAdded(Member member) {
        if (!this.members.contains(member)) {
            Thread th = new Thread(new MemberAdder(member));
            th.setPriority(10);
            th.start();
        }
    }

    public void applicationMemberRemoved(Member member) {
        log.info((Object)("Application member " + member + " left cluster."));
        this.members.remove(member);
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public void send(GroupManagementCommand command) throws ClusteringFault {
        this.sender.sendToGroup((ClusteringCommand)command, this.membershipManager, 1032);
    }

    private class MemberAdder
    implements Runnable {
        private final Member member;

        private MemberAdder(Member member) {
            this.member = member;
        }

        public void run() {
            if (DefaultGroupManagementAgent.this.members.contains(this.member)) {
                return;
            }
            if (this.canConnect(this.member)) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!DefaultGroupManagementAgent.this.members.contains(this.member)) {
                    DefaultGroupManagementAgent.this.members.add(this.member);
                }
                log.info((Object)("Application member " + this.member + " joined application cluster"));
            } else {
                log.error((Object)("Could not add application member " + this.member));
            }
        }

        private boolean canConnect(Member member) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to connect to member " + member + "..."));
            }
            for (int retries = 30; retries > 0; --retries) {
                try {
                    InetAddress addr = InetAddress.getByName(member.getHostName());
                    int httpPort = member.getHttpPort();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("HTTP Port=" + httpPort));
                    }
                    if (httpPort != -1) {
                        InetSocketAddress httpSockaddr = new InetSocketAddress(addr, httpPort);
                        new Socket().connect(httpSockaddr, 10000);
                    }
                    int httpsPort = member.getHttpsPort();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("HTTPS Port=" + httpsPort));
                    }
                    if (httpsPort != -1) {
                        InetSocketAddress httpsSockaddr = new InetSocketAddress(addr, httpsPort);
                        new Socket().connect(httpsSockaddr, 10000);
                    }
                    return true;
                }
                catch (IOException e) {
                    String msg;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"", (Throwable)e);
                    }
                    if ((msg = e.getMessage()).indexOf("Connection refused") == -1 && msg.indexOf("connect timed out") == -1) {
                        log.error((Object)("Cannot connect to member " + member), (Throwable)e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            return false;
        }
    }
}

