/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;

public class ConnectionPool {
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    private static Map<String, List<NHttpClientConnection>> connMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NHttpClientConnection getConnection(String host, int port) {
        String key = host + ":" + Integer.toString(port);
        List<NHttpClientConnection> connections = connMap.get(key);
        if (connections == null || connections.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No connections available for reuse");
            }
            return null;
        }
        List<NHttpClientConnection> list = connections;
        synchronized (list) {
            while (!connections.isEmpty()) {
                NHttpClientConnection conn = connections.remove(0);
                if (conn.isOpen() && !conn.isStale()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A connection to host : " + host + " on port : " + port + " is available in the pool, and will be reused"));
                    }
                    conn.requestInput();
                    return conn;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("closing stale connection to : " + host + ":" + port));
                }
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(NHttpClientConnection conn) {
        HttpHost host = (HttpHost)conn.getContext().getAttribute("http.target_host");
        String key = host.getHostName() + ":" + Integer.toString(host.getPort());
        List<Object> connections = connMap.get(key);
        if (connections == null) {
            Map<String, List<NHttpClientConnection>> map = connMap;
            synchronized (map) {
                connections = connMap.get(key);
                if (connections == null) {
                    connections = Collections.synchronizedList(new LinkedList());
                    connMap.put(key, connections);
                }
            }
        }
        ConnectionPool.cleanConnectionReferences(conn);
        connections.add(conn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Released a connection to host: " + host.getHostName() + " on port : " + host.getPort() + " to the connection pool of current size : " + connections.size()));
        }
    }

    private static void cleanConnectionReferences(NHttpClientConnection conn) {
        HttpContext ctx = conn.getContext();
        Axis2HttpRequest axis2Req = (Axis2HttpRequest)ctx.getAttribute("synapse.axis2-http-request");
        axis2Req.clear();
        ctx.removeAttribute("synapse.axis2-http-request");
        ctx.removeAttribute("synapse.axis2_message_context");
        ctx.removeAttribute("synapse.request-source-buffer");
        ctx.removeAttribute("synapse.response-sink-buffer");
        ctx.removeAttribute("http.request");
        ctx.removeAttribute("http.response");
        conn.resetOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forget(NHttpClientConnection conn) {
        HttpHost host = (HttpHost)conn.getContext().getAttribute("http.target_host");
        String key = host.getHostName() + ":" + Integer.toString(host.getPort());
        List<NHttpClientConnection> connections = connMap.get(key);
        if (connections != null) {
            List<NHttpClientConnection> list = connections;
            synchronized (list) {
                connections.remove(conn);
            }
        }
    }
}

