/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public abstract class AbstractScriptEngine
implements ScriptEngine {
    protected ScriptContext context = new SimpleScriptContext();

    public AbstractScriptEngine() {
    }

    public AbstractScriptEngine(Bindings bindings) {
        this();
        if (bindings == null) {
            throw new NullPointerException("bindings is null");
        }
        this.context.setBindings(bindings, 100);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(reader, this.getScriptContext(bindings));
    }

    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    public Object eval(String script, Bindings bindings) throws ScriptException {
        return this.eval(script, this.getScriptContext(bindings));
    }

    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    public Bindings getBindings(int scope) {
        if (scope == 200 || scope == 100) {
            return this.context.getBindings(scope);
        }
        throw new IllegalArgumentException("invalid scope");
    }

    protected ScriptContext getScriptContext(Bindings bindings) {
        if (bindings == null) {
            throw new NullPointerException("ENGINE_SCOPE bindings cannot be null");
        }
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setBindings(bindings, 100);
        scriptContext.setBindings(this.getBindings(200), 200);
        scriptContext.setReader(this.context.getReader());
        scriptContext.setWriter(this.context.getWriter());
        scriptContext.setErrorWriter(this.context.getErrorWriter());
        return scriptContext;
    }

    public void put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("name is null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        this.getBindings(100).put(key, value);
    }

    public void setBindings(Bindings bindings, int scope) {
        if (scope != 200 && scope != 100) {
            throw new IllegalArgumentException("invalid scope");
        }
        this.context.setBindings(bindings, scope);
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public void setContext(ScriptContext context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        this.context = context;
    }
}

