/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.impl.httpclient3;

import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class HTTPProxcyConfigurator {
    private static Log log = LogFactory.getLog(HTTPProxcyConfigurator.class);

    public static void configure(MessageContext messageContext, HttpClient httpClient, HostConfiguration config) throws AxisFault {
        String port;
        String host;
        HttpTransportProperties.ProxyProperties proxyProperties;
        UsernamePasswordCredentials proxyCredentials = null;
        String proxyHost = null;
        Object nonProxyHosts = null;
        Integer proxyPort = -1;
        String proxyUser = null;
        String proxyPassword = null;
        Parameter proxySettingsFromAxisConfig = messageContext.getConfigurationContext().getAxisConfiguration().getParameter("Proxy");
        if (proxySettingsFromAxisConfig != null) {
            OMElement proxyConfiguration = HTTPProxcyConfigurator.getProxyConfigurationElement(proxySettingsFromAxisConfig);
            proxyHost = HTTPProxcyConfigurator.getProxyHost(proxyConfiguration);
            proxyPort = HTTPProxcyConfigurator.getProxyPort(proxyConfiguration);
            proxyUser = HTTPProxcyConfigurator.getProxyUser(proxyConfiguration);
            proxyPassword = HTTPProxcyConfigurator.getProxyPassword(proxyConfiguration);
            if (proxyUser != null) {
                int proxyUserDomainIndex;
                if (proxyPassword == null) {
                    proxyPassword = "";
                }
                if ((proxyUserDomainIndex = proxyUser.indexOf("\\")) > 0) {
                    String domain = proxyUser.substring(0, proxyUserDomainIndex);
                    if (proxyUser.length() > proxyUserDomainIndex + 1) {
                        String user = proxyUser.substring(proxyUserDomainIndex + 1);
                        proxyCredentials = new NTCredentials(user, proxyPassword, proxyHost, domain);
                    }
                }
                proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            }
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)messageContext.getProperty("PROXY")) != null) {
            String proxyHostProp = proxyProperties.getProxyHostName();
            if (proxyHostProp == null || proxyHostProp.length() <= 0) {
                throw new AxisFault("HTTP Proxy host is not available. Host is a MUST parameter");
            }
            proxyHost = proxyHostProp;
            proxyPort = proxyProperties.getProxyPort();
            String userName = proxyProperties.getUserName();
            String password = proxyProperties.getPassWord();
            String domain = proxyProperties.getDomain();
            if (userName != null && password != null && domain != null) {
                proxyCredentials = new NTCredentials(userName, password, proxyHost, domain);
            } else if (userName != null && domain == null) {
                proxyCredentials = new UsernamePasswordCredentials(userName, password);
            }
        }
        if ((host = System.getProperty("http.proxyHost")) != null) {
            proxyHost = host;
        }
        if ((port = System.getProperty("http.proxyPort")) != null) {
            proxyPort = Integer.parseInt(port);
        }
        if (proxyCredentials != null) {
            httpClient.getParams().setAuthenticationPreemptive(true);
            HttpState cachedHttpState = (HttpState)messageContext.getProperty("CACHED_HTTP_STATE");
            if (cachedHttpState != null) {
                httpClient.setState(cachedHttpState);
            }
            httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)proxyCredentials);
        }
        config.setProxy(proxyHost, proxyPort.intValue());
    }

    private static OMElement getProxyConfigurationElement(Parameter proxySettingsFromAxisConfig) throws AxisFault {
        OMElement proxyConfigurationElement = proxySettingsFromAxisConfig.getParameterElement().getFirstElement();
        if (proxyConfigurationElement == null) {
            log.error((Object)"HTTP Proxy is enabled, but proxy configuration element is missing in axis2.xml");
            throw new AxisFault("HTTP Proxy is enabled, but proxy configuration element is missing in axis2.xml");
        }
        return proxyConfigurationElement;
    }

    private static String getProxyHost(OMElement proxyConfiguration) throws AxisFault {
        OMElement proxyHostElement = proxyConfiguration.getFirstChildWithName(new QName("ProxyHost"));
        if (proxyHostElement == null) {
            log.error((Object)"HTTP Proxy is enabled, but proxy host element is missing in axis2.xml");
            throw new AxisFault("HTTP Proxy is enabled, but proxy host element is missing in axis2.xml");
        }
        String proxyHost = proxyHostElement.getText();
        if (proxyHost == null) {
            log.error((Object)"HTTP Proxy is enabled, but proxy host value is empty.");
            throw new AxisFault("HTTP Proxy is enabled, but proxy host value is empty.");
        }
        return proxyHost;
    }

    private static Integer getProxyPort(OMElement proxyConfiguration) throws AxisFault {
        OMElement proxyPortElement = proxyConfiguration.getFirstChildWithName(new QName("ProxyPort"));
        if (proxyPortElement == null) {
            log.error((Object)"HTTP Proxy is enabled, but proxy port element is missing in axis2.xml");
            throw new AxisFault("HTTP Proxy is enabled, but proxy port element is missing in axis2.xml");
        }
        String proxyPort = proxyPortElement.getText();
        if (proxyPort == null) {
            log.error((Object)"HTTP Proxy is enabled, but proxy port value is empty.");
            throw new AxisFault("HTTP Proxy is enabled, but proxy port value is empty.");
        }
        return Integer.parseInt(proxyPort);
    }

    private static String getProxyUser(OMElement proxyConfiguration) {
        OMElement proxyUserElement = proxyConfiguration.getFirstChildWithName(new QName("ProxyUser"));
        if (proxyUserElement == null) {
            return null;
        }
        String proxyUser = proxyUserElement.getText();
        if (proxyUser == null) {
            log.warn((Object)"Empty user name element in HTTP Proxy settings.");
            return null;
        }
        return proxyUser;
    }

    private static String getProxyPassword(OMElement proxyConfiguration) {
        OMElement proxyPasswordElement = proxyConfiguration.getFirstChildWithName(new QName("ProxyPassword"));
        if (proxyPasswordElement == null) {
            return null;
        }
        String proxyUser = proxyPasswordElement.getText();
        if (proxyUser == null) {
            log.warn((Object)"Empty user name element in HTTP Proxy settings.");
            return null;
        }
        return proxyUser;
    }

    public static boolean isProxyEnabled(MessageContext messageContext, URL targetURL) {
        boolean proxyEnabled = false;
        Parameter param = messageContext.getConfigurationContext().getAxisConfiguration().getParameter("Proxy");
        Object obj = messageContext.getProperty("PROXY");
        String sp = System.getProperty("http.proxyHost");
        if (param != null || obj != null || sp != null) {
            proxyEnabled = true;
        }
        boolean isNonProxyHost = HTTPProxcyConfigurator.validateNonProxyHosts(targetURL.getHost());
        return proxyEnabled && !isNonProxyHost;
    }

    private static boolean validateNonProxyHosts(String host) {
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        return HTTPProxcyConfigurator.isHostInNonProxyList(host, nonProxyHosts);
    }

    public static boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (!HTTPProxcyConfigurator.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }
}

