/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.addressing.factory.impl;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.factory.Axis2EndpointReferenceFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMapManager;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Axis2EndpointReferenceFactoryImpl
implements Axis2EndpointReferenceFactory {
    private static final Log log = LogFactory.getLog(Axis2EndpointReferenceFactoryImpl.class);

    public EndpointReference createEndpointReference(String address) {
        if (address == null) {
            throw new IllegalStateException("The endpoint address URI is null.");
        }
        return new EndpointReference(address);
    }

    public EndpointReference createEndpointReference(QName serviceName, QName endpoint) {
        EndpointKey key = new EndpointKey(serviceName, endpoint);
        EndpointContextMap map = EndpointContextMapManager.getEndpointContextMap();
        if (!map.containsKey(key)) {
            throw new IllegalStateException("Unable to locate a deployed service that maps to the requested endpoint, " + key);
        }
        AxisService axisService = (AxisService)map.get(key);
        String address = null;
        try {
            address = axisService.getEPRs()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createEndpointReference(address);
    }

    public EndpointReference createEndpointReference(String address, QName serviceName, QName portName, String wsdlDocumentLocation, String addressingNamespace) {
        EndpointReference axis2EPR;
        block20: {
            axis2EPR = null;
            if (address != null) {
                if (serviceName == null && portName != null) {
                    throw new IllegalStateException(Messages.getMessage((String)"axisEndpointReferenceFactoryErr", (String)portName.toString()));
                }
                axis2EPR = this.createEndpointReference(address);
            } else if (serviceName != null && portName != null) {
                axis2EPR = this.createEndpointReference(serviceName, portName);
            } else {
                throw new IllegalStateException(Messages.getMessage((String)"axisEndpointReferenceFactoryErr2"));
            }
            try {
                URL wsdlURL;
                EndpointReferenceUtils.addService(axis2EPR, serviceName, portName, addressingNamespace);
                if (wsdlDocumentLocation == null) break block20;
                try {
                    wsdlURL = new URL(wsdlDocumentLocation);
                }
                catch (MalformedURLException e) {
                    if (axis2EPR.getAddress().endsWith("/") && wsdlDocumentLocation.startsWith("/")) {
                        wsdlDocumentLocation = axis2EPR.getAddress() + wsdlDocumentLocation.substring(1);
                    }
                    if (axis2EPR.getAddress().endsWith("/")) {
                        String eprAddress = axis2EPR.getAddress();
                        wsdlDocumentLocation = eprAddress.substring(0, eprAddress.length() - 1) + wsdlDocumentLocation;
                    }
                    wsdlDocumentLocation = axis2EPR.getAddress() + wsdlDocumentLocation;
                }
                wsdlURL = new URL(wsdlDocumentLocation);
                WSDL4JWrapper wrapper = new WSDL4JWrapper(wsdlURL, true, 2);
                if (serviceName != null) {
                    QName serviceNameNoTrailingSlash = new QName("");
                    if (serviceName.getNamespaceURI().endsWith("/")) {
                        String ns = serviceName.getNamespaceURI();
                        serviceNameNoTrailingSlash = new QName(ns.substring(0, ns.length() - 1), serviceName.getLocalPart());
                    }
                    if (wrapper.getService(serviceName) == null && wrapper.getService(serviceNameNoTrailingSlash) == null) {
                        throw new IllegalStateException(Messages.getMessage((String)"MissingServiceName", (String)serviceName.toString(), (String)wsdlDocumentLocation));
                    }
                    if (portName != null) {
                        String[] ports = wrapper.getPorts(serviceName);
                        if (ports == null) {
                            ports = wrapper.getPorts(serviceNameNoTrailingSlash);
                        }
                        String portLocalName = portName.getLocalPart();
                        boolean found = false;
                        if (ports != null) {
                            for (String port : ports) {
                                if (!port.equals(portLocalName) && !(port + "TypeImplPort").equals(portLocalName)) continue;
                                log.debug((Object)("found port: " + port));
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            throw new IllegalStateException(Messages.getMessage((String)"MissingPortName", (String)portName.toString(), (String)wsdlDocumentLocation));
                        }
                        log.debug((Object)("Setting wsdlDocumentLocation to " + wsdlDocumentLocation + " for EndpointReference at port " + portName));
                        EndpointReferenceUtils.addLocation(axis2EPR, portName.getNamespaceURI(), wsdlDocumentLocation, addressingNamespace);
                    }
                }
            }
            catch (IllegalStateException ise) {
                throw ise;
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"endpointRefCreationError"), (Throwable)e);
            }
        }
        return axis2EPR;
    }
}

