/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.cli;

import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.ImmutableSortedSet;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.Configuration;
import com.google.gxp.compiler.Phase;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.ConfigurableAlertPolicy;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.CodeGeneratorFactory;
import com.google.gxp.compiler.codegen.DefaultCodeGeneratorFactory;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileSystem;
import com.google.gxp.compiler.fs.SourcePathFileSystem;
import com.google.gxp.compiler.i18ncheck.UnextractableContentAlert;
import com.google.gxp.compiler.parser.FileSystemEntityResolver;
import com.google.gxp.compiler.parser.SourceEntityResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

class GxpcFlags
implements Configuration {
    private final CommandLine commandLine;
    private final ImmutableSet<FileRef> sourceFiles;
    private final ImmutableSet<FileRef> schemaFiles;
    private final ImmutableSet<OutputLanguage> outputLanguages;
    private final DefaultCodeGeneratorFactory codeGeneratorFactory;
    private final ImmutableSet<FileRef> allowedOutputFileRefs;
    private final FileRef dependencyFile;
    private final FileRef propertiesFile;
    private final boolean isVerboseEnabled;
    private final boolean isDebugEnabled;
    private final AlertPolicy alertPolicy;
    private final ImmutableSortedSet<Phase> dotPhases;
    private final SourceEntityResolver sourceEntityResolver;

    GxpcFlags(FileSystem fs, FileRef defaultDir, String ... args) throws CmdLineException, IOException {
        this.commandLine = new CommandLine(args);
        ImmutableSet<FileRef> underlyingInputFiles = GxpcFlags.getFileRefs(fs, this.commandLine.trailingArgs);
        FileRef outputDir = this.commandLine.FLAG_dir == null ? defaultDir : fs.parseFilename(this.commandLine.FLAG_dir);
        List<FileRef> sourcePaths = this.commandLine.FLAG_source == null ? Collections.singletonList(defaultDir) : fs.parseFilenameList(this.commandLine.FLAG_source);
        SourcePathFileSystem sourcePathFs = new SourcePathFileSystem(fs, sourcePaths, underlyingInputFiles, outputDir);
        this.sourceFiles = ImmutableSet.copyOf(sourcePathFs.getSourceFileRefs());
        this.schemaFiles = GxpcFlags.getFileRefs(fs, this.commandLine.FLAG_schema);
        EnumSet<OutputLanguage> tmpOutputLanguages = EnumSet.noneOf(OutputLanguage.class);
        for (String outputLanguage : this.commandLine.FLAG_output_language) {
            tmpOutputLanguages.add(OutputLanguage.valueOf(outputLanguage.toUpperCase()));
        }
        this.outputLanguages = ImmutableSet.copyOf(tmpOutputLanguages);
        this.allowedOutputFileRefs = GxpcFlags.getFileRefs(sourcePathFs, this.commandLine.FLAG_output);
        this.alertPolicy = GxpcFlags.computeAlertPolicy(this.commandLine.FLAG_warn, this.commandLine.FLAG_error);
        this.dependencyFile = this.commandLine.FLAG_depend == null ? null : fs.parseFilename(this.commandLine.FLAG_depend);
        this.propertiesFile = this.commandLine.FLAG_output_properties && this.commandLine.FLAG_message_source != null ? outputDir.join("/" + this.commandLine.FLAG_message_source.replace(".", "/") + "_en.properties") : null;
        this.isVerboseEnabled = this.commandLine.FLAG_verbose;
        this.isDebugEnabled = this.commandLine.FLAG_g;
        this.dotPhases = GxpcFlags.computeDotPhases(this.commandLine.FLAG_dot);
        this.sourceEntityResolver = new FileSystemEntityResolver(sourcePathFs);
        this.codeGeneratorFactory = new DefaultCodeGeneratorFactory();
        this.codeGeneratorFactory.setRuntimeMessageSource(this.commandLine.FLAG_message_source);
        this.codeGeneratorFactory.setDynamicModeEnabled(this.commandLine.FLAG_dynamic);
        this.codeGeneratorFactory.setSourceFiles(this.getSourceFiles());
        this.codeGeneratorFactory.setSchemaFiles(this.getSchemaFiles());
        this.codeGeneratorFactory.setSourcePaths(sourcePaths);
        this.codeGeneratorFactory.setAlertPolicy(this.getAlertPolicy());
    }

    public boolean showHelp() {
        return this.commandLine.FLAG_help;
    }

    public void printHelp(Appendable out) throws IOException {
        out.append(this.commandLine.getUsage());
    }

    private static ImmutableSet<FileRef> getFileRefs(FileSystem fs, Iterable<String> filenames) {
        HashSet<FileRef> result = Sets.newHashSet();
        for (String filename : filenames) {
            result.add(fs.parseFilename(filename));
        }
        return ImmutableSet.copyOf(result);
    }

    private static final AlertPolicy computeAlertPolicy(List<String> warnFlags, List<String> errorFlags) {
        ConfigurableAlertPolicy result = new ConfigurableAlertPolicy();
        GxpcFlags.configureAlertPolicy(result, warnFlags, Alert.Severity.WARNING);
        GxpcFlags.configureAlertPolicy(result, errorFlags, Alert.Severity.ERROR);
        if (warnFlags.contains("error")) {
            result.setTreatWarningsAsErrors(true);
        }
        return result;
    }

    private static final void configureAlertPolicy(ConfigurableAlertPolicy alertPolicy, List<String> flags, Alert.Severity severity) {
        if (flags.contains("i18n")) {
            alertPolicy.setSeverity(UnextractableContentAlert.class, severity);
        }
    }

    private static ImmutableSortedSet<Phase> computeDotPhases(List<String> phaseNames) throws CmdLineException {
        TreeSet<Phase> result = Sets.newTreeSet();
        if (phaseNames.contains("*")) {
            result.addAll(Arrays.asList(Phase.values()));
        } else {
            for (String phaseName : phaseNames) {
                Phase phase;
                if ((phaseName = phaseName.trim()).length() <= 0) continue;
                phaseName = phaseName.toUpperCase().replace("-", "_");
                try {
                    phase = Phase.valueOf(phaseName);
                }
                catch (IllegalArgumentException iax) {
                    throw new CmdLineException("illegal phase name in --dot flag: " + phaseName);
                }
                result.add(phase);
            }
        }
        return ImmutableSortedSet.copyOfSorted(result);
    }

    @Override
    public Set<FileRef> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public Set<FileRef> getSchemaFiles() {
        return this.schemaFiles;
    }

    @Override
    public Set<OutputLanguage> getOutputLanguages() {
        return this.outputLanguages;
    }

    @Override
    public CodeGeneratorFactory getCodeGeneratorFactory() {
        return this.codeGeneratorFactory;
    }

    @Override
    public Set<FileRef> getAllowedOutputFileRefs() {
        return this.allowedOutputFileRefs;
    }

    @Override
    public FileRef getDependencyFile() {
        return this.dependencyFile;
    }

    @Override
    public FileRef getPropertiesFile() {
        return this.propertiesFile;
    }

    public boolean isVerboseEnabled() {
        return this.isVerboseEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public AlertPolicy getAlertPolicy() {
        return this.alertPolicy;
    }

    @Override
    public SortedSet<Phase> getDotPhases() {
        return this.dotPhases;
    }

    @Override
    public SourceEntityResolver getEntityResolver() {
        return this.sourceEntityResolver;
    }

    private static class CommandLine {
        private final CmdLineParser parser;
        @Argument
        public List<String> trailingArgs = Lists.newArrayList();
        @Option(name="--help", usage="display this help message")
        public boolean FLAG_help = false;
        @Option(name="--dir", usage="output directory")
        public String FLAG_dir = null;
        @Option(name="--schema", usage="a schema file used for compilation; can be repeated.")
        public List<String> FLAG_schema = Lists.newArrayList();
        @Option(name="--output_language", usage="output files for this language; can be repeated.")
        public List<String> FLAG_output_language = Lists.newArrayList();
        @Option(name="--output", usage="output this file; can be repeated. If not specified,\nall files will be output.")
        public List<String> FLAG_output = Lists.newArrayList();
        @Option(name="--warn", usage="Sets warning options. VAL can be one of:\ni18n (enable i18n warnings),\nerror (warnings are errors)")
        public List<String> FLAG_warn = Lists.newArrayList();
        @Option(name="--error", usage="Sets error options. VAL can be one of:\ni18n (enable i18n errors)")
        public List<String> FLAG_error = Lists.newArrayList();
        @Option(name="--source", usage="base directory for source")
        public String FLAG_source = null;
        @Option(name="--dynamic", usage="indicate dynamic mode")
        public boolean FLAG_dynamic = false;
        @Option(name="--output_properties", usage="indicates that gxpc should output a properties file")
        public boolean FLAG_output_properties = false;
        @Option(name="--message_source", usage="Message source for retrieving messages at runtime.\neg: com.google.foo.bar_messages")
        public String FLAG_message_source = null;
        @Option(name="--depend", usage="location of dependency info file; enables dependency\nchecking")
        public String FLAG_depend = null;
        @Option(name="--verbose", usage="enable verbose mode")
        public boolean FLAG_verbose = false;
        @Option(name="--g", usage="include debugging comments in HTML output")
        public boolean FLAG_g = false;
        @Option(name="--dot", usage="phase to produce graphviz \"dot\" output for;\ncan be repeated (useful for debugging compiler)")
        public List<String> FLAG_dot = Lists.newArrayList();

        private CommandLine(String[] args) throws CmdLineException {
            this.parser = new CmdLineParser(this);
            this.parser.parseArgument(args);
        }

        public String getUsage() {
            StringWriter sw = new StringWriter();
            sw.append("Usage: gxpc [flags...] [args...]\n");
            this.parser.printUsage(sw, null);
            return sw.toString();
        }
    }
}

