/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.analyser.AbstractApiRegionsAnalyserTask;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;

public class CheckApiRegionsOrder
extends AbstractApiRegionsAnalyserTask {
    public String getId() {
        return "api-regions-check-order";
    }

    public String getName() {
        return "Api Regions check order analyser task";
    }

    @Override
    public final void execute(ApiRegions apiRegions, AnalyserTaskContext ctx) throws Exception {
        String order = (String)ctx.getConfiguration().get("order");
        if (order == null) {
            this.reportError(ctx, "This analyser task must be configured: " + this.getId() + " for feature " + String.valueOf(ctx.getFeature().getId()));
            this.reportError(ctx, "Must specify configuration key 'order'.");
            return;
        }
        String[] sl = order.split("[,]");
        ArrayList<String> prescribedOrder = new ArrayList<String>();
        for (String s : sl) {
            if ((s = s.trim()).length() <= 0) continue;
            prescribedOrder.add(s);
        }
        if (prescribedOrder.size() == 0) {
            this.reportError(ctx, "No regions declared in the 'order' configuration");
            return;
        }
        int regionIdx = 0;
        for (ApiRegion region : apiRegions.listRegions()) {
            String name = region.getName();
            if (!prescribedOrder.contains(name)) {
                this.reportError(ctx, "Region found with undeclared name: " + name);
                return;
            }
            int prevIdx = regionIdx;
            if ((regionIdx = this.validateRegion(regionIdx, prescribedOrder, name)) >= 0) continue;
            this.reportError(ctx, "Region '" + name + "' appears in the wrong order. It appears after '" + (String)prescribedOrder.get(prevIdx) + "'. Order of regions should be " + String.valueOf(prescribedOrder));
            return;
        }
    }

    private int validateRegion(int regionIdx, List<String> order, String name) {
        for (int i = regionIdx; i < order.size(); ++i) {
            if (!name.equals(order.get(i))) continue;
            return i;
        }
        return -1;
    }

    private String getPrefix() {
        return this.getId() + ": ";
    }

    private void reportError(AnalyserTaskContext ctx, String err) {
        ctx.reportError(this.getPrefix() + err);
    }
}

