/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamespacedSets<T> {
    private final Map<String, Set<T>> sets = new HashMap<String, Set<T>>();
    private final AtomicInteger size = new AtomicInteger(0);
    private final Set<T> setView;
    private final Function<T, String> getNamespace;

    public NamespacedSets(Class<T> type, Function<T, String> getNamespace) {
        this.setView = new SetView(type);
        this.getNamespace = getNamespace;
    }

    public boolean add(T t) {
        int before = this.size.get();
        this.sets.compute(this.getNamespace.apply(t), (namespace, set) -> {
            if (set == null) {
                this.size.incrementAndGet();
                return Collections.singleton(t);
            }
            if (set.size() == 1) {
                set = new LinkedHashSet<Object>((Collection<Object>)set);
            }
            if (set.add(t)) {
                this.size.incrementAndGet();
            }
            return set;
        });
        return before < this.size.get();
    }

    public boolean remove(T t) {
        int before = this.size.get();
        this.sets.computeIfPresent(this.getNamespace.apply(t), (namespace, set) -> {
            if (set.size() <= 1) {
                if (set.contains(t)) {
                    this.size.decrementAndGet();
                    return null;
                }
            } else if (set.remove(t)) {
                this.size.decrementAndGet();
                if (set.size() == 1) {
                    return Collections.singleton(set.iterator().next());
                }
            }
            return set;
        });
        return before > this.size.get();
    }

    @NotNull
    public Set<T> asSet() {
        return this.setView;
    }

    @Nullable
    public Set<T> getNamespacedSet(String namespace) {
        return this.sets.get(namespace);
    }

    private class SetView
    extends AbstractSet<T> {
        private final Class<T> type;

        public SetView(Class<T> type) {
            this.type = type;
        }

        @Override
        public boolean contains(Object o) {
            if (this.type.isInstance(o)) {
                Object item = this.type.cast(o);
                return Optional.ofNullable(NamespacedSets.this.getNamespacedSet((String)NamespacedSets.this.getNamespace.apply(item))).map(Collection::stream).map(s -> s.anyMatch(i -> Objects.equals(i, item))).orElse(false);
            }
            return false;
        }

        @Override
        public boolean add(T item) {
            return NamespacedSets.this.add(item);
        }

        @Override
        public boolean remove(Object o) {
            if (this.type.isInstance(o)) {
                Object item = this.type.cast(o);
                return NamespacedSets.this.remove(item);
            }
            return false;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final List<Set<T>> listOfSets;
                private int currentListIndex;
                private T latestItem;
                private Iterator<T> currentIterator;
                {
                    this.listOfSets = NamespacedSets.this.sets.values().stream().filter(s -> !s.isEmpty()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
                    this.currentListIndex = -1;
                }

                @Override
                public boolean hasNext() {
                    this.latestItem = null;
                    while (!(this.currentIterator != null && this.currentIterator.hasNext() || ++this.currentListIndex >= this.listOfSets.size())) {
                        this.currentIterator = this.listOfSets.get(this.currentListIndex).iterator();
                    }
                    return this.currentIterator != null && this.currentIterator.hasNext();
                }

                @Override
                public T next() {
                    if (this.hasNext()) {
                        this.latestItem = this.currentIterator.next();
                        return this.latestItem;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (this.latestItem != null) {
                        Set currentSet = this.listOfSets.get(this.currentListIndex);
                        if (currentSet.contains(this.latestItem) && currentSet.size() > 1) {
                            NamespacedSets.this.sets.put((String)NamespacedSets.this.getNamespace.apply(this.latestItem), new LinkedHashSet(currentSet));
                            this.currentIterator.remove();
                        }
                    } else {
                        throw new IllegalStateException();
                    }
                    NamespacedSets.this.remove(this.latestItem);
                    this.latestItem = null;
                }
            };
        }

        @Override
        public int size() {
            return NamespacedSets.this.size.get();
        }
    }
}

