/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import com.tomgibara.crinch.hashing.PerfectStringHash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.rrd4j.core.Util;
import org.rrd4j.data.DataProcessor;

class RpnCalculator {
    private static final Token_Symbol[] symbols;
    private static final PerfectStringHash perfect;
    private final String rpnExpression;
    private final String sourceName;
    private final DataProcessor dataProcessor;
    private final Token[] tokens;
    private final RpnStack stack = new RpnStack();
    private final double[] calculatedValues;
    private final long[] timestamps;
    private final double timeStep;
    private final List<String> sourcesNames;

    RpnCalculator(String rpnExpression, String sourceName, DataProcessor dataProcessor) {
        this.rpnExpression = rpnExpression;
        this.sourceName = sourceName;
        this.dataProcessor = dataProcessor;
        this.timestamps = dataProcessor.getTimestamps();
        this.timeStep = this.timestamps[1] - this.timestamps[0];
        this.calculatedValues = new double[this.timestamps.length];
        this.sourcesNames = Arrays.asList(dataProcessor.getSourceNames());
        String[] tokensString = rpnExpression.split(" *, *");
        this.tokens = new Token[tokensString.length];
        for (int i = 0; i < tokensString.length; ++i) {
            this.tokens[i] = this.createToken(tokensString[i].trim());
        }
    }

    private Token createToken(String parsedText) {
        Token token;
        int hash = perfect.hashAsInt(parsedText);
        if (hash >= 0) {
            token = new Token(symbols[hash]);
        } else if (parsedText.equals("PREV")) {
            token = new Token(Token_Symbol.TKN_PREV, this.sourceName, this.calculatedValues);
        } else if (parsedText.startsWith("PREV(") && parsedText.endsWith(")")) {
            String variable = parsedText.substring(5, parsedText.length() - 1);
            token = new Token(Token_Symbol.TKN_PREV, variable, this.dataProcessor.getValues(variable));
        } else if (Util.isDouble(parsedText)) {
            token = new Token(Token_Symbol.TKN_NUM, Util.parseDouble(parsedText));
        } else if (this.sourcesNames.contains(parsedText)) {
            token = new Token(Token_Symbol.TKN_VAR, parsedText, this.dataProcessor.getValues(parsedText));
        } else {
            throw new IllegalArgumentException("Unexpected RPN token encountered: " + parsedText);
        }
        return token;
    }

    double[] calculateValues() {
        State s = new State();
        for (int slot = 0; slot < this.timestamps.length; ++slot) {
            this.resetStack();
            s.rpi = 0;
            s.token_rpi = -1;
            Token[] tokenArray = this.tokens;
            int n = tokenArray.length;
            for (int i = 0; i < n; ++i) {
                Token token;
                s.token = token = tokenArray[i];
                s.slot = slot;
                token.id.do_method(this, s);
                s.rpi++;
            }
            this.calculatedValues[slot] = this.pop();
            if (slot != 0 || this.isStackEmpty()) continue;
            throw new IllegalArgumentException("Stack not empty at the end of calculation. Probably bad RPN expression [" + this.rpnExpression + "]");
        }
        return this.calculatedValues;
    }

    private double getCalendarField(double timestamp, int field) {
        Calendar calendar = Util.getCalendar((long)timestamp);
        return calendar.get(field);
    }

    private void push(double x) {
        this.stack.push(x);
    }

    private double pop() {
        return this.stack.pop();
    }

    private double peek() {
        return this.stack.peek();
    }

    private void resetStack() {
        this.stack.reset();
    }

    private boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    static {
        ArrayList<String> tokenStrings = new ArrayList<String>(Token_Symbol.values().length);
        for (Token_Symbol s : Token_Symbol.values()) {
            if (s.token_string.isEmpty()) continue;
            tokenStrings.add(s.token_string);
        }
        String[] array = tokenStrings.toArray(new String[tokenStrings.size()]);
        perfect = new PerfectStringHash(array);
        symbols = new Token_Symbol[tokenStrings.size()];
        for (Token_Symbol s : Token_Symbol.values()) {
            int hash = perfect.hashAsInt(s.token_string);
            if (hash < 0) continue;
            RpnCalculator.symbols[hash] = s;
        }
    }

    private static final class Token {
        final Token_Symbol id;
        final double number;
        final String variable;
        final double[] values;

        Token(Token_Symbol id) {
            this.id = id;
            this.values = null;
            this.variable = "";
            this.number = Double.NaN;
        }

        Token(Token_Symbol id, String variable, double[] values) {
            this.id = id;
            this.variable = variable;
            this.values = values;
            this.number = Double.NaN;
        }

        Token(Token_Symbol id, double number) {
            this.id = id;
            this.values = null;
            this.variable = "";
            this.number = number;
        }
    }

    private static final class RpnStack {
        private static final int MAX_STACK_SIZE = 1000;
        private double[] stack = new double[1000];
        private int pos = 0;

        private RpnStack() {
        }

        void push(double x) {
            if (this.pos >= 1000) {
                throw new IllegalArgumentException("PUSH failed, RPN stack full [1000]");
            }
            this.stack[this.pos++] = x;
        }

        double pop() {
            if (this.pos <= 0) {
                throw new IllegalArgumentException("POP failed, RPN stack is empty");
            }
            return this.stack[--this.pos];
        }

        double peek() {
            if (this.pos <= 0) {
                throw new IllegalArgumentException("PEEK failed, RPN stack is empty");
            }
            return this.stack[this.pos - 1];
        }

        void reset() {
            this.pos = 0;
        }

        boolean isEmpty() {
            return this.pos <= 0;
        }
    }

    private static enum Token_Symbol {
        TKN_VAR(""){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(s.token.values[s.slot]);
                s.token_rpi = s.rpi;
            }
        }
        ,
        TKN_NUM(""){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(s.token.number);
            }
        }
        ,
        TKN_PLUS("+"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.pop() + c.pop());
            }
        }
        ,
        TKN_ADDNAN("ADDNAN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x1 = c.pop();
                double x2 = c.pop();
                c.push(Double.isNaN(x1) ? x2 : (Double.isNaN(x2) ? x1 : x1 + x2));
            }
        }
        ,
        TKN_MINUS("-"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 - x2);
            }
        }
        ,
        TKN_MULT("*"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.pop() * c.pop());
            }
        }
        ,
        TKN_DIV("/"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 / x2);
            }
        }
        ,
        TKN_MOD("%"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 % x2);
            }
        }
        ,
        TKN_SIN("SIN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.sin(c.pop()));
            }
        }
        ,
        TKN_COS("COS"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.cos(c.pop()));
            }
        }
        ,
        TKN_LOG("LOG"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.log(c.pop()));
            }
        }
        ,
        TKN_EXP("EXP"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.exp(c.pop()));
            }
        }
        ,
        TKN_SQRT("SQRT"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.sqrt(c.pop()));
            }
        }
        ,
        TKN_ATAN("ATAN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.atan(c.pop()));
            }
        }
        ,
        TKN_ATAN2("ATAN2"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(Math.atan2(x1, x2));
            }
        }
        ,
        TKN_FLOOR("FLOOR"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.floor(c.pop()));
            }
        }
        ,
        TKN_CEIL("CEIL"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.ceil(c.pop()));
            }
        }
        ,
        TKN_DEG2RAD("DEG2RAD"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.toRadians(c.pop()));
            }
        }
        ,
        TKN_RAD2DEG("RAD2DEG"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.toDegrees(c.pop()));
            }
        }
        ,
        TKN_ROUND("ROUND"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.round(c.pop()));
            }
        }
        ,
        TKN_POW("POW"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(Math.pow(x1, x2));
            }
        }
        ,
        TKN_ABS("ABS"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.abs(c.pop()));
            }
        }
        ,
        TKN_RANDOM("RANDOM"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.random());
            }
        }
        ,
        TKN_RND("RND"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.floor(c.pop() * Math.random()));
            }
        }
        ,
        TKN_UN("UN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Double.isNaN(c.pop()) ? 1.0 : 0.0);
            }
        }
        ,
        TKN_ISINF("ISINF"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Double.isInfinite(c.pop()) ? 1.0 : 0.0);
            }
        }
        ,
        TKN_LT("LT"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 < x2 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_LE("LE"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 <= x2 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_GT("GT"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 > x2 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_GE("GE"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 >= x2 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_EQ("EQ"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 == x2 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_NE("NE"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 != x2 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_IF("IF"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x3 = c.pop();
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 != 0.0 ? x2 : x3);
            }
        }
        ,
        TKN_MIN("MIN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.min(c.pop(), c.pop()));
            }
        }
        ,
        TKN_MAX("MAX"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.max(c.pop(), c.pop()));
            }
        }
        ,
        TKN_MINNAN("MINNAN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x1 = c.pop();
                double x2 = c.pop();
                c.push(Double.isNaN(x1) ? x2 : (Double.isNaN(x2) ? x1 : Math.min(x1, x2)));
            }
        }
        ,
        TKN_MAXNAN("MAXNAN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x1 = c.pop();
                double x2 = c.pop();
                c.push(Double.isNaN(x1) ? x2 : (Double.isNaN(x2) ? x1 : Math.max(x1, x2)));
            }
        }
        ,
        TKN_LIMIT("LIMIT"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x3 = c.pop();
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 < x2 || x1 > x3 ? Double.NaN : x1);
            }
        }
        ,
        TKN_DUP("DUP"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.peek());
            }
        }
        ,
        TKN_EXC("EXC"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x2);
                c.push(x1);
            }
        }
        ,
        TKN_POP("POP"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.pop();
            }
        }
        ,
        TKN_UNKN("UNKN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Double.NaN);
            }
        }
        ,
        TKN_PI("PI"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.PI);
            }
        }
        ,
        TKN_E("E"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Math.E);
            }
        }
        ,
        TKN_INF("INF"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Double.POSITIVE_INFINITY);
            }
        }
        ,
        TKN_NEGINF("NEGINF"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Double.NEGATIVE_INFINITY);
            }
        }
        ,
        TKN_AND("AND"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 != 0.0 && x2 != 0.0 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_OR("OR"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 != 0.0 || x2 != 0.0 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_XOR("XOR"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x2 = c.pop();
                double x1 = c.pop();
                c.push(x1 != 0.0 && x2 == 0.0 || x1 == 0.0 && x2 != 0.0 ? 1.0 : 0.0);
            }
        }
        ,
        TKN_PREV("PREV"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(s.slot == 0 ? Double.NaN : s.token.values[s.slot - 1]);
            }
        }
        ,
        TKN_STEP("STEP"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.timeStep);
            }
        }
        ,
        TKN_NOW("NOW"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(Util.getTime());
            }
        }
        ,
        TKN_TIME("TIME"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.timestamps[s.slot]);
            }
        }
        ,
        TKN_LTIME("LTIME"){

            @Override
            void do_method(RpnCalculator c, State s) {
                TimeZone tz = s.getTimeZone();
                c.push((double)c.timestamps[s.slot] + (double)tz.getOffset(c.timestamps[s.slot]) / 1000.0);
            }
        }
        ,
        TKN_YEAR("YEAR"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.getCalendarField(c.pop(), 1));
            }
        }
        ,
        TKN_MONTH("MONTH"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.getCalendarField(c.pop(), 2) + 1.0);
            }
        }
        ,
        TKN_DATE("DATE"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.getCalendarField(c.pop(), 5));
            }
        }
        ,
        TKN_HOUR("HOUR"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.getCalendarField(c.pop(), 11));
            }
        }
        ,
        TKN_MINUTE("MINUTE"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.getCalendarField(c.pop(), 12));
            }
        }
        ,
        TKN_SECOND("SECOND"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.getCalendarField(c.pop(), 13));
            }
        }
        ,
        TKN_WEEK("WEEK"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push(c.getCalendarField(c.pop(), 3));
            }
        }
        ,
        TKN_SIGN("SIGN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double x1 = c.pop();
                c.push(Double.isNaN(x1) ? Double.NaN : (x1 > 0.0 ? 1.0 : (x1 < 0.0 ? -1.0 : 0.0)));
            }
        }
        ,
        TKN_SORT("SORT"){

            @Override
            void do_method(RpnCalculator c, State s) {
                int i;
                int n = (int)c.pop();
                double[] array = new double[n];
                for (i = 0; i < n; ++i) {
                    array[i] = c.pop();
                }
                Arrays.sort(array);
                for (i = 0; i < n; ++i) {
                    c.push(array[i]);
                }
            }
        }
        ,
        TKN_REV("REV"){

            @Override
            void do_method(RpnCalculator c, State s) {
                int i;
                int n = (int)c.pop();
                double[] array = new double[n];
                for (i = 0; i < n; ++i) {
                    array[i] = c.pop();
                }
                for (i = 0; i < n; ++i) {
                    c.push(array[i]);
                }
            }
        }
        ,
        TKN_AVG("AVG"){

            @Override
            void do_method(RpnCalculator c, State s) {
                int count = 0;
                double sum = 0.0;
                for (int n = (int)c.pop(); n > 0; --n) {
                    double x1 = c.pop();
                    if (Double.isNaN(x1)) continue;
                    sum += x1;
                    ++count;
                }
                if (count > 0) {
                    c.push(sum / (double)count);
                } else {
                    c.push(Double.NaN);
                }
            }
        }
        ,
        TKN_COUNT("COUNT"){

            @Override
            void do_method(RpnCalculator c, State s) {
                c.push((double)s.slot + 1.0);
            }
        }
        ,
        TKN_TREND("TREND"){

            @Override
            void do_method(RpnCalculator c, State s) {
                int dur = (int)c.pop();
                c.pop();
                if ((double)(s.slot + 1) < Math.ceil((double)dur / c.timeStep)) {
                    c.push(Double.NaN);
                } else {
                    double[] vals = c.dataProcessor.getValues(((RpnCalculator)c).tokens[((State)s).token_rpi].variable);
                    boolean ignorenan = s.token.id == TKN_TRENDNAN;
                    double accum = 0.0;
                    int count = 0;
                    int start = (int)Math.ceil((double)dur / c.timeStep);
                    int row = 2;
                    while (s.slot + row > vals.length) {
                        --row;
                    }
                    while (start > 0) {
                        double val = vals[s.slot + row - start];
                        if (ignorenan || !Double.isNaN(val)) {
                            accum = Util.sum(accum, val);
                            ++count;
                        }
                        --start;
                    }
                    c.push(count == 0 ? Double.NaN : accum / (double)count);
                }
            }
        }
        ,
        TKN_TRENDNAN("TRENDNAN"){

            @Override
            void do_method(RpnCalculator c, State s) {
                TKN_TREND.do_method(c, s);
            }
        }
        ,
        TKN_PREDICT("PREDICT"){

            @Override
            void do_method(RpnCalculator c, State s) {
                double[] multipliers;
                c.pop();
                int locstepsize = (int)c.pop();
                int num_shifts = (int)c.pop();
                if (num_shifts < 0) {
                    multipliers = new double[]{c.pop()};
                } else {
                    multipliers = new double[num_shifts];
                    for (int i = 0; i < num_shifts; ++i) {
                        multipliers[i] = c.pop();
                    }
                }
                double val = Double.NaN;
                double[] vals = c.dataProcessor.getValues(((RpnCalculator)c).tokens[((State)s).rpi - 1].variable);
                int locstep = (int)Math.ceil((float)locstepsize / (float)c.timeStep);
                double sum = 0.0;
                double sum2 = 0.0;
                int count = 0;
                int doshifts = Math.abs(num_shifts);
                for (int loop = 0; loop < doshifts; ++loop) {
                    int shiftstep = num_shifts < 0 ? loop * (int)multipliers[0] : (int)multipliers[loop];
                    if (shiftstep < 0) {
                        throw new RuntimeException("negative shift step not allowed: " + shiftstep);
                    }
                    shiftstep = (int)Math.ceil((float)shiftstep / (float)c.timeStep);
                    for (int i = 0; i <= locstep; ++i) {
                        int offset = shiftstep + i;
                        if (offset < 0 || offset >= s.slot || Double.isNaN(val = vals[s.slot - offset])) continue;
                        sum = Util.sum(sum, val);
                        sum2 = Util.sum(sum2, val * val);
                        ++count;
                    }
                }
                val = Double.NaN;
                if (s.token.id == TKN_PREDICT) {
                    if (count > 0) {
                        val = sum / (double)count;
                    }
                } else if (count > 1) {
                    val = (double)count * sum2 - sum * sum;
                    val = val < 0.0 ? Double.NaN : Math.sqrt(val / ((double)count * ((double)count - 1.0)));
                }
                c.push(val);
            }
        }
        ,
        TKN_PREDICTSIGMA("PREDICTSIGMA"){

            @Override
            void do_method(RpnCalculator c, State s) {
                TKN_PREDICT.do_method(c, s);
            }
        };

        public final String token_string;

        private Token_Symbol(String token_string) {
            this.token_string = token_string;
        }

        abstract void do_method(RpnCalculator var1, State var2);
    }

    private final class State {
        private int token_rpi;
        private int rpi;
        Token token;
        int slot;

        private State() {
        }

        TimeZone getTimeZone() {
            return RpnCalculator.this.dataProcessor.getTimeZone();
        }
    }
}

