/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.jackrabbit.commons.webdav.AtomFeedConstants;
import org.apache.jackrabbit.commons.webdav.EventUtil;
import org.apache.jackrabbit.commons.webdav.JcrValueType;
import org.apache.jackrabbit.commons.webdav.NodeTypeUtil;
import org.apache.jackrabbit.commons.webdav.ValueUtil;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.Tree;
import org.apache.jackrabbit.spi.commons.ChildInfoImpl;
import org.apache.jackrabbit.spi.commons.EventBundleImpl;
import org.apache.jackrabbit.spi.commons.EventFilterImpl;
import org.apache.jackrabbit.spi.commons.ItemInfoCacheImpl;
import org.apache.jackrabbit.spi.commons.conversion.IdentifierResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.compact.CompactNodeTypeDefWriter;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.value.QValueValue;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.BatchUtils;
import org.apache.jackrabbit.spi2dav.ConnectionOptions;
import org.apache.jackrabbit.spi2dav.CredentialsWrapper;
import org.apache.jackrabbit.spi2dav.DefinitionUtil;
import org.apache.jackrabbit.spi2dav.DocumentTree;
import org.apache.jackrabbit.spi2dav.EventImpl;
import org.apache.jackrabbit.spi2dav.EventSubscriptionImpl;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.spi2dav.LockInfoImpl;
import org.apache.jackrabbit.spi2dav.NodeInfoImpl;
import org.apache.jackrabbit.spi2dav.PropertyInfoImpl;
import org.apache.jackrabbit.spi2dav.QueryInfoImpl;
import org.apache.jackrabbit.spi2dav.SessionInfoImpl;
import org.apache.jackrabbit.spi2dav.URIResolverImpl;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpCheckin;
import org.apache.jackrabbit.webdav.client.methods.HttpCheckout;
import org.apache.jackrabbit.webdav.client.methods.HttpCopy;
import org.apache.jackrabbit.webdav.client.methods.HttpDelete;
import org.apache.jackrabbit.webdav.client.methods.HttpLabel;
import org.apache.jackrabbit.webdav.client.methods.HttpLock;
import org.apache.jackrabbit.webdav.client.methods.HttpMerge;
import org.apache.jackrabbit.webdav.client.methods.HttpMkcol;
import org.apache.jackrabbit.webdav.client.methods.HttpMkworkspace;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.jackrabbit.webdav.client.methods.HttpOptions;
import org.apache.jackrabbit.webdav.client.methods.HttpOrderpatch;
import org.apache.jackrabbit.webdav.client.methods.HttpPoll;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.client.methods.HttpProppatch;
import org.apache.jackrabbit.webdav.client.methods.HttpReport;
import org.apache.jackrabbit.webdav.client.methods.HttpSearch;
import org.apache.jackrabbit.webdav.client.methods.HttpSubscribe;
import org.apache.jackrabbit.webdav.client.methods.HttpUnlock;
import org.apache.jackrabbit.webdav.client.methods.HttpUnsubscribe;
import org.apache.jackrabbit.webdav.client.methods.HttpUpdate;
import org.apache.jackrabbit.webdav.client.methods.XmlEntity;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.observation.DefaultEventType;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.EventType;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.ordering.OrderPatch;
import org.apache.jackrabbit.webdav.ordering.Position;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.security.SupportedPrivilege;
import org.apache.jackrabbit.webdav.security.SupportedPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.transaction.TransactionConstants;
import org.apache.jackrabbit.webdav.transaction.TransactionInfo;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class RepositoryServiceImpl
implements RepositoryService,
DavConstants {
    private static Logger log = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final SubscriptionInfo S_INFO = new SubscriptionInfo(DefaultEventType.create(EventUtil.EVENT_ALL, ItemResourceConstants.NAMESPACE), true, Integer.MAX_VALUE);
    private static final String CLIENT_KEY = "repoCreation";
    public static final int MAX_CONNECTIONS_DEFAULT = 20;
    private final IdFactory idFactory;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final QValueFactory qValueFactory;
    private final ValueFactory valueFactory;
    private final int itemInfoCacheSize;
    private final NamespaceCache nsCache;
    private final URIResolverImpl uriResolver;
    private final HttpHost httpHost;
    private final ConcurrentMap<Object, HttpClient> clients;
    private final HttpClientBuilder httpClientBuilder;
    private final Map<AuthScope, org.apache.http.auth.Credentials> commonCredentials;
    private final Map<Name, QNodeTypeDefinition> nodeTypeDefinitions = new HashMap<Name, QNodeTypeDefinition>();
    private final Map<String, QValue[]> descriptors = new HashMap<String, QValue[]>();
    private boolean remoteServerProvidesNodeTypes = false;
    private boolean remoteServerProvidesNoLocalFlag = false;
    private Set<String> remoteDavComplianceClasses = null;
    private static final Set<String> readMethods;

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory) throws RepositoryException {
        this(uri, idFactory, nameFactory, pathFactory, qValueFactory, 5000);
    }

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory, int itemInfoCacheSize) throws RepositoryException {
        this(uri, idFactory, nameFactory, pathFactory, qValueFactory, itemInfoCacheSize, ConnectionOptions.DEFAULT);
    }

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory, int itemInfoCacheSize, ConnectionOptions connectionOptions) throws RepositoryException {
        SSLConnectionSocketFactory sslSocketFactory;
        SSLContext sslContext;
        if (uri == null || "".equals(uri)) {
            throw new RepositoryException("Invalid repository uri '" + uri + "'.");
        }
        if (idFactory == null || qValueFactory == null) {
            throw new RepositoryException("IdFactory and QValueFactory may not be null.");
        }
        this.idFactory = idFactory;
        this.nameFactory = nameFactory;
        this.pathFactory = pathFactory;
        this.qValueFactory = qValueFactory;
        this.itemInfoCacheSize = itemInfoCacheSize;
        this.commonCredentials = new HashMap<AuthScope, org.apache.http.auth.Credentials>();
        try {
            URI repositoryUri = RepositoryServiceImpl.computeRepositoryUri(uri);
            this.httpHost = new HttpHost(repositoryUri.getHost(), repositoryUri.getPort(), repositoryUri.getScheme());
            this.nsCache = new NamespaceCache();
            this.uriResolver = new URIResolverImpl(repositoryUri, this, DomUtil.createDocument());
            NamePathResolverImpl resolver = new NamePathResolverImpl(this.nsCache);
            this.valueFactory = new ValueFactoryQImpl(qValueFactory, resolver);
        }
        catch (URISyntaxException e) {
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        HttpClientBuilder hcb = HttpClients.custom();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionOptions.getConnectionTimeoutMs()).setConnectionRequestTimeout(connectionOptions.getRequestTimeoutMs()).setSocketTimeout(connectionOptions.getSocketTimeoutMs()).build();
        hcb.setDefaultRequestConfig(requestConfig);
        if (Boolean.getBoolean("jackrabbit.client.useSystemProperties") || connectionOptions.isUseSystemPropertes()) {
            log.debug("Using system properties for establishing connection!");
            hcb.useSystemProperties();
        }
        try {
            if (connectionOptions.isAllowSelfSignedCertificates()) {
                log.warn("Nonsecure TLS setting: Accepting self-signed certificates!");
                sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
                hcb.setSSLContext(sslContext);
            } else {
                sslContext = SSLContextBuilder.create().build();
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RepositoryException(e);
        }
        if (connectionOptions.isDisableHostnameVerification()) {
            log.warn("Nonsecure TLS setting: Host name verification of TLS certificates disabled!");
            sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        } else {
            sslSocketFactory = new SSLConnectionSocketFactory(sslContext);
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager cmgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        int maxConnections = connectionOptions.getMaxConnections();
        if (maxConnections > 0) {
            cmgr.setDefaultMaxPerRoute(connectionOptions.getMaxConnections());
            cmgr.setMaxTotal(connectionOptions.getMaxConnections());
        } else {
            maxConnections = 20;
        }
        hcb.setConnectionManager((HttpClientConnectionManager)cmgr);
        if (connectionOptions.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(connectionOptions.getProxyHost(), connectionOptions.getProxyPort(), connectionOptions.getProxyProtocol());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            hcb.setRoutePlanner((HttpRoutePlanner)routePlanner);
            log.debug("Connection via proxy {}", (Object)proxy);
            if (connectionOptions.getProxyUsername() != null) {
                log.debug("Proxy connection with credentials {}", (Object)proxy);
                this.commonCredentials.put(new AuthScope(proxy), (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(connectionOptions.getProxyUsername(), connectionOptions.getProxyPassword()));
                hcb.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
            }
        }
        this.httpClientBuilder = hcb;
        this.clients = new ConcurrentHashMap<Object, HttpClient>(maxConnections, 0.75f, maxConnections);
    }

    private static void checkSessionInfo(SessionInfo sessionInfo) throws RepositoryException {
        if (!(sessionInfo instanceof SessionInfoImpl)) {
            throw new RepositoryException("Unknown SessionInfo implementation.");
        }
    }

    private static String resolve(String baseUri, String relUri) throws RepositoryException {
        try {
            URI base = new URI(baseUri);
            URI rel = new URI(relUri);
            return base.resolve(rel).toString();
        }
        catch (URISyntaxException ex) {
            throw new RepositoryException(ex);
        }
    }

    private static void checkSubscription(Subscription subscription) throws RepositoryException {
        if (!(subscription instanceof EventSubscriptionImpl)) {
            throw new RepositoryException("Unknown Subscription implementation.");
        }
    }

    private static boolean isUnLockMethod(HttpUriRequest request) {
        int code = DavMethods.getMethodCode(request.getMethod());
        return 13 == code;
    }

    protected static void initMethod(HttpUriRequest request, SessionInfo sessionInfo, boolean addIfHeader) throws RepositoryException {
        if (addIfHeader) {
            RepositoryServiceImpl.checkSessionInfo(sessionInfo);
            Set<String> allLockTokens = ((SessionInfoImpl)sessionInfo).getAllLockTokens();
            if (!allLockTokens.isEmpty()) {
                String[] locktokens = allLockTokens.toArray(new String[allLockTokens.size()]);
                IfHeader ifH = new IfHeader(locktokens);
                request.setHeader(ifH.getHeaderName(), ifH.getHeaderValue());
            }
        }
        RepositoryServiceImpl.initMethod(request, sessionInfo);
    }

    protected static void initMethod(HttpUriRequest request, SessionInfo sessionInfo) throws RepositoryException {
        boolean needsSessionId;
        boolean isReadAccess = readMethods.contains(request.getMethod());
        boolean bl = needsSessionId = !isReadAccess || "POLL".equals(request.getMethod());
        if (sessionInfo instanceof SessionInfoImpl && needsSessionId) {
            request.addHeader("Link", RepositoryServiceImpl.generateLinkHeaderFieldValue(sessionInfo, isReadAccess));
        }
    }

    private static String generateLinkHeaderFieldValue(SessionInfo sessionInfo, boolean isReadAccess) {
        StringBuilder linkHeaderField = new StringBuilder();
        String sessionIdentifier = ((SessionInfoImpl)sessionInfo).getSessionIdentifier();
        linkHeaderField.append("<").append(sessionIdentifier).append(">; rel=\"").append("http://www.day.com/jcr/webdav/1.0/session-id").append("\"");
        String userdata = ((SessionInfoImpl)sessionInfo).getUserData();
        if (userdata != null && !isReadAccess) {
            String escaped = org.apache.jackrabbit.util.Text.escape(userdata);
            linkHeaderField.append(", <data:,").append(escaped).append(">; rel=\"").append("http://www.day.com/jcr/webdav/1.0/user-data").append("\"");
        }
        return linkHeaderField.toString();
    }

    private static void initMethod(HttpUriRequest request, BatchImpl batchImpl, boolean addIfHeader) throws RepositoryException {
        RepositoryServiceImpl.initMethod(request, batchImpl.sessionInfo, addIfHeader);
        CodedUrlHeader ch = new CodedUrlHeader("TransactionId", batchImpl.batchId);
        request.setHeader(ch.getHeaderName(), ch.getHeaderValue());
    }

    private static boolean isSameResource(String requestURI, MultiStatusResponse response) {
        try {
            String href = RepositoryServiceImpl.resolve(requestURI, response.getHref());
            if (href.endsWith("/") && !requestURI.endsWith("/")) {
                href = href.substring(0, href.length() - 1);
            }
            return requestURI.equals(href);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private String saveGetIdString(ItemId id, SessionInfo sessionInfo) {
        NamePathResolver resolver = null;
        try {
            resolver = this.getNamePathResolver(sessionInfo);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return this.saveGetIdString(id, resolver);
    }

    private String saveGetIdString(ItemId id, NamePathResolver resolver) {
        Path p;
        StringBuffer bf = new StringBuffer();
        String uid = id.getUniqueID();
        if (uid != null) {
            bf.append(uid);
        }
        if ((p = id.getPath()) != null) {
            if (resolver == null) {
                bf.append(p.toString());
            } else {
                try {
                    bf.append(resolver.getJCRPath(p));
                }
                catch (NamespaceException e) {
                    bf.append(p.toString());
                }
            }
        }
        return bf.toString();
    }

    protected NamePathResolver getNamePathResolver(SessionInfo sessionInfo) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return this.getNamePathResolver((SessionInfoImpl)sessionInfo);
    }

    private NamePathResolver getNamePathResolver(SessionInfoImpl sessionInfo) {
        NamePathResolver resolver = sessionInfo.getNamePathResolver();
        if (resolver == null) {
            resolver = new NamePathResolverImpl(sessionInfo);
            sessionInfo.setNamePathResolver(resolver);
        }
        return resolver;
    }

    private static Object getClientKey(SessionInfo sessionInfo) {
        return sessionInfo == null ? CLIENT_KEY : sessionInfo;
    }

    protected HttpClient getClient(SessionInfo sessionInfo) throws RepositoryException {
        Object clientKey = RepositoryServiceImpl.getClientKey(sessionInfo);
        HttpClient client = (HttpClient)this.clients.get(clientKey);
        if (client == null) {
            client = this.httpClientBuilder.build();
            if (sessionInfo != null) {
                RepositoryServiceImpl.checkSessionInfo(sessionInfo);
                this.clients.put(clientKey, client);
                log.debug("Created Client " + client + " for SessionInfo " + sessionInfo);
            }
        }
        return client;
    }

    protected HttpContext getContext(SessionInfo sessionInfo) throws RepositoryException {
        HttpClientContext result = HttpClientContext.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        result.setCredentialsProvider((CredentialsProvider)credsProvider);
        for (Map.Entry<AuthScope, org.apache.http.auth.Credentials> entry : this.commonCredentials.entrySet()) {
            credsProvider.setCredentials(entry.getKey(), entry.getValue());
        }
        if (sessionInfo != null) {
            RepositoryServiceImpl.checkSessionInfo(sessionInfo);
            org.apache.http.auth.Credentials creds = ((SessionInfoImpl)sessionInfo).getCredentials().getHttpCredentials();
            if (creds != null) {
                credsProvider.setCredentials(new AuthScope(this.httpHost.getHostName(), this.httpHost.getPort()), creds);
                BasicScheme basicAuth = new BasicScheme();
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(this.httpHost, (AuthScheme)basicAuth);
                result.setAuthCache((AuthCache)authCache);
            }
        }
        return result;
    }

    private void removeClient(SessionInfo sessionInfo) {
        HttpClient cl = (HttpClient)this.clients.remove(RepositoryServiceImpl.getClientKey(sessionInfo));
        log.debug("Removed Client " + cl + " for SessionInfo " + sessionInfo);
    }

    protected String getItemUri(ItemId itemId, SessionInfo sessionInfo) throws RepositoryException {
        return this.getItemUri(itemId, sessionInfo, sessionInfo.getWorkspaceName());
    }

    protected String getItemUri(ItemId itemId, SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        return this.uriResolver.getItemUri(itemId, workspaceName, sessionInfo);
    }

    protected void clearItemUriCache(SessionInfo sessionInfo) {
        this.uriResolver.clearCacheEntries(sessionInfo);
    }

    private String getItemUri(NodeId parentId, Name childName, SessionInfo sessionInfo) throws RepositoryException {
        String parentUri = this.uriResolver.getItemUri(parentId, sessionInfo.getWorkspaceName(), sessionInfo);
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        if (!parentUri.endsWith("/")) {
            parentUri = parentUri + "/";
        }
        return parentUri + org.apache.jackrabbit.util.Text.escape(resolver.getJCRName(childName));
    }

    private NodeId getParentId(String baseUri, DavPropertySet propSet, SessionInfo sessionInfo) throws RepositoryException {
        HrefProperty parentProp;
        String parentHref;
        NodeId parentId = null;
        DavProperty<?> p = propSet.get("parent", ItemResourceConstants.NAMESPACE);
        if (p != null && (parentHref = (parentProp = new HrefProperty(p)).getHrefs().get(0)) != null && parentHref.length() > 0) {
            parentId = this.uriResolver.getNodeId(RepositoryServiceImpl.resolve(baseUri, parentHref), sessionInfo);
        }
        return parentId;
    }

    String getUniqueID(DavPropertySet propSet) {
        DavProperty<?> prop = propSet.get("uuid", ItemResourceConstants.NAMESPACE);
        if (prop != null) {
            return prop.getValue().toString();
        }
        return null;
    }

    Name getQName(DavPropertySet propSet, NamePathResolver resolver) throws RepositoryException {
        DavProperty<?> nameProp = propSet.get("name", ItemResourceConstants.NAMESPACE);
        if (nameProp != null && nameProp.getValue() != null) {
            String jcrName = nameProp.getValue().toString();
            try {
                return resolver.getQName(jcrName);
            }
            catch (NameException e) {
                throw new RepositoryException(e);
            }
        }
        return NameConstants.ROOT;
    }

    int getIndex(DavPropertySet propSet) {
        int index = 0;
        DavProperty<?> indexProp = propSet.get("index", ItemResourceConstants.NAMESPACE);
        if (indexProp != null && indexProp.getValue() != null) {
            index = Integer.parseInt(indexProp.getValue().toString());
        }
        return index;
    }

    private HttpResponse execute(BaseDavRequest request, SessionInfo sessionInfo) throws RepositoryException {
        try {
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)request));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            return response;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, (HttpRequestBase)request);
        }
    }

    @Override
    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    @Override
    public NameFactory getNameFactory() {
        return this.nameFactory;
    }

    @Override
    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    @Override
    public QValueFactory getQValueFactory() {
        return this.qValueFactory;
    }

    @Override
    public ItemInfoCache getItemInfoCache(SessionInfo sessionInfo) throws RepositoryException {
        return new ItemInfoCacheImpl(this.itemInfoCacheSize);
    }

    @Override
    public Map<String, QValue[]> getRepositoryDescriptors() throws RepositoryException {
        if (this.descriptors.isEmpty()) {
            ReportInfo info = new ReportInfo("repositorydescriptors", ItemResourceConstants.NAMESPACE);
            HttpReport request = null;
            try {
                request = new HttpReport(this.uriResolver.getRepositoryUri(), info);
                HttpResponse response = this.executeRequest(null, (HttpUriRequest)request);
                int sc = response.getStatusLine().getStatusCode();
                if (sc == 401 || sc == 407) {
                    log.warn("Authentication required to access repository descriptors");
                    Map<String, QValue[]> map = this.descriptors;
                    return map;
                }
                request.checkSuccess(response);
                Document doc = request.getResponseBodyAsDocument(response.getEntity());
                if (doc != null) {
                    Element rootElement = doc.getDocumentElement();
                    ElementIterator nsElems = DomUtil.getChildren(rootElement, "descriptor", ItemResourceConstants.NAMESPACE);
                    while (nsElems.hasNext()) {
                        Element elem = nsElems.nextElement();
                        String key = DomUtil.getChildText(elem, "descriptorkey", ItemResourceConstants.NAMESPACE);
                        ElementIterator it = DomUtil.getChildren(elem, "descriptorvalue", ItemResourceConstants.NAMESPACE);
                        ArrayList<QValue> vs = new ArrayList<QValue>();
                        while (it.hasNext()) {
                            Element dv = it.nextElement();
                            String descriptor = DomUtil.getText(dv);
                            if (key != null && descriptor != null) {
                                String typeStr = DomUtil.getAttribute(dv, "type", null);
                                int type = typeStr == null ? 1 : PropertyType.valueFromName(typeStr);
                                vs.add(this.getQValueFactory().create(descriptor, type));
                                continue;
                            }
                            log.error("Invalid descriptor key / value pair: " + key + " -> " + descriptor);
                        }
                        this.descriptors.put(key, vs.toArray(new QValue[vs.size()]));
                    }
                }
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (request != null) {
                    request.releaseConnection();
                }
            }
        }
        return this.descriptors;
    }

    @Override
    public SessionInfo obtain(Credentials credentials, String workspaceName) throws RepositoryException {
        CredentialsWrapper dc = new CredentialsWrapper(credentials);
        return this.obtain(dc, workspaceName);
    }

    @Override
    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return this.obtain(((SessionInfoImpl)sessionInfo).getCredentials(), workspaceName);
    }

    @Override
    public SessionInfo impersonate(SessionInfo sessionInfo, Credentials credentials) throws RepositoryException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private SessionInfo obtain(CredentialsWrapper credentials, String workspaceName) throws RepositoryException {
        SessionInfoImpl sessionInfo;
        block17: {
            HttpPropfind request = null;
            sessionInfo = new SessionInfoImpl(credentials, workspaceName);
            try {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DeltaVConstants.WORKSPACE);
                nameSet.add("workspaceName", ItemResourceConstants.NAMESPACE);
                request = new HttpPropfind(this.uriResolver.getWorkspaceUri(workspaceName), nameSet, 0);
                HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
                request.checkSuccess(response);
                MultiStatusResponse[] responses = request.getResponseBodyAsMultiStatus(response).getResponses();
                if (responses.length != 1) {
                    throw new LoginException("Login failed: Unknown workspace '" + workspaceName + "'.");
                }
                DavPropertySet props = responses[0].getProperties(200);
                DavProperty<?> prop = props.get("workspaceName", ItemResourceConstants.NAMESPACE);
                if (prop != null) {
                    String wspName = prop.getValue().toString();
                    if (workspaceName == null) {
                        sessionInfo = new SessionInfoImpl(credentials, wspName);
                    } else if (!wspName.equals(workspaceName)) {
                        throw new LoginException("Login failed: Invalid workspace name '" + workspaceName + "'.");
                    }
                    break block17;
                }
                if (props.contains(DeltaVConstants.WORKSPACE)) {
                    String wspHref = new HrefProperty(props.get(DeltaVConstants.WORKSPACE)).getHrefs().get(0);
                    String wspName = org.apache.jackrabbit.util.Text.unescape(org.apache.jackrabbit.util.Text.getName(wspHref, true));
                    if (!wspName.equals(workspaceName)) {
                        throw new LoginException("Login failed: Invalid workspace name " + workspaceName);
                    }
                    break block17;
                }
                throw new LoginException("Login failed: Unknown workspace '" + workspaceName + "'.");
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage(), e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (request != null) {
                    request.releaseConnection();
                }
            }
        }
        if (this.nsCache.prefixToURI.isEmpty()) {
            try {
                this.getRegisteredNamespaces(sessionInfo);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return sessionInfo;
    }

    @Override
    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        this.removeClient(sessionInfo);
    }

    @Override
    public String[] getWorkspaceNames(SessionInfo sessionInfo) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DeltaVConstants.WORKSPACE);
        HttpPropfind request = null;
        try {
            request = new HttpPropfind(this.uriResolver.getRepositoryUri(), nameSet, 1);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            HashSet<String> wspNames = new HashSet<String>();
            for (MultiStatusResponse mresponse : mresponses) {
                DavPropertySet props = mresponse.getProperties(200);
                if (!props.contains(DeltaVConstants.WORKSPACE)) continue;
                HrefProperty hp = new HrefProperty(props.get(DeltaVConstants.WORKSPACE));
                String wspHref = hp.getHrefs().get(0);
                String name = org.apache.jackrabbit.util.Text.unescape(org.apache.jackrabbit.util.Text.getName(wspHref, true));
                wspNames.add(name);
            }
            Object[] objectArray = wspNames.toArray(new String[wspNames.size()]);
            return objectArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public boolean isGranted(SessionInfo sessionInfo, ItemId itemId, String[] actions) throws RepositoryException {
        HttpReport request = null;
        try {
            String uri = RepositoryServiceImpl.obtainAbsolutePathFromUri(this.getItemUri(itemId, sessionInfo));
            ReportInfo reportInfo = new ReportInfo("privileges", ItemResourceConstants.NAMESPACE);
            reportInfo.setContentElement(DomUtil.hrefToXml(uri, DomUtil.createDocument()));
            request = new HttpReport(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()), reportInfo);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] responses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve permissions for item " + this.saveGetIdString(itemId, sessionInfo));
            }
            DavProperty<?> p = responses[0].getProperties(200).get(SecurityConstants.CURRENT_USER_PRIVILEGE_SET);
            if (p == null) {
                boolean bl = false;
                return bl;
            }
            HashSet<Privilege> requiredPrivileges = new HashSet<Privilege>();
            for (String action : actions) {
                requiredPrivileges.add(Privilege.getPrivilege(action, ItemResourceConstants.NAMESPACE));
            }
            CurrentUserPrivilegeSetProperty privSet = new CurrentUserPrivilegeSetProperty(p);
            Object privileges = privSet.getValue();
            int n = privileges.containsAll(requiredPrivileges) ? 1 : 0;
            return n != 0;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public PrivilegeDefinition[] getPrivilegeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        return this.internalGetPrivilegeDefinitions(sessionInfo, this.uriResolver.getRepositoryUri());
    }

    @Override
    public PrivilegeDefinition[] getSupportedPrivileges(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        String uri = nodeId == null ? this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()) : this.getItemUri(nodeId, sessionInfo);
        return this.internalGetPrivilegeDefinitions(sessionInfo, uri);
    }

    @Override
    public Name[] getPrivilegeNames(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        String uri = nodeId == null ? this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()) : this.getItemUri(nodeId, sessionInfo);
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(SecurityConstants.CURRENT_USER_PRIVILEGE_SET);
        HttpPropfind propfindRequest = null;
        try {
            propfindRequest = new HttpPropfind(uri, nameSet, 0);
            HttpResponse response = this.execute(propfindRequest, sessionInfo);
            propfindRequest.checkSuccess(response);
            MultiStatusResponse[] mresponses = propfindRequest.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length < 1) {
                throw new PathNotFoundException("Unable to retrieve privileges definitions.");
            }
            DavPropertyName displayName = SecurityConstants.CURRENT_USER_PRIVILEGE_SET;
            DavProperty<?> p = mresponses[0].getProperties(200).get(displayName);
            if (p == null) {
                Name[] nameArray = new Name[]{};
                return nameArray;
            }
            Object privs = new CurrentUserPrivilegeSetProperty(p).getValue();
            HashSet<Name> privNames = new HashSet<Name>(privs.size());
            Name[] nameArray = privs.iterator();
            while (nameArray.hasNext()) {
                Privilege priv = (Privilege)nameArray.next();
                privNames.add(this.nameFactory.create(priv.getNamespace().getURI(), priv.getName()));
            }
            nameArray = privNames.toArray(new Name[privNames.size()]);
            return nameArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (propfindRequest != null) {
                propfindRequest.releaseConnection();
            }
        }
    }

    private PrivilegeDefinition[] internalGetPrivilegeDefinitions(SessionInfo sessionInfo, String uri) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(SecurityConstants.SUPPORTED_PRIVILEGE_SET);
        HttpPropfind request = null;
        try {
            request = new HttpPropfind(uri, nameSet, 0);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length < 1) {
                throw new PathNotFoundException("Unable to retrieve privileges definitions.");
            }
            DavPropertyName displayName = SecurityConstants.SUPPORTED_PRIVILEGE_SET;
            DavProperty<?> p = mresponses[0].getProperties(200).get(displayName);
            if (p == null) {
                PrivilegeDefinition[] privilegeDefinitionArray = new PrivilegeDefinition[]{};
                return privilegeDefinitionArray;
            }
            HashMap<Name, SupportedPrivilege> spMap = new HashMap<Name, SupportedPrivilege>();
            RepositoryServiceImpl.fillSupportedPrivilegeMap((List<SupportedPrivilege>)new SupportedPrivilegeSetProperty(p).getValue(), spMap, this.getNameFactory());
            ArrayList<PrivilegeDefinitionImpl> pDefs = new ArrayList<PrivilegeDefinitionImpl>();
            for (Name privilegeName : spMap.keySet()) {
                SupportedPrivilege sp = (SupportedPrivilege)spMap.get(privilegeName);
                HashSet<Name> aggrnames = null;
                SupportedPrivilege[] aggregates = sp.getSupportedPrivileges();
                if (aggregates != null && aggregates.length > 0) {
                    aggrnames = new HashSet<Name>();
                    for (SupportedPrivilege aggregate : aggregates) {
                        Name aggregateName = this.nameFactory.create(aggregate.getPrivilege().getNamespace().getURI(), aggregate.getPrivilege().getName());
                        aggrnames.add(aggregateName);
                    }
                }
                PrivilegeDefinitionImpl def = new PrivilegeDefinitionImpl(privilegeName, sp.isAbstract(), aggrnames);
                pDefs.add(def);
            }
            PrivilegeDefinition[] privilegeDefinitionArray = pDefs.toArray(new PrivilegeDefinition[pDefs.size()]);
            return privilegeDefinitionArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private static void fillSupportedPrivilegeMap(List<SupportedPrivilege> sps, Map<Name, SupportedPrivilege> spMap, NameFactory nameFactory) throws NamespaceException, IllegalNameException {
        for (SupportedPrivilege sp : sps) {
            Privilege p = sp.getPrivilege();
            Name privName = nameFactory.create(p.getNamespace().getURI(), p.getName());
            spMap.put(privName, sp);
            List<SupportedPrivilege> agg = Arrays.asList(sp.getSupportedPrivileges());
            if (agg.isEmpty()) continue;
            RepositoryServiceImpl.fillSupportedPrivilegeMap(agg, spMap, nameFactory);
        }
    }

    @Override
    public QNodeDefinition getNodeDefinition(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return (QNodeDefinition)this.getItemDefinition(sessionInfo, nodeId);
    }

    @Override
    public QPropertyDefinition getPropertyDefinition(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        return (QPropertyDefinition)this.getItemDefinition(sessionInfo, propertyId);
    }

    private QItemDefinition getItemDefinition(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("definition", ItemResourceConstants.NAMESPACE);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        HttpPropfind request = null;
        try {
            Object value;
            String uri = this.getItemUri(itemId, sessionInfo);
            request = new HttpPropfind(uri, nameSet, 0);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the item definition for " + this.saveGetIdString(itemId, sessionInfo));
            }
            if (mresponses.length > 1) {
                throw new RepositoryException("Internal error: ambigous item definition found '" + this.saveGetIdString(itemId, sessionInfo) + "'.");
            }
            DavPropertySet propertySet = mresponses[0].getProperties(200);
            DavProperty<?> rType = propertySet.get(DavPropertyName.RESOURCETYPE);
            if (rType.getValue() == null && itemId.denotesNode()) {
                throw new RepositoryException("Internal error: requested node definition and got property definition.");
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            QItemDefinition definition = null;
            DavProperty<?> prop = propertySet.get("definition", ItemResourceConstants.NAMESPACE);
            if (prop != null && (value = prop.getValue()) != null && value instanceof Element) {
                Element idfElem = (Element)value;
                definition = itemId.denotesNode() ? DefinitionUtil.createQNodeDefinition(null, idfElem, resolver) : DefinitionUtil.createQPropertyDefinition(null, idfElem, resolver, this.getQValueFactory());
            }
            if (definition == null) {
                throw new RepositoryException("Unable to retrieve definition for item with id '" + this.saveGetIdString(itemId, resolver) + "'.");
            }
            QNodeDefinition qNodeDefinition = definition;
            return qNodeDefinition;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("index", ItemResourceConstants.NAMESPACE);
        nameSet.add("parent", ItemResourceConstants.NAMESPACE);
        nameSet.add("name", ItemResourceConstants.NAMESPACE);
        nameSet.add("primarynodetype", ItemResourceConstants.NAMESPACE);
        nameSet.add("mixinnodetypes", ItemResourceConstants.NAMESPACE);
        nameSet.add("references", ItemResourceConstants.NAMESPACE);
        nameSet.add("uuid", ItemResourceConstants.NAMESPACE);
        nameSet.add("path", ItemResourceConstants.NAMESPACE);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        HttpPropfind request = null;
        try {
            String uri = this.getItemUri(nodeId, sessionInfo);
            request = new HttpPropfind(uri, nameSet, 1);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            MultiStatusResponse nodeResponse = null;
            ArrayList<MultiStatusResponse> childResponses = new ArrayList<MultiStatusResponse>();
            for (MultiStatusResponse mresponse : mresponses) {
                if (RepositoryServiceImpl.isSameResource(uri, mresponse)) {
                    nodeResponse = mresponse;
                    continue;
                }
                childResponses.add(mresponse);
            }
            if (nodeResponse == null) {
                throw new ItemNotFoundException("Unable to retrieve the node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            DavPropertySet propSet = nodeResponse.getProperties(200);
            Object type = propSet.get(DavPropertyName.RESOURCETYPE).getValue();
            if (type == null) {
                throw new ItemNotFoundException("No node for id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            NodeId parentId = this.getParentId(uri, propSet, sessionInfo);
            NodeInfoImpl nInfo = this.buildNodeInfo(uri, nodeResponse, parentId, propSet, sessionInfo, resolver);
            for (MultiStatusResponse resp : childResponses) {
                DavPropertySet childProps = resp.getProperties(200);
                if (childProps.contains(DavPropertyName.RESOURCETYPE) && childProps.get(DavPropertyName.RESOURCETYPE).getValue() != null) {
                    nInfo.addChildInfo(this.buildChildInfo(childProps, sessionInfo));
                    continue;
                }
                PropertyId childId = this.uriResolver.buildPropertyId(nInfo.getId(), resp, sessionInfo.getWorkspaceName(), this.getNamePathResolver(sessionInfo));
                nInfo.addPropertyId(childId);
            }
            NodeInfoImpl nodeInfoImpl = nInfo;
            return nodeInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        if (itemId.denotesNode()) {
            ArrayList<ItemInfo> l = new ArrayList<ItemInfo>();
            NodeInfo nInfo = this.getNodeInfo(sessionInfo, (NodeId)itemId);
            l.add(nInfo);
            l.addAll(this.buildPropertyInfos(nInfo));
            return l.iterator();
        }
        PropertyInfo pInfo = this.getPropertyInfo(sessionInfo, (PropertyId)itemId);
        return Iterators.singleton(pInfo);
    }

    private NodeInfoImpl buildNodeInfo(String baseUri, MultiStatusResponse nodeResponse, NodeId parentId, DavPropertySet propSet, SessionInfo sessionInfo, NamePathResolver resolver) throws RepositoryException {
        NodeId id = this.uriResolver.buildNodeId(parentId, baseUri, nodeResponse, sessionInfo.getWorkspaceName(), this.getNamePathResolver(sessionInfo));
        NodeInfoImpl nInfo = new NodeInfoImpl(id, propSet, resolver);
        DavProperty<?> p = propSet.get("references", ItemResourceConstants.NAMESPACE);
        if (p != null) {
            HrefProperty refProp = new HrefProperty(p);
            for (String propertyHref : refProp.getHrefs()) {
                PropertyId propertyId = this.uriResolver.getPropertyId(propertyHref, sessionInfo);
                nInfo.addReference(propertyId);
            }
        }
        return nInfo;
    }

    private List<PropertyInfo> buildPropertyInfos(NodeInfo nInfo) throws RepositoryException {
        QValue[] vs;
        ArrayList<PropertyInfo> l = new ArrayList<PropertyInfo>(3);
        NodeId nid = nInfo.getId();
        Path nPath = nInfo.getPath();
        if (nid.getPath() == null) {
            PropertyId id = this.getIdFactory().createPropertyId(nid, NameConstants.JCR_UUID);
            vs = new QValue[]{this.getQValueFactory().create(nid.getUniqueID(), 1)};
            Path p = this.getPathFactory().create(nPath, NameConstants.JCR_UUID, true);
            PropertyInfoImpl pi = new PropertyInfoImpl(id, p, 1, false, vs);
            l.add(pi);
        }
        Name pName = NameConstants.JCR_PRIMARYTYPE;
        vs = new QValue[]{this.getQValueFactory().create(nInfo.getNodetype())};
        PropertyInfoImpl pi = new PropertyInfoImpl(this.getIdFactory().createPropertyId(nid, pName), this.getPathFactory().create(nPath, pName, true), 7, false, vs);
        l.add(pi);
        Name[] mixins = nInfo.getMixins();
        if (mixins.length > 0) {
            pName = NameConstants.JCR_MIXINTYPES;
            vs = new QValue[mixins.length];
            for (int i = 0; i < mixins.length; ++i) {
                vs[i] = this.getQValueFactory().create(mixins[i]);
            }
            pi = new PropertyInfoImpl(this.getIdFactory().createPropertyId(nid, pName), this.getPathFactory().create(nPath, pName, true), 7, true, vs);
            l.add(pi);
        }
        return l;
    }

    @Override
    public Iterator<ChildInfo> getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("name", ItemResourceConstants.NAMESPACE);
        nameSet.add("index", ItemResourceConstants.NAMESPACE);
        nameSet.add("parent", ItemResourceConstants.NAMESPACE);
        nameSet.add("uuid", ItemResourceConstants.NAMESPACE);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        HttpPropfind request = null;
        try {
            String uri = this.getItemUri(parentId, sessionInfo);
            request = new HttpPropfind(uri, nameSet, 1);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)parentId, sessionInfo));
            }
            if (mresponses.length == 1) {
                List childEntries = Collections.emptyList();
                Iterator<ChildInfo> iterator = childEntries.iterator();
                return iterator;
            }
            ArrayList<ChildInfo> childEntries = new ArrayList<ChildInfo>();
            for (MultiStatusResponse mresponse : mresponses) {
                DavPropertySet childProps;
                if (RepositoryServiceImpl.isSameResource(uri, mresponse) || !(childProps = mresponse.getProperties(200)).contains(DavPropertyName.RESOURCETYPE) || childProps.get(DavPropertyName.RESOURCETYPE).getValue() == null) continue;
                childEntries.add(this.buildChildInfo(childProps, sessionInfo));
            }
            Iterator<ChildInfo> iterator = childEntries.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private ChildInfo buildChildInfo(DavPropertySet properties, SessionInfo sessionInfo) throws RepositoryException {
        Name qName = this.getQName(properties, this.getNamePathResolver(sessionInfo));
        int index = this.getIndex(properties);
        String uuid = this.getUniqueID(properties);
        return new ChildInfoImpl(qName, uuid, index);
    }

    @Override
    public Iterator<PropertyId> getReferences(SessionInfo sessionInfo, NodeId nodeId, Name propertyName, boolean weakReferences) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        String refType = weakReferences ? "weakreferences" : "references";
        nameSet.add(refType, ItemResourceConstants.NAMESPACE);
        HttpPropfind request = null;
        try {
            String uri = this.getItemUri(nodeId, sessionInfo);
            request = new HttpPropfind(uri, nameSet, 0);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            List refIds = Collections.emptyList();
            for (MultiStatusResponse mresponse : mresponses) {
                DavPropertySet props;
                DavProperty<?> p;
                if (!RepositoryServiceImpl.isSameResource(uri, mresponse) || (p = (props = mresponse.getProperties(200)).get(refType, ItemResourceConstants.NAMESPACE)) == null) continue;
                refIds = new ArrayList();
                HrefProperty hp = new HrefProperty(p);
                for (String propHref : hp.getHrefs()) {
                    PropertyId propId = this.uriResolver.getPropertyId(RepositoryServiceImpl.resolve(uri, propHref), sessionInfo);
                    if (propertyName != null && !propertyName.equals(propId.getName())) continue;
                    refIds.add(propId);
                }
            }
            Iterator<PropertyId> iterator = refIds.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        HttpGet request = null;
        try {
            boolean isMultiValued;
            QValue[] values;
            int type;
            String uri = this.getItemUri(propertyId, sessionInfo);
            request = new HttpGet(uri);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                throw ExceptionConverter.generate(new DavException(status, response.getStatusLine().getReasonPhrase()));
            }
            Path path = this.uriResolver.getQPath(uri, sessionInfo);
            HttpEntity entity = response.getEntity();
            ContentType ct = ContentType.get((HttpEntity)entity);
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            if (ct != null && ct.getMimeType().startsWith("jcr-value")) {
                QValue v;
                type = JcrValueType.typeFromContentType(ct.getMimeType());
                if (type == 2) {
                    v = this.getQValueFactory().create(entity.getContent());
                } else {
                    int c;
                    InputStreamReader reader = new InputStreamReader(entity.getContent(), ct.getCharset());
                    StringBuffer sb = new StringBuffer();
                    while ((c = ((Reader)reader).read()) > -1) {
                        sb.append((char)c);
                    }
                    Value jcrValue = this.valueFactory.createValue(sb.toString(), type);
                    v = jcrValue instanceof QValueValue ? ((QValueValue)jcrValue).getQValue() : ValueFormat.getQValue(jcrValue, resolver, this.getQValueFactory());
                }
                values = new QValue[]{v};
                isMultiValued = false;
            } else if (ct != null && ct.getMimeType().equals("text/xml")) {
                values = this.getValues(entity.getContent(), resolver, propertyId);
                type = values.length > 0 ? values[0].getType() : this.loadType(uri, this.getClient(sessionInfo), propertyId, sessionInfo, resolver);
                isMultiValued = true;
            } else {
                throw new ItemNotFoundException("Unable to retrieve the property with id " + this.saveGetIdString((ItemId)propertyId, resolver));
            }
            PropertyInfoImpl propertyInfoImpl = new PropertyInfoImpl(propertyId, path, type, isMultiValued, values);
            return propertyInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private QValue[] getValues(InputStream response, NamePathResolver resolver, ItemId id) throws RepositoryException {
        try {
            Document doc = DomUtil.parseDocument(response);
            Element prop = DomUtil.getChildElement(doc, "values", ItemResourceConstants.NAMESPACE);
            if (prop == null) {
                throw new ItemNotFoundException("No property found at " + this.saveGetIdString(id, resolver));
            }
            DefaultDavProperty<?> p = DefaultDavProperty.createFromXml(prop);
            Value[] jcrVs = ValueUtil.valuesFromXml(p.getValue(), 1, this.valueFactory);
            QValue[] qvs = new QValue[jcrVs.length];
            int type = jcrVs.length > 0 ? jcrVs[0].getType() : 1;
            for (int i = 0; i < jcrVs.length; ++i) {
                qvs[i] = jcrVs[i] instanceof QValueValue ? ((QValueValue)jcrVs[i]).getQValue() : (type == 2 ? this.qValueFactory.create(jcrVs[i].getStream()) : ValueFormat.getQValue(jcrVs[i], resolver, this.qValueFactory));
            }
            return qvs;
        }
        catch (SAXException e) {
            log.warn("Internal error: {}", (Object)e.getMessage());
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            log.warn("Internal error: {}", (Object)e.getMessage());
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            log.warn("Internal error: {}", (Object)e.getMessage());
            throw new RepositoryException(e);
        }
    }

    private int loadType(String propertyURI, HttpClient client, PropertyId propertyId, SessionInfo sessionInfo, NamePathResolver resolver) throws IOException, DavException, RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("type", ItemResourceConstants.NAMESPACE);
        HttpPropfind request = null;
        try {
            request = new HttpPropfind(propertyURI, nameSet, 0);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length == 1) {
                DavPropertySet props = mresponses[0].getProperties(200);
                DavProperty<?> type = props.get("type", ItemResourceConstants.NAMESPACE);
                if (type != null) {
                    int n = PropertyType.valueFromName(type.getValue().toString());
                    return n;
                }
                throw new RepositoryException("Internal error. Cannot retrieve property type at " + this.saveGetIdString((ItemId)propertyId, resolver));
            }
            throw new ItemNotFoundException("Internal error. Cannot retrieve property type at " + this.saveGetIdString((ItemId)propertyId, resolver));
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return new BatchImpl(itemId, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Batch batch) throws RepositoryException {
        if (!(batch instanceof BatchImpl)) {
            throw new RepositoryException("Unknown Batch implementation.");
        }
        BatchImpl batchImpl = (BatchImpl)batch;
        if (batchImpl.isEmpty()) {
            batchImpl.dispose();
            return;
        }
        HttpRequestBase request = null;
        try {
            HttpClient client = batchImpl.start();
            boolean success = false;
            try {
                Iterator it = batchImpl.requests();
                while (it.hasNext()) {
                    request = (HttpRequestBase)it.next();
                    RepositoryServiceImpl.initMethod((HttpUriRequest)request, batchImpl, true);
                    HttpResponse response = client.execute((HttpUriRequest)request);
                    if (request instanceof BaseDavRequest) {
                        ((BaseDavRequest)request).checkSuccess(response);
                    } else {
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode < 200 || statusCode >= 300) {
                            throw new DavException(statusCode, "Unexpected status code " + statusCode + " in response to " + request.getMethod() + " request.");
                        }
                    }
                    request.releaseConnection();
                }
                success = true;
            }
            finally {
                batchImpl.end(client, success);
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, request);
        }
        finally {
            batchImpl.dispose();
        }
    }

    @Override
    public Tree createTree(SessionInfo sessionInfo, Batch batch, Name nodeName, Name primaryTypeName, String uniqueId) throws RepositoryException {
        return new DocumentTree(nodeName, primaryTypeName, uniqueId, this.getNamePathResolver(sessionInfo));
    }

    @Override
    public void importXml(SessionInfo sessionInfo, NodeId parentId, InputStream xmlStream, int uuidBehaviour) throws RepositoryException {
        Name nodeName = this.getNameFactory().create("", UUID.randomUUID().toString());
        String uri = this.getItemUri(parentId, nodeName, sessionInfo);
        HttpMkcol mkcolRequest = new HttpMkcol(uri);
        mkcolRequest.addHeader("ImportUUIDBehavior", Integer.toString(uuidBehaviour));
        mkcolRequest.setEntity((HttpEntity)new InputStreamEntity(xmlStream, ContentType.create((String)"text/xml")));
        this.execute(mkcolRequest, sessionInfo);
    }

    @Override
    public void move(SessionInfo sessionInfo, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        String uri = this.getItemUri(srcNodeId, sessionInfo);
        String destUri = this.getItemUri(destParentNodeId, destName, sessionInfo);
        if (this.isDavClass3(sessionInfo)) {
            destUri = RepositoryServiceImpl.obtainAbsolutePathFromUri(destUri);
        }
        HttpMove request = new HttpMove(uri, destUri, false);
        try {
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            this.clearItemUriCache(sessionInfo);
        }
        catch (IOException ex) {
            throw new RepositoryException(ex);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, (HttpRequestBase)request);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public void copy(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        String uri = this.uriResolver.getItemUri(srcNodeId, srcWorkspaceName, sessionInfo);
        String destUri = this.getItemUri(destParentNodeId, destName, sessionInfo);
        if (this.isDavClass3(sessionInfo)) {
            destUri = RepositoryServiceImpl.obtainAbsolutePathFromUri(destUri);
        }
        HttpCopy request = new HttpCopy(uri, destUri, false, false);
        try {
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException ex) {
            throw new RepositoryException(ex);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, (HttpRequestBase)request);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public void update(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName) throws RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        String workspUri = this.uriResolver.getWorkspaceUri(srcWorkspaceName);
        this.update(uri, null, new String[]{workspUri}, 2, false, sessionInfo);
    }

    @Override
    public void clone(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException("Missing implementation");
    }

    @Override
    public LockInfo getLockInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.LOCKDISCOVERY);
        nameSet.add("parent", ItemResourceConstants.NAMESPACE);
        HttpPropfind request = null;
        try {
            String uri = this.getItemUri(nodeId, sessionInfo);
            request = new HttpPropfind(uri, nameSet, 0);
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, false);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length != 1) {
                throw new ItemNotFoundException("Unable to retrieve the LockInfo. No such node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            DavPropertySet ps = mresponses[0].getProperties(200);
            if (ps.contains(DavPropertyName.LOCKDISCOVERY)) {
                DavProperty<?> p = ps.get(DavPropertyName.LOCKDISCOVERY);
                LockDiscovery ld = LockDiscovery.createFromXml(p.toXml(DomUtil.createDocument()));
                NodeId parentId = this.getParentId(uri, ps, sessionInfo);
                LockInfo lockInfo = this.retrieveLockInfo(ld, sessionInfo, nodeId, parentId);
                return lockInfo;
            }
            log.debug("No Lock present on node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            LockInfo lockInfo = null;
            return lockInfo;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped) throws RepositoryException {
        return this.lock(sessionInfo, nodeId, deep, sessionScoped, Long.MAX_VALUE, null);
    }

    @Override
    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped, long timeoutHint, String ownerHint) throws RepositoryException {
        HttpLock request = null;
        try {
            RepositoryServiceImpl.checkSessionInfo(sessionInfo);
            long davTimeout = timeoutHint == Long.MAX_VALUE ? Integer.MAX_VALUE : timeoutHint * 1000L;
            String ownerInfo = ownerHint == null ? sessionInfo.getUserID() : ownerHint;
            String uri = this.getItemUri(nodeId, sessionInfo);
            Scope scope = sessionScoped ? ItemResourceConstants.EXCLUSIVE_SESSION : Scope.EXCLUSIVE;
            request = new HttpLock(uri, new org.apache.jackrabbit.webdav.lock.LockInfo(scope, Type.WRITE, ownerInfo, davTimeout, deep));
            HttpResponse response = this.execute(request, sessionInfo);
            String lockToken = request.getLockToken(response);
            ((SessionInfoImpl)sessionInfo).addLockToken(lockToken, sessionScoped);
            LockDiscovery disc = request.getResponseBodyAsLockDiscovery(response);
            LockInfo lockInfo = this.retrieveLockInfo(disc, sessionInfo, nodeId, null);
            return lockInfo;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String uri = this.getItemUri(nodeId, sessionInfo);
        Set<String> allLockTokens = ((SessionInfoImpl)sessionInfo).getAllLockTokens();
        String[] locktokens = allLockTokens.toArray(new String[allLockTokens.size()]);
        HttpLock httpLock = null;
        try {
            httpLock = new HttpLock(uri, Integer.MAX_VALUE, locktokens);
            this.execute(httpLock, sessionInfo);
        }
        finally {
            if (httpLock != null) {
                httpLock.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String uri = this.getItemUri(nodeId, sessionInfo);
        LockInfoImpl lInfo = (LockInfoImpl)this.getLockInfo(sessionInfo, nodeId);
        if (lInfo == null) {
            throw new LockException("No Lock present on Node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
        }
        String lockToken = lInfo.getActiveLock().getToken();
        boolean isSessionScoped = lInfo.isSessionScoped();
        if (!((SessionInfoImpl)sessionInfo).getAllLockTokens().contains(lockToken)) {
            throw new LockException("Lock " + lockToken + " not owned by this session");
        }
        HttpUnlock unlockRequest = new HttpUnlock(uri, lockToken);
        try {
            this.execute(unlockRequest, sessionInfo);
            ((SessionInfoImpl)sessionInfo).removeLockToken(lockToken, isSessionScoped);
        }
        finally {
            unlockRequest.releaseConnection();
        }
    }

    private LockInfo retrieveLockInfo(LockDiscovery lockDiscovery, SessionInfo sessionInfo, NodeId nodeId, NodeId parentId) throws RepositoryException {
        LockInfo pLockInfo;
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        Object activeLocks = lockDiscovery.getValue();
        ActiveLock activeLock = null;
        Iterator iterator = activeLocks.iterator();
        while (iterator.hasNext()) {
            ActiveLock l = (ActiveLock)iterator.next();
            Scope sc = l.getScope();
            if (l.getType() != Type.WRITE || !Scope.EXCLUSIVE.equals(sc) && sc != ItemResourceConstants.EXCLUSIVE_SESSION) continue;
            if (activeLock != null) {
                throw new RepositoryException("Node " + this.saveGetIdString((ItemId)nodeId, sessionInfo) + " contains multiple exclusive write locks.");
            }
            activeLock = l;
        }
        if (activeLock == null) {
            log.debug("No lock present on node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            return null;
        }
        NodeId holder = null;
        String lockroot = activeLock.getLockroot();
        if (activeLock.getLockroot() != null) {
            holder = this.uriResolver.getNodeId(lockroot, sessionInfo);
        }
        if (activeLock.isDeep() && holder == null && parentId != null && (pLockInfo = this.getLockInfo(sessionInfo, parentId)) != null) {
            return pLockInfo;
        }
        return new LockInfoImpl(activeLock, holder == null ? nodeId : holder, ((SessionInfoImpl)sessionInfo).getAllLockTokens());
    }

    @Override
    public NodeId checkin(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        HttpCheckin request = new HttpCheckin(uri);
        try {
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)request));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            Header rh = response.getFirstHeader("Location");
            NodeId nodeId2 = this.uriResolver.getNodeId(RepositoryServiceImpl.resolve(uri, rh.getValue()), sessionInfo);
            return nodeId2;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException ex) {
            throw ExceptionConverter.generate(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public void checkout(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        HttpCheckout request = new HttpCheckout(uri);
        try {
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)request));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException ex) {
            throw ExceptionConverter.generate(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public void checkout(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws RepositoryException {
        if (activityId != null) {
            throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
        }
        this.checkout(sessionInfo, nodeId);
    }

    @Override
    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        NodeId vID = this.checkin(sessionInfo, nodeId);
        this.checkout(sessionInfo, nodeId);
        return vID;
    }

    @Override
    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws RepositoryException {
        if (activityId == null) {
            return this.checkpoint(sessionInfo, nodeId);
        }
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public void removeVersion(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId) throws RepositoryException {
        String uri = this.getItemUri(versionId, sessionInfo);
        HttpDelete request = new HttpDelete(uri);
        try {
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)request));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException ex) {
            throw new RepositoryException(ex);
        }
        catch (DavException ex) {
            throw ExceptionConverter.generate(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public void restore(SessionInfo sessionInfo, NodeId nodeId, NodeId versionId, boolean removeExisting) throws RepositoryException {
        String uri = this.getItemUri(nodeId, sessionInfo);
        String vUri = this.getItemUri(versionId, sessionInfo);
        Path relPath = null;
        if (!this.exists(sessionInfo, uri)) {
            Path path = nodeId.getPath();
            if (nodeId.getUniqueID() != null) {
                uri = this.getItemUri(this.idFactory.createNodeId(nodeId.getUniqueID(), null), sessionInfo);
                relPath = path.isAbsolute() ? this.getPathFactory().getRootPath().computeRelativePath(path) : path;
            } else {
                for (int degree = 0; degree < path.getLength(); ++degree) {
                    Path ancestorPath = path.getAncestor(degree);
                    NodeId parentId = this.idFactory.createNodeId(nodeId.getUniqueID(), ancestorPath);
                    if (!this.exists(sessionInfo, this.getItemUri(parentId, sessionInfo))) continue;
                    uri = this.getItemUri(parentId, sessionInfo);
                    relPath = ancestorPath.computeRelativePath(path);
                    break;
                }
            }
        }
        this.update(uri, relPath, new String[]{vUri}, 0, removeExisting, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(SessionInfo sInfo, String uri) {
        HttpHead request = new HttpHead(uri);
        try {
            int statusCode = this.executeRequest(sInfo, (HttpUriRequest)request).getStatusLine().getStatusCode();
            boolean bl = statusCode == 200;
            return bl;
        }
        catch (IOException e) {
            log.error("Unexpected error while testing existence of item.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public void restore(SessionInfo sessionInfo, NodeId[] versionIds, boolean removeExisting) throws RepositoryException {
        String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
        String[] vUris = new String[versionIds.length];
        for (int i = 0; i < versionIds.length; ++i) {
            vUris[i] = this.getItemUri(versionIds[i], sessionInfo);
        }
        this.update(uri, null, vUris, 0, removeExisting, sessionInfo);
    }

    private void update(String uri, Path relPath, String[] updateSource, int updateType, boolean removeExisting, SessionInfo sessionInfo) throws RepositoryException {
        HttpUpdate request = null;
        try {
            UpdateInfo uInfo;
            String[] tmpUpdateSource = RepositoryServiceImpl.obtainAbsolutePathsFromUris(updateSource);
            if (removeExisting || relPath != null) {
                Element uElem = UpdateInfo.createUpdateElement(tmpUpdateSource, updateType, DomUtil.createDocument());
                if (removeExisting) {
                    DomUtil.addChildElement(uElem, "removeexisting", ItemResourceConstants.NAMESPACE);
                }
                if (relPath != null) {
                    DomUtil.addChildElement(uElem, "relpath", ItemResourceConstants.NAMESPACE, this.getNamePathResolver(sessionInfo).getJCRPath(relPath));
                }
                uInfo = new UpdateInfo(uElem);
            } else {
                uInfo = new UpdateInfo(tmpUpdateSource, updateType, new DavPropertyNameSet());
            }
            request = new HttpUpdate(uri, uInfo);
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)request));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort) throws RepositoryException {
        return this.merge(sessionInfo, nodeId, srcWorkspaceName, bestEffort, false);
    }

    @Override
    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort, boolean isShallow) throws RepositoryException {
        HttpMerge request = null;
        try {
            Document doc = DomUtil.createDocument();
            String wspHref = RepositoryServiceImpl.obtainAbsolutePathFromUri(this.uriResolver.getWorkspaceUri(srcWorkspaceName));
            Element mElem = MergeInfo.createMergeElement(new String[]{wspHref}, !bestEffort, false, doc);
            if (isShallow) {
                mElem.appendChild(DomUtil.depthToXml(false, doc));
            }
            MergeInfo mInfo = new MergeInfo(mElem);
            String uri = this.getItemUri(nodeId, sessionInfo);
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)(request = new HttpMerge(uri, mInfo))));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] resps = request.getResponseBodyAsMultiStatus(response).getResponses();
            ArrayList<NodeId> failedIds = new ArrayList<NodeId>(resps.length);
            for (MultiStatusResponse resp : resps) {
                String href = RepositoryServiceImpl.resolve(uri, resp.getHref());
                failedIds.add(this.uriResolver.getNodeId(href, sessionInfo));
            }
            Iterator<NodeId> iterator = failedIds.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public void resolveMergeConflict(SessionInfo sessionInfo, NodeId nodeId, NodeId[] mergeFailedIds, NodeId[] predecessorIds) throws RepositoryException {
        HttpProppatch request = null;
        try {
            ArrayList<HrefProperty> changeList = new ArrayList<HrefProperty>();
            String[] mergeFailedHref = new String[mergeFailedIds.length];
            for (int i = 0; i < mergeFailedIds.length; ++i) {
                mergeFailedHref[i] = this.getItemUri(mergeFailedIds[i], sessionInfo);
            }
            changeList.add(new HrefProperty(VersionControlledResource.AUTO_MERGE_SET, mergeFailedHref, false));
            if (predecessorIds != null && predecessorIds.length > 0) {
                String[] pdcHrefs = new String[predecessorIds.length];
                for (int i = 0; i < predecessorIds.length; ++i) {
                    pdcHrefs[i] = this.getItemUri(predecessorIds[i], sessionInfo);
                }
                changeList.add(new HrefProperty(VersionControlledResource.PREDECESSOR_SET, pdcHrefs, false));
            }
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)(request = new HttpProppatch(this.getItemUri(nodeId, sessionInfo), changeList))));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public void addVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label, boolean moveLabel) throws RepositoryException {
        HttpLabel request = null;
        try {
            String uri = this.getItemUri(versionId, sessionInfo);
            String strLabel = this.getNamePathResolver(sessionInfo).getJCRName(label);
            request = new HttpLabel(uri, new LabelInfo(strLabel, moveLabel ? 0 : 2));
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)request));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException ex) {
            throw ExceptionConverter.generate(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public void removeVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label) throws RepositoryException {
        HttpLabel request = null;
        try {
            String uri = this.getItemUri(versionId, sessionInfo);
            String strLabel = this.getNamePathResolver(sessionInfo).getJCRName(label);
            request = new HttpLabel(uri, new LabelInfo(strLabel, 1));
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, !RepositoryServiceImpl.isUnLockMethod((HttpUriRequest)request));
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException ex) {
            throw ExceptionConverter.generate(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public NodeId createActivity(SessionInfo sessionInfo, String title) throws RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public void removeActivity(SessionInfo sessionInfo, NodeId activityId) throws RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public Iterator<NodeId> mergeActivity(SessionInfo sessionInfo, NodeId activityId) throws RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public NodeId createConfiguration(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    @Override
    public String[] getSupportedQueryLanguages(SessionInfo sessionInfo) throws RepositoryException {
        HttpOptions request = new HttpOptions(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()));
        try {
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new DavException(status);
            }
            String[] stringArray = request.getSearchGrammars(response).toArray(new String[0]);
            return stringArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public String[] checkQueryStatement(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces) throws RepositoryException {
        return new String[0];
    }

    @Override
    public QueryInfo executeQuery(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces, long limit, long offset, Map<String, QValue> values) throws RepositoryException {
        HttpSearch request = null;
        try {
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            SearchInfo sInfo = new SearchInfo(language, ItemResourceConstants.NAMESPACE, statement, namespaces);
            if (limit != -1L) {
                sInfo.setNumberResults(limit);
            }
            if (offset != -1L) {
                sInfo.setOffset(offset);
            }
            if (values != null && !values.isEmpty()) {
                throw new UnsupportedOperationException("Implementation missing:  JCR-2107");
            }
            request = new HttpSearch(uri, sInfo);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatus ms = request.getResponseBodyAsMultiStatus(response);
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            QueryInfoImpl queryInfoImpl = new QueryInfoImpl(ms, this.idFactory, resolver, this.valueFactory, this.getQValueFactory());
            return queryInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventFilter createEventFilter(SessionInfo sessionInfo, int eventTypes, Path absPath, boolean isDeep, String[] uuids, Name[] nodeTypeNames, boolean noLocal) throws RepositoryException {
        HashSet<Name> resolvedTypeNames = null;
        if (nodeTypeNames != null) {
            resolvedTypeNames = new HashSet<Name>();
            if (this.nodeTypeDefinitions.size() == 0) {
                this.getQNodeTypeDefinitions(sessionInfo);
            }
            Map<Name, QNodeTypeDefinition> map = this.nodeTypeDefinitions;
            synchronized (map) {
                for (Name nodeTypeName : nodeTypeNames) {
                    this.resolveNodeType(resolvedTypeNames, nodeTypeName);
                }
            }
        }
        return new EventFilterImpl(eventTypes, absPath, isDeep, uuids, resolvedTypeNames, noLocal);
    }

    @Override
    public EventBundle[] getEvents(Subscription subscription, long timeout) throws RepositoryException {
        RepositoryServiceImpl.checkSubscription(subscription);
        EventSubscriptionImpl subscr = (EventSubscriptionImpl)subscription;
        String rootUri = this.uriResolver.getRootItemUri(subscr.getSessionInfo().getWorkspaceName());
        return this.poll(rootUri, subscr.getId(), timeout, subscr.getSessionInfo());
    }

    @Override
    public EventBundle getEvents(SessionInfo sessionInfo, EventFilter filter, long after) throws RepositoryException {
        HttpGet request = null;
        String rootUri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
        rootUri = rootUri + "?type=journal";
        try {
            request = new HttpGet(rootUri);
            request.addHeader("If-None-Match", "\"" + Long.toHexString(after) + "\"");
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new RepositoryException("getEvents to " + rootUri + " failed with " + response.getStatusLine());
            }
            HttpEntity entity = response.getEntity();
            InputStream in = entity.getContent();
            Document doc = null;
            if (in != null) {
                try {
                    doc = DomUtil.parseDocument(in);
                }
                catch (ParserConfigurationException e) {
                    throw new IOException("XML parser configuration error", e);
                }
                catch (SAXException e) {
                    throw new IOException("XML parsing error", e);
                }
                finally {
                    in.close();
                }
            }
            ArrayList<Event> events = new ArrayList<Event>();
            ElementIterator entries = DomUtil.getChildren(doc.getDocumentElement(), AtomFeedConstants.N_ENTRY);
            while (entries.hasNext()) {
                Element entryElem = entries.next();
                Element contentElem = DomUtil.getChildElement(entryElem, AtomFeedConstants.N_CONTENT);
                if (contentElem == null || !"application/vnd.apache.jackrabbit.event+xml".equals(contentElem.getAttribute("type"))) continue;
                List<Event> el = this.buildEventList(contentElem, (SessionInfoImpl)sessionInfo, rootUri);
                for (Event e : el) {
                    if (e.getDate() <= after || filter != null && !filter.accept(e, false)) continue;
                    events.add(e);
                }
            }
            EventBundleImpl eventBundleImpl = new EventBundleImpl(events, false);
            return eventBundleImpl;
        }
        catch (Exception ex) {
            log.error("extracting events from journal feed", (Throwable)ex);
            throw new RepositoryException("extracting events from journal feed: " + ex.getMessage(), ex);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Subscription createSubscription(SessionInfo sessionInfo, EventFilter[] filters) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String rootUri = this.uriResolver.getRootItemUri(sessionInfo.getWorkspaceName());
        String subscriptionId = this.subscribe(rootUri, S_INFO, null, sessionInfo, null);
        log.debug("Subscribed on server for session info " + sessionInfo);
        try {
            this.checkEventFilterSupport(filters);
        }
        catch (UnsupportedRepositoryOperationException ex) {
            this.unsubscribe(rootUri, subscriptionId, sessionInfo);
            throw ex;
        }
        return new EventSubscriptionImpl(subscriptionId, (SessionInfoImpl)sessionInfo);
    }

    @Override
    public void updateEventFilters(Subscription subscription, EventFilter[] filters) throws RepositoryException {
        this.checkEventFilterSupport(filters);
    }

    private void checkEventFilterSupport(EventFilter[] filters) throws UnsupportedRepositoryOperationException {
        for (EventFilter ef : filters) {
            if (!(ef instanceof EventFilterImpl)) continue;
            EventFilterImpl efi = (EventFilterImpl)ef;
            if (efi.getNodeTypeNames() != null && !this.remoteServerProvidesNodeTypes) {
                throw new UnsupportedRepositoryOperationException("Remote server does not provide node type information in events");
            }
            if (!efi.getNoLocal() || this.remoteServerProvidesNoLocalFlag) continue;
            throw new UnsupportedRepositoryOperationException("Remote server does not provide local flag in events");
        }
    }

    @Override
    public void dispose(Subscription subscription) throws RepositoryException {
        RepositoryServiceImpl.checkSubscription(subscription);
        EventSubscriptionImpl subscr = (EventSubscriptionImpl)subscription;
        String rootUri = this.uriResolver.getRootItemUri(subscr.getSessionInfo().getWorkspaceName());
        this.unsubscribe(rootUri, subscr.getId(), subscr.getSessionInfo());
    }

    private String subscribe(String uri, SubscriptionInfo subscriptionInfo, String subscriptionId, SessionInfo sessionInfo, String batchId) throws RepositoryException {
        HttpSubscribe request = null;
        try {
            request = new HttpSubscribe(uri, subscriptionInfo, subscriptionId);
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo);
            if (batchId != null) {
                CodedUrlHeader ch = new CodedUrlHeader("TransactionId", batchId);
                request.setHeader(ch.getHeaderName(), ch.getHeaderValue());
            }
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            org.apache.jackrabbit.webdav.observation.Subscription[] subs = request.getResponseBodyAsSubscriptionDiscovery(response).getValue();
            if (subs.length == 1) {
                this.remoteServerProvidesNodeTypes = subs[0].eventsProvideNodeTypeInformation();
                this.remoteServerProvidesNoLocalFlag = subs[0].eventsProvideNoLocalFlag();
            }
            String string = request.getSubscriptionId(response);
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private void unsubscribe(String uri, String subscriptionId, SessionInfo sessionInfo) throws RepositoryException {
        HttpUnsubscribe request = null;
        try {
            request = new HttpUnsubscribe(uri, subscriptionId);
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private void resolveNodeType(Set<Name> resolved, Name ntName) {
        if (!resolved.add(ntName)) {
            return;
        }
        QNodeTypeDefinition def = this.nodeTypeDefinitions.get(ntName);
        if (def != null) {
            for (Name supertype : def.getSupertypes()) {
                this.resolveNodeType(resolved, supertype);
            }
        }
    }

    private EventBundle[] poll(String uri, String subscriptionId, long timeout, SessionInfoImpl sessionInfo) throws RepositoryException {
        HttpPoll request = null;
        try {
            EventBundle[] events;
            request = new HttpPoll(uri, subscriptionId, timeout);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            EventDiscovery disc = request.getResponseBodyAsEventDiscovery(response);
            if (disc.isEmpty()) {
                events = new EventBundle[]{};
            } else {
                Element discEl = disc.toXml(DomUtil.createDocument());
                ElementIterator it = DomUtil.getChildren(discEl, ObservationConstants.N_EVENTBUNDLE);
                ArrayList<EventBundleImpl> bundles = new ArrayList<EventBundleImpl>();
                while (it.hasNext()) {
                    Element bundleElement = it.nextElement();
                    String value = DomUtil.getAttribute(bundleElement, "local", null);
                    boolean isLocal = false;
                    if (value != null) {
                        isLocal = Boolean.parseBoolean(value);
                    }
                    bundles.add(new EventBundleImpl(this.buildEventList(bundleElement, sessionInfo, uri), isLocal));
                }
                events = bundles.toArray(new EventBundle[bundles.size()]);
            }
            EventBundle[] eventBundleArray = events;
            return eventBundleArray;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private List<Event> buildEventList(Element bundleElement, SessionInfoImpl sessionInfo, String baseUri) throws RepositoryException {
        ArrayList<Event> events = new ArrayList<Event>();
        ElementIterator eventElementIterator = DomUtil.getChildren(bundleElement, ObservationConstants.N_EVENT);
        String userId = null;
        if (DomUtil.matches(bundleElement, AtomFeedConstants.N_ENTRY)) {
            Element nameEl;
            Element authorEl = DomUtil.getChildElement(bundleElement, AtomFeedConstants.N_AUTHOR);
            Element element = nameEl = authorEl != null ? DomUtil.getChildElement(authorEl, AtomFeedConstants.N_NAME) : null;
            if (nameEl != null) {
                userId = DomUtil.getTextTrim(nameEl);
            }
        }
        while (eventElementIterator.hasNext()) {
            Element evElem = eventElementIterator.nextElement();
            Element typeEl = DomUtil.getChildElement(evElem, ObservationConstants.N_EVENTTYPE);
            EventType[] et = DefaultEventType.createFromXml(typeEl);
            if (et.length == 0 || et.length > 1) {
                log.error("Ambiguous event type definition: expected one single event type.");
                continue;
            }
            String href = DomUtil.getChildTextTrim(evElem, "href", NAMESPACE);
            int type = EventUtil.getJcrEventType(et[0].getName());
            Path eventPath = null;
            ItemId eventId = null;
            NodeId parentId = null;
            if (href != null) {
                href = RepositoryServiceImpl.resolve(baseUri, href);
                try {
                    eventPath = this.uriResolver.getQPath(href, sessionInfo);
                }
                catch (RepositoryException e) {
                    log.error("Internal error while building Event: ()", (Object)e.getMessage());
                    continue;
                }
                boolean isForNode = type == 1 || type == 2 || type == 32;
                try {
                    eventId = isForNode ? this.uriResolver.getNodeIdAfterEvent(href, sessionInfo, type == 2) : this.uriResolver.getPropertyId(href, sessionInfo);
                }
                catch (RepositoryException e) {
                    if (isForNode) {
                        eventId = this.idFactory.createNodeId((String)null, eventPath);
                    }
                    try {
                        eventId = this.idFactory.createPropertyId(this.idFactory.createNodeId((String)null, eventPath.getAncestor(1)), eventPath.getName());
                    }
                    catch (RepositoryException e1) {
                        log.warn("Unable to build event itemId: {}", (Object)e.getMessage());
                    }
                }
                String parentHref = org.apache.jackrabbit.util.Text.getRelativeParent(href, 1, true);
                try {
                    parentId = this.uriResolver.getNodeId(parentHref, sessionInfo);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to build event parentId: {}", (Object)e.getMessage());
                }
            }
            if (userId == null) {
                userId = DomUtil.getChildTextTrim(evElem, ObservationConstants.N_EVENTUSERID);
            }
            events.add(new EventImpl(eventId, eventPath, parentId, type, userId, evElem, this.getNamePathResolver(sessionInfo), this.getQValueFactory()));
        }
        return events;
    }

    @Override
    public Map<String, String> getRegisteredNamespaces(SessionInfo sessionInfo) throws RepositoryException {
        ReportInfo info = new ReportInfo("registerednamespaces", ItemResourceConstants.NAMESPACE);
        HttpReport request = null;
        try {
            request = new HttpReport(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()), info);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            Document doc = request.getResponseBodyAsDocument(response.getEntity());
            HashMap<String, String> namespaces = new HashMap<String, String>();
            if (doc != null) {
                Element rootElement = doc.getDocumentElement();
                ElementIterator nsElems = DomUtil.getChildren(rootElement, "namespace", ItemResourceConstants.NAMESPACE);
                while (nsElems.hasNext()) {
                    Element elem = nsElems.nextElement();
                    String prefix = DomUtil.getChildText(elem, "prefix", ItemResourceConstants.NAMESPACE);
                    String uri = DomUtil.getChildText(elem, "uri", ItemResourceConstants.NAMESPACE);
                    if (prefix == null && uri == null) {
                        uri = "";
                        prefix = "";
                    }
                    if (uri != null) {
                        namespaces.put(prefix, uri);
                        this.nsCache.add(prefix, uri);
                        continue;
                    }
                    log.error("Invalid prefix / uri pair: " + prefix + " -> " + uri);
                }
            }
            HashMap<String, String> hashMap = namespaces;
            return hashMap;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public String getNamespaceURI(SessionInfo sessionInfo, String prefix) throws RepositoryException {
        try {
            return this.nsCache.getURI(prefix);
        }
        catch (NamespaceException e) {
            this.getRegisteredNamespaces(sessionInfo);
            return this.nsCache.getURI(prefix);
        }
    }

    @Override
    public String getNamespacePrefix(SessionInfo sessionInfo, String uri) throws RepositoryException {
        try {
            return this.nsCache.getPrefix(uri);
        }
        catch (NamespaceException e) {
            this.getRegisteredNamespaces(sessionInfo);
            return this.nsCache.getPrefix(uri);
        }
    }

    @Override
    public void registerNamespace(SessionInfo sessionInfo, String prefix, String uri) throws RepositoryException {
        this.getRegisteredNamespaces(sessionInfo);
        HashMap<String, String> namespaces = new HashMap<String, String>(this.nsCache.getNamespaces());
        namespaces.put(prefix, uri);
        this.internalSetNamespaces(sessionInfo, namespaces);
        this.nsCache.add(prefix, uri);
    }

    @Override
    public void unregisterNamespace(SessionInfo sessionInfo, String uri) throws RepositoryException {
        this.getRegisteredNamespaces(sessionInfo);
        String prefix = this.nsCache.getPrefix(uri);
        HashMap<String, String> namespaces = new HashMap<String, String>(this.nsCache.getNamespaces());
        namespaces.remove(prefix);
        this.internalSetNamespaces(sessionInfo, namespaces);
        this.nsCache.remove(prefix, uri);
    }

    private void internalSetNamespaces(SessionInfo sessionInfo, Map<String, String> namespaces) throws RepositoryException {
        DavPropertySet setProperties = new DavPropertySet();
        setProperties.add(RepositoryServiceImpl.createNamespaceProperty(namespaces));
        HttpProppatch request = null;
        try {
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            request = new HttpProppatch(uri, setProperties, new DavPropertyNameSet());
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, true);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        HttpReport request = null;
        try {
            ReportInfo info = new ReportInfo("nodetypes", ItemResourceConstants.NAMESPACE);
            info.setContentElement(DomUtil.createElement(DomUtil.createDocument(), "all-nodetypes", ItemResourceConstants.NAMESPACE));
            String workspaceUri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            request = new HttpReport(workspaceUri, info);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            Document reportDoc = request.getResponseBodyAsDocument(response.getEntity());
            Iterator<QNodeTypeDefinition> iterator = this.retrieveQNodeTypeDefinitions(sessionInfo, reportDoc);
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo, Name[] nodetypeNames) throws RepositoryException {
        return this.getQNodeTypeDefinitions(sessionInfo);
    }

    @Override
    public void registerNodeTypes(SessionInfo sessionInfo, QNodeTypeDefinition[] nodeTypeDefinitions, boolean allowUpdate) throws RepositoryException {
        HttpProppatch request = null;
        try {
            DavPropertySet setProperties = new DavPropertySet();
            setProperties.add(this.createRegisterNodeTypesProperty(sessionInfo, nodeTypeDefinitions, allowUpdate));
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            request = new HttpProppatch(uri, setProperties, new DavPropertyNameSet());
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, true);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public void unregisterNodeTypes(SessionInfo sessionInfo, Name[] nodeTypeNames) throws RepositoryException {
        HttpProppatch request = null;
        try {
            DavPropertySet setProperties = new DavPropertySet();
            setProperties.add(this.createUnRegisterNodeTypesProperty(sessionInfo, nodeTypeNames));
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            request = new HttpProppatch(uri, setProperties, new DavPropertyNameSet());
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, true);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public void createWorkspace(SessionInfo sessionInfo, String name, String srcWorkspaceName) throws RepositoryException {
        if (srcWorkspaceName != null) {
            throw new UnsupportedOperationException("JCR-2003. Implementation missing");
        }
        HttpMkworkspace request = null;
        try {
            request = new HttpMkworkspace(this.uriResolver.getWorkspaceUri(name));
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, true);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public void deleteWorkspace(SessionInfo sessionInfo, String name) throws RepositoryException {
        HttpDelete request = null;
        try {
            request = new HttpDelete(this.uriResolver.getWorkspaceUri(name));
            RepositoryServiceImpl.initMethod((HttpUriRequest)request, sessionInfo, true);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    public static URI computeRepositoryUri(String uri) throws URISyntaxException {
        boolean useDefaultPort;
        URI repositoryUri = URI.create(uri.endsWith("/") ? uri : uri + "/");
        boolean bl = useDefaultPort = "http".equalsIgnoreCase(repositoryUri.getScheme()) && repositoryUri.getPort() == 80 || "https".equalsIgnoreCase(repositoryUri.getScheme()) && repositoryUri.getPort() == 443;
        if (useDefaultPort) {
            repositoryUri = new URI(repositoryUri.getScheme(), repositoryUri.getUserInfo(), repositoryUri.getHost(), -1, repositoryUri.getPath(), repositoryUri.getQuery(), repositoryUri.getFragment());
        }
        return repositoryUri;
    }

    public HttpResponse executeRequest(SessionInfo sessionInfo, HttpUriRequest request) throws IOException, RepositoryException {
        return this.getClient(sessionInfo).execute(request, this.getContext(sessionInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<QNodeTypeDefinition> retrieveQNodeTypeDefinitions(SessionInfo sessionInfo, Document reportDoc) throws RepositoryException {
        ElementIterator it = DomUtil.getChildren(reportDoc.getDocumentElement(), "nodeType", null);
        ArrayList<QNodeTypeDefinition> ntDefs = new ArrayList<QNodeTypeDefinition>();
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        while (it.hasNext()) {
            ntDefs.add(DefinitionUtil.createQNodeTypeDefinition(it.nextElement(), resolver, this.getQValueFactory()));
        }
        Map<Name, QNodeTypeDefinition> map = this.nodeTypeDefinitions;
        synchronized (map) {
            this.nodeTypeDefinitions.clear();
            for (Object e : ntDefs) {
                QNodeTypeDefinition def = (QNodeTypeDefinition)e;
                this.nodeTypeDefinitions.put(def.getName(), def);
            }
        }
        return ntDefs.iterator();
    }

    private DavProperty<List<XmlSerializable>> createRegisterNodeTypesProperty(SessionInfo sessionInfo, QNodeTypeDefinition[] nodeTypeDefinitions, final boolean allowUpdate) throws IOException {
        ArrayList<XmlSerializable> val = new ArrayList<XmlSerializable>();
        StringWriter sw = new StringWriter();
        CompactNodeTypeDefWriter writer = new CompactNodeTypeDefWriter((Writer)sw, (NamespaceResolver)new NamespaceResolverImpl(sessionInfo), true);
        writer.write(Arrays.asList(nodeTypeDefinitions));
        writer.close();
        final String cnd = sw.toString();
        val.add(new XmlSerializable(){

            @Override
            public Element toXml(Document document) {
                Element cndElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:cnd");
                DomUtil.setText(cndElem, cnd);
                return cndElem;
            }
        });
        val.add(new XmlSerializable(){

            @Override
            public Element toXml(Document document) {
                Element allowElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:allowupdate");
                DomUtil.setText(allowElem, Boolean.toString(allowUpdate));
                return allowElem;
            }
        });
        return new DefaultDavProperty<List<XmlSerializable>>("nodetypes-cnd", val, ItemResourceConstants.NAMESPACE, false);
    }

    private DavProperty<List<XmlSerializable>> createUnRegisterNodeTypesProperty(SessionInfo sessionInfo, Name[] nodeTypeNames) throws IOException, RepositoryException {
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        ArrayList<3> val = new ArrayList<3>();
        for (Name ntName : nodeTypeNames) {
            final String jcrName = resolver.getJCRName(ntName);
            val.add(new XmlSerializable(){

                @Override
                public Element toXml(Document document) {
                    Element ntNameElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:nodetypename");
                    Text txt = document.createTextNode(jcrName);
                    ntNameElem.appendChild(txt);
                    return ntNameElem;
                }
            });
        }
        return new DefaultDavProperty<List<XmlSerializable>>("nodetypes-cnd", val, ItemResourceConstants.NAMESPACE, false);
    }

    private static DavProperty<List<XmlSerializable>> createValuesProperty(Value[] jcrValues) {
        ArrayList<4> val = new ArrayList<4>();
        for (final Value jcrValue : jcrValues) {
            val.add(new XmlSerializable(){

                @Override
                public Element toXml(Document document) {
                    try {
                        return ValueUtil.valueToXml(jcrValue, document);
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return new DefaultDavProperty<List<XmlSerializable>>("values", val, ItemResourceConstants.NAMESPACE, false);
    }

    private static DavProperty<List<XmlSerializable>> createNamespaceProperty(final Map<String, String> namespaces) {
        ArrayList<5> val = new ArrayList<5>();
        for (final String prefix : namespaces.keySet()) {
            val.add(new XmlSerializable(){

                @Override
                public Element toXml(Document document) {
                    Element nsElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:namespace");
                    Element prefixElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:prefix");
                    Text txt = document.createTextNode(prefix);
                    prefixElem.appendChild(txt);
                    String uri = (String)namespaces.get(prefix);
                    Element uriElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:uri");
                    Text txt2 = document.createTextNode(uri);
                    uriElem.appendChild(txt2);
                    nsElem.appendChild(prefixElem);
                    nsElem.appendChild(uriElem);
                    return nsElem;
                }
            });
        }
        return new DefaultDavProperty<List<XmlSerializable>>("namespaces", val, ItemResourceConstants.NAMESPACE, false);
    }

    private static DavProperty<List<XmlSerializable>> createNodeTypeProperty(String localName, String[] ntNames) {
        ArrayList<6> val = new ArrayList<6>();
        for (final String ntName : ntNames) {
            val.add(new XmlSerializable(){

                @Override
                public Element toXml(Document document) {
                    return NodeTypeUtil.ntNameToXml(ntName, document);
                }
            });
        }
        return new DefaultDavProperty<List<XmlSerializable>>(localName, val, ItemResourceConstants.NAMESPACE, false);
    }

    private Set<String> getDavComplianceClasses(SessionInfo sessionInfo) throws RepositoryException {
        if (this.remoteDavComplianceClasses == null) {
            HttpOptions request = new HttpOptions(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()));
            try {
                HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
                int status = response.getStatusLine().getStatusCode();
                if (status != 200) {
                    throw new DavException(status);
                }
                this.remoteDavComplianceClasses = request.getDavComplianceClasses(response);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                request.releaseConnection();
            }
        }
        return this.remoteDavComplianceClasses;
    }

    private boolean isDavClass3(SessionInfo sessionInfo) {
        try {
            return this.getDavComplianceClasses(sessionInfo).contains("3");
        }
        catch (RepositoryException ex) {
            log.warn("failure to obtain OPTIONS response", (Throwable)ex);
            return false;
        }
    }

    private static String obtainAbsolutePathFromUri(String uri) {
        try {
            URI u = new URI(uri);
            StringBuilder sb = new StringBuilder();
            sb.append(u.getRawPath());
            if (u.getRawQuery() != null) {
                sb.append("?").append(u.getRawQuery());
            }
            return sb.toString();
        }
        catch (URISyntaxException ex) {
            log.warn("parsing " + uri, (Throwable)ex);
            return uri;
        }
    }

    private static String[] obtainAbsolutePathsFromUris(String[] uris) {
        if (uris == null) {
            return null;
        }
        String[] result = new String[uris.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = RepositoryServiceImpl.obtainAbsolutePathFromUri(uris[i]);
        }
        return result;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("GET");
        tmp.add("HEAD");
        tmp.add("PROPFIND");
        tmp.add("POLL");
        tmp.add("REPORT");
        tmp.add("SEARCH");
        readMethods = Collections.unmodifiableSet(tmp);
    }

    private static class NamespaceCache
    extends AbstractNamespaceResolver {
        private final HashMap<String, String> prefixToURI = new HashMap();
        private final HashMap<String, String> uriToPrefix = new HashMap();

        private NamespaceCache() {
        }

        public Map<String, String> getNamespaces() {
            return new HashMap<String, String>(this.prefixToURI);
        }

        public void add(String prefix, String uri) {
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
        }

        public void remove(String prefix, String uri) {
            this.prefixToURI.remove(prefix);
            this.uriToPrefix.remove(uri);
        }

        @Override
        public String getURI(String prefix) throws NamespaceException {
            String uri = this.prefixToURI.get(prefix);
            if (uri != null) {
                return uri;
            }
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }

        @Override
        public String getPrefix(String uri) throws NamespaceException {
            String prefix = this.uriToPrefix.get(uri);
            if (prefix != null) {
                return prefix;
            }
            throw new NamespaceException(uri + ": is not a registered namespace uri.");
        }
    }

    private class NamePathResolverImpl
    implements NamePathResolver {
        private final NameResolver nResolver;
        private final PathResolver pResolver;

        private NamePathResolverImpl(SessionInfo sessionInfo) {
            NamespaceResolverImpl nsResolver = new NamespaceResolverImpl(sessionInfo);
            this.nResolver = new ParsingNameResolver(RepositoryServiceImpl.this.getNameFactory(), nsResolver);
            IdentifierResolverImpl idResolver = new IdentifierResolverImpl(sessionInfo);
            this.pResolver = new ParsingPathResolver(RepositoryServiceImpl.this.getPathFactory(), this.nResolver, idResolver);
        }

        private NamePathResolverImpl(NamespaceResolver nsResolver) {
            this.nResolver = new ParsingNameResolver(RepositoryServiceImpl.this.getNameFactory(), nsResolver);
            this.pResolver = new ParsingPathResolver(RepositoryServiceImpl.this.getPathFactory(), this.nResolver);
        }

        @Override
        public Name getQName(String jcrName) throws IllegalNameException, NamespaceException {
            return this.nResolver.getQName(jcrName);
        }

        @Override
        public String getJCRName(Name qName) throws NamespaceException {
            return this.nResolver.getJCRName(qName);
        }

        @Override
        public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
            return this.pResolver.getQPath(path);
        }

        @Override
        public Path getQPath(String path, boolean normalizeIdentifier) throws MalformedPathException, IllegalNameException, NamespaceException {
            return this.pResolver.getQPath(path, normalizeIdentifier);
        }

        @Override
        public String getJCRPath(Path path) throws NamespaceException {
            return this.pResolver.getJCRPath(path);
        }
    }

    private class IdentifierResolverImpl
    implements IdentifierResolver {
        private final SessionInfo sessionInfo;

        private IdentifierResolverImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        private Path buildPath(String uniqueID) throws RepositoryException {
            String uri = RepositoryServiceImpl.this.uriResolver.getItemUri(RepositoryServiceImpl.this.getIdFactory().createNodeId(uniqueID), this.sessionInfo.getWorkspaceName(), this.sessionInfo);
            return RepositoryServiceImpl.this.uriResolver.getQPath(uri, this.sessionInfo);
        }

        private Path resolvePath(String jcrPath) throws RepositoryException {
            return ((SessionInfoImpl)this.sessionInfo).getNamePathResolver().getQPath(jcrPath);
        }

        @Override
        public Path getPath(String identifier) throws MalformedPathException {
            try {
                int pos = identifier.indexOf(47);
                if (pos == -1) {
                    return this.buildPath(identifier);
                }
                if (pos == 0) {
                    return this.resolvePath(identifier);
                }
                Path p1 = this.buildPath(identifier.substring(0, pos));
                Path p2 = this.resolvePath(identifier.substring(pos));
                return RepositoryServiceImpl.this.getPathFactory().create(p1, p2, true);
            }
            catch (RepositoryException e) {
                throw new MalformedPathException(identifier);
            }
        }

        @Override
        public void checkFormat(String identifier) throws MalformedPathException {
        }
    }

    private class NamespaceResolverImpl
    implements NamespaceResolver {
        private final SessionInfo sessionInfo;

        private NamespaceResolverImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        @Override
        public String getURI(String prefix) throws NamespaceException {
            try {
                return RepositoryServiceImpl.this.getNamespaceURI(this.sessionInfo, prefix);
            }
            catch (RepositoryException e) {
                String msg = "Error retrieving namespace uri";
                throw new NamespaceException(msg, e);
            }
        }

        @Override
        public String getPrefix(String uri) throws NamespaceException {
            try {
                return RepositoryServiceImpl.this.getNamespacePrefix(this.sessionInfo, uri);
            }
            catch (RepositoryException e) {
                String msg = "Error retrieving namespace prefix";
                throw new NamespaceException(msg, e);
            }
        }
    }

    private class BatchImpl
    implements Batch {
        private final SessionInfo sessionInfo;
        private final ItemId targetId;
        private final List<HttpRequestBase> requests = new ArrayList<HttpRequestBase>();
        private final NamePathResolver resolver;
        private String batchId;
        private boolean isConsumed = false;
        private boolean clear = false;

        private BatchImpl(ItemId targetId, SessionInfo sessionInfo) throws RepositoryException {
            this.targetId = targetId;
            this.sessionInfo = sessionInfo;
            this.resolver = RepositoryServiceImpl.this.getNamePathResolver(sessionInfo);
        }

        private HttpClient start() throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(this.targetId, this.sessionInfo);
            HttpLock request = null;
            try {
                request = new HttpLock(uri, new org.apache.jackrabbit.webdav.lock.LockInfo(TransactionConstants.LOCAL, TransactionConstants.TRANSACTION, null, Integer.MAX_VALUE, true));
                RepositoryServiceImpl.initMethod((HttpUriRequest)request, this.sessionInfo, true);
                HttpClient client = RepositoryServiceImpl.this.getClient(this.sessionInfo);
                HttpResponse response = client.execute((HttpUriRequest)request, RepositoryServiceImpl.this.getContext(this.sessionInfo));
                if (response.getStatusLine().getStatusCode() == 412) {
                    throw new InvalidItemStateException("Unable to persist transient changes.");
                }
                request.checkSuccess(response);
                this.batchId = request.getLockToken(response);
                HttpClient httpClient = client;
                return httpClient;
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (request != null) {
                    request.releaseConnection();
                }
            }
        }

        private void end(HttpClient client, boolean commit) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(this.targetId, this.sessionInfo);
            HttpUnlock request = null;
            try {
                request = new HttpUnlock(uri, this.batchId);
                RepositoryServiceImpl.initMethod((HttpUriRequest)request, this.sessionInfo, true);
                request.setEntity(XmlEntity.create(new TransactionInfo(commit)));
                HttpResponse response = client.execute((HttpUriRequest)request, RepositoryServiceImpl.this.getContext(this.sessionInfo));
                request.checkSuccess(response);
                if (this.sessionInfo instanceof SessionInfoImpl) {
                    ((SessionInfoImpl)this.sessionInfo).setLastBatchId(this.batchId);
                }
                if (this.clear) {
                    RepositoryServiceImpl.this.clearItemUriCache(this.sessionInfo);
                }
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (request != null) {
                    request.releaseConnection();
                }
            }
        }

        private void dispose() {
            this.requests.clear();
            this.isConsumed = true;
        }

        private void checkConsumed() {
            if (this.isConsumed) {
                throw new IllegalStateException("Batch has already been consumed.");
            }
        }

        private boolean isEmpty() {
            return this.requests.isEmpty();
        }

        private Iterator<HttpRequestBase> requests() {
            return this.requests.iterator();
        }

        @Override
        public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
            this.checkConsumed();
            try {
                Name fakeName = RepositoryServiceImpl.this.getNameFactory().create("", UUID.randomUUID().toString());
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, fakeName, this.sessionInfo);
                HttpMkcol request = new HttpMkcol(uri);
                Document body = DomUtil.createDocument();
                BatchUtils.createNodeElement(body, nodeName, nodetypeName, uuid, this.resolver);
                request.setEntity(XmlEntity.create(body));
                this.requests.add((HttpRequestBase)request);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void addProperty(NodeId parentId, Name propertyName, QValue value) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(parentId, propertyName, this.sessionInfo);
            HttpPut request = new HttpPut(uri);
            request.setHeader("Content-Type", JcrValueType.contentTypeFromType(value.getType()));
            request.setEntity(this.getEntity(value));
            this.requests.add((HttpRequestBase)request);
        }

        @Override
        public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws RepositoryException {
            this.checkConsumed();
            try {
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, propertyName, this.sessionInfo);
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = ValueFormat.getJCRValue(values[i], this.resolver, RepositoryServiceImpl.this.valueFactory);
                }
                DavProperty vp = RepositoryServiceImpl.createValuesProperty(jcrValues);
                HttpPut request = new HttpPut(uri);
                request.setEntity(XmlEntity.create(vp));
                this.requests.add((HttpRequestBase)request);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void setValue(PropertyId propertyId, QValue value) throws RepositoryException {
            this.checkConsumed();
            if (value == null) {
                this.remove(propertyId);
            } else {
                HttpEntity ent = this.getEntity(value);
                String uri = RepositoryServiceImpl.this.getItemUri(propertyId, this.sessionInfo);
                HttpPut request = new HttpPut(uri);
                request.setHeader("Content-Type", JcrValueType.contentTypeFromType(value.getType()));
                request.setEntity(ent);
                this.requests.add((HttpRequestBase)request);
            }
        }

        @Override
        public void setValue(PropertyId propertyId, QValue[] values) throws RepositoryException {
            this.checkConsumed();
            if (values == null) {
                this.remove(propertyId);
            } else {
                DavPropertySet setProperties = new DavPropertySet();
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = ValueFormat.getJCRValue(values[i], this.resolver, RepositoryServiceImpl.this.valueFactory);
                }
                setProperties.add(RepositoryServiceImpl.createValuesProperty(jcrValues));
                try {
                    String uri = RepositoryServiceImpl.this.getItemUri(propertyId, this.sessionInfo);
                    HttpProppatch request = new HttpProppatch(uri, setProperties, new DavPropertyNameSet());
                    this.requests.add((HttpRequestBase)request);
                }
                catch (IOException e) {
                    throw new RepositoryException(e);
                }
            }
        }

        private HttpEntity getEntity(QValue value) throws RepositoryException {
            InputStreamEntity ent;
            int type = value.getType();
            String contentType = JcrValueType.contentTypeFromType(type);
            switch (type) {
                case 7: 
                case 8: {
                    String str = ValueFormat.getJCRString(value, this.resolver);
                    ent = new StringEntity(str, ContentType.create((String)contentType, (String)"UTF-8"));
                    break;
                }
                case 2: {
                    InputStream in = value.getStream();
                    ent = new InputStreamEntity(in, ContentType.create((String)contentType));
                    break;
                }
                default: {
                    String str = value.getString();
                    ent = new StringEntity(str, ContentType.create((String)contentType, (String)"UTF-8"));
                }
            }
            return ent;
        }

        @Override
        public void remove(ItemId itemId) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(itemId, this.sessionInfo);
            HttpDelete request = new HttpDelete(uri);
            this.requests.add((HttpRequestBase)request);
            if (itemId.getPath() == null) {
                this.clear = true;
            }
        }

        @Override
        public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
            this.checkConsumed();
            try {
                Position p;
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, this.sessionInfo);
                String srcUri = RepositoryServiceImpl.this.getItemUri(srcNodeId, this.sessionInfo);
                String srcSegment = org.apache.jackrabbit.util.Text.getName(srcUri, true);
                if (beforeNodeId == null) {
                    p = new Position("last");
                } else {
                    String beforeUri = RepositoryServiceImpl.this.getItemUri(beforeNodeId, this.sessionInfo);
                    String targetSegment = org.apache.jackrabbit.util.Text.getName(beforeUri, true);
                    p = new Position("before", targetSegment);
                }
                OrderPatch op = new OrderPatch("DAV:custom", new OrderPatch.Member(srcSegment, p));
                HttpOrderpatch request = new HttpOrderpatch(uri, op);
                this.requests.add((HttpRequestBase)request);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void setMixins(NodeId nodeId, Name[] mixinNodeTypeIds) throws RepositoryException {
            this.checkConsumed();
            try {
                DavPropertyNameSet removeProperties;
                DavPropertySet setProperties;
                if (mixinNodeTypeIds == null || mixinNodeTypeIds.length == 0) {
                    setProperties = new DavPropertySet();
                    removeProperties = new DavPropertyNameSet();
                    removeProperties.add("mixinnodetypes", ItemResourceConstants.NAMESPACE);
                } else {
                    String[] ntNames = new String[mixinNodeTypeIds.length];
                    for (int i = 0; i < mixinNodeTypeIds.length; ++i) {
                        ntNames[i] = this.resolver.getJCRName(mixinNodeTypeIds[i]);
                    }
                    setProperties = new DavPropertySet();
                    setProperties.add(RepositoryServiceImpl.createNodeTypeProperty("mixinnodetypes", ntNames));
                    removeProperties = new DavPropertyNameSet();
                }
                String uri = RepositoryServiceImpl.this.getItemUri(nodeId, this.sessionInfo);
                HttpProppatch request = new HttpProppatch(uri, setProperties, removeProperties);
                this.requests.add((HttpRequestBase)request);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void setPrimaryType(NodeId nodeId, Name primaryNodeTypeName) throws RepositoryException {
            this.checkConsumed();
            try {
                DavPropertySet setProperties = new DavPropertySet();
                setProperties.add(RepositoryServiceImpl.createNodeTypeProperty("primarynodetype", new String[]{this.resolver.getJCRName(primaryNodeTypeName)}));
                String uri = RepositoryServiceImpl.this.getItemUri(nodeId, this.sessionInfo);
                HttpProppatch request = new HttpProppatch(uri, setProperties, new DavPropertyNameSet());
                this.requests.add((HttpRequestBase)request);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(srcNodeId, this.sessionInfo);
            String destUri = RepositoryServiceImpl.this.getItemUri(destParentNodeId, destName, this.sessionInfo);
            if (RepositoryServiceImpl.this.isDavClass3(this.sessionInfo)) {
                destUri = RepositoryServiceImpl.obtainAbsolutePathFromUri(destUri);
            }
            HttpMove request = new HttpMove(uri, destUri, false);
            this.requests.add((HttpRequestBase)request);
            this.clear = true;
        }

        @Override
        public void setTree(NodeId parentId, Tree tree) throws RepositoryException {
            this.checkConsumed();
            if (!(tree instanceof DocumentTree)) {
                throw new RepositoryException("Invalid tree implementation " + tree.getClass().getName());
            }
            try {
                Name fakeName = RepositoryServiceImpl.this.getNameFactory().create("", UUID.randomUUID().toString());
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, fakeName, this.sessionInfo);
                HttpMkcol request = new HttpMkcol(uri);
                request.setEntity(XmlEntity.create(((DocumentTree)tree).toDocument()));
                this.requests.add((HttpRequestBase)request);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }
    }
}

