/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.observation;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventJournal;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.observation.EventImpl;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventJournalImpl
implements EventJournal {
    private static final Logger log = LoggerFactory.getLogger(EventJournalImpl.class);
    private final WorkspaceManager wspMgr;
    private final EventFilter filter;
    private final NamePathResolver resolver;
    private List<org.apache.jackrabbit.spi.Event> buffer = new LinkedList<org.apache.jackrabbit.spi.Event>();
    private long lastTimestamp = 0L;
    private long position = 0L;

    public EventJournalImpl(WorkspaceManager wspMgr, EventFilter filter, NamePathResolver resolver) {
        this.wspMgr = wspMgr;
        this.filter = filter;
        this.resolver = resolver;
    }

    @Override
    public void skipTo(long date) {
        while (!this.buffer.isEmpty()) {
            long eDate;
            try {
                eDate = this.buffer.get(0).getDate();
            }
            catch (RepositoryException e) {
                eDate = 0L;
            }
            if (eDate <= date) {
                this.buffer.remove(0);
                continue;
            }
            return;
        }
        this.lastTimestamp = date;
        this.refill();
    }

    @Override
    public Event nextEvent() {
        return (Event)this.next();
    }

    @Override
    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNext() {
        if (this.buffer.isEmpty()) {
            this.refill();
        }
        return !this.buffer.isEmpty();
    }

    public Object next() {
        if (this.hasNext()) {
            ++this.position;
            return new EventImpl(this.buffer.remove(0), this.resolver, this.wspMgr.getIdFactory());
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void refill() {
        try {
            EventBundle bundle = this.wspMgr.getEvents(this.filter, this.lastTimestamp);
            for (org.apache.jackrabbit.spi.Event e : bundle) {
                this.buffer.add(e);
                this.lastTimestamp = e.getDate();
            }
        }
        catch (RepositoryException e) {
            log.warn("Exception while refilling event journal buffer", (Throwable)e);
        }
    }
}

