/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;

public enum NumberType {
    VOID(Void.TYPE, Void.class, 0, 0),
    BOOLEAN((Class)Boolean.TYPE, (Class)Boolean.class, 0, 1){

        @Override
        public Comparable<?> nilValue() {
            return Boolean.FALSE;
        }

        @Override
        public Comparable<?> parse(String text) {
            Boolean n = Strings.parseBoolean(Objects.requireNonNull(text));
            if (n != null) {
                return n;
            }
            throw new IllegalArgumentException(Errors.format((short)15, text));
        }
    }
    ,
    BYTE((Class)Byte.TYPE, (Class)Byte.class, 1, 8){

        @Override
        public Comparable<?> nilValue() {
            return (byte)0;
        }

        @Override
        public Comparable<?> parse(String n) {
            return Byte.valueOf(n);
        }

        @Override
        public Number cast(Number n) {
            return n == null || n instanceof Byte ? (Number)n : (Number)n.byteValue();
        }

        @Override
        public Number wrapExact(long n) {
            return this.verify((Number)((byte)n), n);
        }

        @Override
        public Number wrapExact(double n) {
            return this.verify((Number)((byte)n), n);
        }
    }
    ,
    CHARACTER((Class)Character.TYPE, (Class)Character.class, 0, 16){

        @Override
        public boolean isWiderThan(NumberType other) {
            return other.ordinal() <= BYTE.ordinal();
        }

        @Override
        public boolean isNarrowerThan(NumberType other) {
            return other.isBetween(INTEGER, BIG_DECIMAL);
        }

        @Override
        public Comparable<?> nilValue() {
            return Character.valueOf('\u0000');
        }

        @Override
        public Comparable<?> parse(String text) {
            switch (text.length()) {
                case 0: {
                    return Character.valueOf('\u0000');
                }
                case 1: {
                    return Character.valueOf(text.charAt(0));
                }
            }
            throw new IllegalArgumentException(Errors.format((short)15, text));
        }
    }
    ,
    SHORT((Class)Short.TYPE, (Class)Short.class, 1, 16){

        @Override
        public Comparable<?> nilValue() {
            return (short)0;
        }

        @Override
        public Comparable<?> parse(String n) {
            return Short.valueOf(n);
        }

        @Override
        public Number cast(Number n) {
            return n == null || n instanceof Short ? (Number)n : (Number)n.shortValue();
        }

        @Override
        public Number wrapExact(long n) {
            return this.verify((Number)((short)n), n);
        }

        @Override
        public Number wrapExact(double n) {
            return this.verify((Number)((short)n), n);
        }
    }
    ,
    INTEGER((Class)Integer.TYPE, (Class)Integer.class, 1, 32){

        @Override
        public Comparable<?> nilValue() {
            return 0;
        }

        @Override
        public Comparable<?> parse(String n) {
            return Integer.valueOf(n);
        }

        @Override
        public Number cast(Number n) {
            return n == null || n instanceof Integer ? (Number)n : (Number)n.intValue();
        }

        @Override
        public Number wrapExact(long n) {
            return this.verify((Number)((int)n), n);
        }

        @Override
        public Number wrapExact(double n) {
            return this.verify((Number)((int)n), n);
        }

        @Override
        public boolean isConversionLossless(NumberType target) {
            return target.isBetween(INTEGER, BIG_DECIMAL) && target != FLOAT;
        }
    }
    ,
    FRACTION((Class)Fraction.class, (Class)Fraction.class, 2, 64){

        @Override
        public Comparable<?> nilValue() {
            return new Fraction(0, 0);
        }

        @Override
        public Comparable<?> parse(String n) {
            return new Fraction(n);
        }

        @Override
        public Number cast(Number n) {
            return n == null || n instanceof Fraction ? n : Fraction.valueOf(n.doubleValue());
        }

        @Override
        public Number wrapExact(double n) {
            return Fraction.valueOf(n);
        }

        @Override
        public Number wrapExact(long n) {
            return this.verify((Number)new Fraction((int)n, 1), n);
        }

        @Override
        public boolean isConversionLossless(NumberType target) {
            return this.equals((Object)target);
        }
    }
    ,
    LONG((Class)Long.TYPE, (Class)Long.class, 1, 64){

        @Override
        public Comparable<?> nilValue() {
            return 0L;
        }

        @Override
        public Comparable<?> parse(String n) {
            return Long.valueOf(n);
        }

        @Override
        public Number cast(Number n) {
            return n == null || n instanceof Long ? (Number)n : (Number)n.longValue();
        }

        @Override
        public Number wrapExact(long n) {
            return n;
        }

        @Override
        public Number wrapExact(double n) {
            return this.verify((Number)((long)n), n);
        }

        @Override
        public boolean isConversionLossless(NumberType target) {
            return target.isBetween(DOUBLE_DOUBLE, BIG_DECIMAL) || target == this;
        }
    }
    ,
    FLOAT((Class)Float.TYPE, (Class)Float.class, 2, 32){

        @Override
        public Comparable<?> nilValue() {
            return Float.valueOf(Float.NaN);
        }

        @Override
        public Comparable<?> parse(String n) {
            return Float.valueOf(n);
        }

        @Override
        public Number cast(Number n) {
            return n == null || n instanceof Float ? (Number)n : (Number)Float.valueOf(n.floatValue());
        }

        @Override
        public Number wrapExact(double n) {
            return this.verify((Number)Float.valueOf((float)n), n);
        }

        @Override
        public Number wrapExact(long n) {
            return this.verify((Number)Float.valueOf(n), n);
        }

        @Override
        public boolean isConversionLossless(NumberType target) {
            return target.isBetween(FLOAT, DOUBLE_DOUBLE);
        }
    }
    ,
    DOUBLE((Class)Double.TYPE, (Class)Double.class, 2, 64){

        @Override
        public Comparable<?> nilValue() {
            return Double.NaN;
        }

        @Override
        public Comparable<?> parse(String n) {
            return Double.valueOf(n);
        }

        @Override
        public Number cast(Number n) {
            return n == null || n instanceof Double ? (Number)n : (Number)n.doubleValue();
        }

        @Override
        public Number wrapExact(double n) {
            return n;
        }

        @Override
        public Number wrapExact(long n) {
            return this.verify((Number)n, n);
        }

        @Override
        public boolean isConversionLossless(NumberType target) {
            return target.isBetween(DOUBLE, DOUBLE_DOUBLE);
        }
    }
    ,
    DOUBLE_DOUBLE((Class)DoubleDouble.class, (Class)DoubleDouble.class, 2, -128){

        @Override
        public Comparable<?> nilValue() {
            return DoubleDouble.NaN;
        }

        @Override
        public Number wrapExact(long n) {
            return DoubleDouble.of(n);
        }

        @Override
        public Number wrapExact(double n) {
            return DoubleDouble.of(n, false);
        }

        @Override
        public Number cast(Number n) {
            return DoubleDouble.of(n, false);
        }
    }
    ,
    BIG_INTEGER((Class)BigInteger.class, (Class)BigInteger.class, 1, -1){

        @Override
        public Comparable<?> nilValue() {
            return BigInteger.ZERO;
        }

        @Override
        public Number wrapExact(long n) {
            return BigInteger.valueOf(n);
        }

        @Override
        public Number wrapExact(double n) {
            return this.verify((Number)BigDecimal.valueOf((long)n), n);
        }

        @Override
        public Comparable<?> parse(String n) {
            return new BigInteger(n);
        }

        @Override
        public Number cast(Number n) {
            if (n == null || n instanceof BigInteger) {
                return n;
            }
            if (n instanceof BigDecimal) {
                return ((BigDecimal)n).toBigInteger();
            }
            return BigInteger.valueOf(n.longValue());
        }
    }
    ,
    BIG_DECIMAL((Class)BigDecimal.class, (Class)BigDecimal.class, 2, -1){

        @Override
        public Comparable<?> nilValue() {
            return BigDecimal.ZERO;
        }

        @Override
        public Number wrapExact(long n) {
            return BigDecimal.valueOf(n);
        }

        @Override
        public Number wrapExact(double n) {
            return BigDecimal.valueOf(n);
        }

        @Override
        public Comparable<?> parse(String n) {
            return new BigDecimal(n);
        }

        @Override
        public Number cast(Number n) {
            if (n == null || n instanceof BigDecimal) {
                return n;
            }
            if (n instanceof BigInteger) {
                return new BigDecimal((BigInteger)n);
            }
            if (12.isInteger(n.getClass())) {
                return BigDecimal.valueOf(n.longValue());
            }
            return new BigDecimal(n.toString());
        }
    }
    ,
    NUMBER(Number.class, Number.class, 3, -1),
    NULL(null, null, 0, -1);

    final Class<?> primitive;
    final Class<?> wrapper;
    private final byte category;
    private final byte size;
    private static final Map<Class<?>, NumberType> MAPPING;

    private NumberType(Class<?> primitive, Class<?> wrapper, byte category, byte size) {
        this.primitive = primitive;
        this.wrapper = wrapper;
        this.category = category;
        this.size = size;
    }

    private static NumberType valueOrNull(Class<?> type) {
        return MAPPING.get(type);
    }

    public static Optional<NumberType> forClass(Class<?> type) {
        NumberType value = NumberType.valueOrNull(type);
        if (value == null && Number.class.isAssignableFrom(type)) {
            value = NUMBER;
        }
        return Optional.ofNullable(value);
    }

    public static NumberType forNumberClass(Class<?> type) {
        NumberType value = NumberType.valueOrNull(type);
        if (value != null) {
            return value;
        }
        if (Number.class.isAssignableFrom(type)) {
            return NUMBER;
        }
        throw new IllegalArgumentException(Errors.format((short)138, type));
    }

    public static Optional<NumberType> forClasses(Class<?> ... types) {
        return Optional.ofNullable(NumberType.forClasses(true, types));
    }

    public static NumberType forNumberClasses(Class<?> ... types) {
        return NumberType.forClasses(false, types);
    }

    private static NumberType forClasses(boolean optional, Class<?> ... types) {
        NumberType widest = VOID;
        boolean found = false;
        if (types != null) {
            block4: for (Class<?> type : types) {
                NumberType other = NumberType.forClass(type).orElse(null);
                if (other == null) {
                    if (optional) {
                        return null;
                    }
                    throw new IllegalArgumentException(Errors.format((short)138, type));
                }
                switch (other.ordinal()) {
                    case 14: {
                        continue block4;
                    }
                    case 13: {
                        widest = other;
                        continue block4;
                    }
                    default: {
                        found = true;
                        if (!widest.isNarrowerThan(other)) continue block4;
                        widest = other;
                    }
                }
            }
        }
        return found ? widest : NULL;
    }

    public final boolean isInteger() {
        return this.category == 1;
    }

    public static boolean isInteger(Class<?> type) {
        NumberType value = NumberType.valueOrNull(type);
        return value != null && value.isInteger();
    }

    public final boolean isFractional() {
        return this.category == 2;
    }

    public static boolean isFractional(Class<?> type) {
        NumberType value = NumberType.valueOrNull(type);
        return value != null && value.isFractional();
    }

    public final boolean isReal() {
        return this.category != 0;
    }

    public final boolean isConvertible() {
        return this.category == 1 || this.category == 2;
    }

    public static boolean isReal(Class<?> type) {
        NumberType value = NumberType.valueOrNull(type);
        return value != null && value.isReal();
    }

    final boolean isBetween(NumberType lower, NumberType upper) {
        return this.ordinal() >= lower.ordinal() && this.ordinal() <= upper.ordinal();
    }

    public boolean isNarrowerThan(NumberType other) {
        if (other == CHARACTER) {
            return other.isWiderThan(this);
        }
        return other.ordinal() < NUMBER.ordinal() && this.ordinal() < other.ordinal() && this.category <= other.category;
    }

    public boolean isWiderThan(NumberType other) {
        if (other == CHARACTER) {
            return other.isNarrowerThan(this);
        }
        return this.ordinal() < NUMBER.ordinal() && this.ordinal() > other.ordinal() && this.category >= other.category;
    }

    public boolean isConversionLossless(NumberType target) {
        return target == this || this.isNarrowerThan(target);
    }

    public final Class<?> classOfValues(boolean primitive) {
        return primitive ? this.primitive : this.wrapper;
    }

    public static <N> Class<N> primitiveToWrapper(Class<N> type) {
        NumberType value = NumberType.valueOrNull(type);
        return value != null ? value.wrapper : type;
    }

    public static <N> Class<N> wrapperToPrimitive(Class<N> type) {
        NumberType value = NumberType.valueOrNull(type);
        return value != null ? value.primitive : type;
    }

    public final OptionalInt size() {
        return this.size != -1 ? OptionalInt.of(Byte.toUnsignedInt(this.size)) : OptionalInt.empty();
    }

    final Number verify(Number number, long expected) {
        if (number.longValue() == expected) {
            return number;
        }
        throw new ArithmeticException(Errors.format((short)12, expected, this.wrapper));
    }

    final Number verify(Number number, double expected) {
        double unwrap = number.doubleValue();
        if (unwrap == expected || Double.isNaN(unwrap) && Double.isNaN(expected)) {
            return number;
        }
        throw new ArithmeticException(Errors.format((short)12, expected, this.wrapper));
    }

    public Number cast(Number number) {
        if (number == null) {
            return number;
        }
        throw new UnsupportedOperationException(Errors.format((short)182, (Object)this));
    }

    public Number wrapExact(double number) {
        throw new UnsupportedOperationException(Errors.format((short)12, number, this.wrapper));
    }

    public Number wrapExact(long number) {
        throw new UnsupportedOperationException(Errors.format((short)12, number, this.wrapper));
    }

    public Comparable<?> parse(String text) {
        throw new UnsupportedOperationException(Errors.format((short)186, this.wrapper, text));
    }

    public Comparable<?> nilValue() {
        return null;
    }

    static {
        MAPPING = new IdentityHashMap(13);
        for (NumberType e : NumberType.values()) {
            MAPPING.put(e.primitive, e);
            MAPPING.put(e.wrapper, e);
        }
    }
}

