/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.aries.util.manifest.BundleManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static boolean isBundle(File file) {
        BundleManifest bm = BundleManifest.fromBundle(file);
        return bm != null && bm.isValid();
    }

    public static List<URI> getBundlesRecursive(URI sourceDir) throws IOException {
        ArrayList<URI> filesFound = new ArrayList<URI>();
        if (sourceDir == null) {
            return filesFound;
        }
        if (sourceDir != null) {
            File[] subFiles;
            File sourceFile = new File(sourceDir);
            if (sourceFile.isFile()) {
                if (FileUtils.isBundle(sourceFile)) {
                    filesFound.add(sourceDir);
                }
            } else if (sourceFile.isDirectory() && (subFiles = sourceFile.listFiles()) != null && subFiles.length > 0) {
                for (File file : subFiles) {
                    filesFound.addAll(FileUtils.getBundlesRecursive(file.toURI()));
                }
            }
        }
        return filesFound;
    }
}

