/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.model;

import org.apache.servicecomb.router.exception.RouterIllegalParamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderRule.class);
    private String regex;
    private boolean caseInsensitive = true;
    private String exact;

    public boolean match(String str) {
        if (str == null) {
            return false;
        }
        if (this.exact == null && this.regex == null) {
            throw new RouterIllegalParamException("route management regex and exact can not br null at same time.");
        }
        if (this.caseInsensitive) {
            str = str.toLowerCase();
            this.exact = this.exact == null ? null : this.exact.toLowerCase();
            String string = this.regex = this.regex == null ? null : this.regex.toLowerCase();
        }
        if (this.exact != null && !str.equals(this.exact)) {
            return false;
        }
        try {
            if (this.regex != null && !str.matches(this.regex)) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("route management wrong regular expression format: {}", (Object)this.regex);
            return false;
        }
        return true;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public String getExact() {
        return this.exact;
    }

    public void setExact(String exact) {
        this.exact = exact;
    }

    public String toString() {
        return "HeaderRule{regex='" + this.regex + '\'' + ", caseInsensitive=" + this.caseInsensitive + ", exact='" + this.exact + '\'' + '}';
    }
}

